/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.glossaryview.client;

import java.util.List;
import java.util.stream.Collectors;
import org.odpi.openmetadata.accessservices.glossaryview.client.OmasClient;
import org.odpi.openmetadata.accessservices.glossaryview.exception.GlossaryViewOmasException;
import org.odpi.openmetadata.accessservices.glossaryview.rest.ExternalGlossaryLink;
import org.odpi.openmetadata.accessservices.glossaryview.rest.Glossary;
import org.odpi.openmetadata.accessservices.glossaryview.rest.GlossaryCategory;
import org.odpi.openmetadata.accessservices.glossaryview.rest.GlossaryTerm;
import org.odpi.openmetadata.accessservices.glossaryview.rest.GlossaryViewEntityDetail;
import org.odpi.openmetadata.accessservices.glossaryview.rest.GlossaryViewEntityDetailResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;

public class GlossaryViewClient
extends OmasClient {
    private static final String PATH_ROOT = "/servers/{0}/open-metadata/access-services/glossary-view/users/{1}";
    private static final String PARAM_DELIMITER = "?";
    private static final String PAGINATION = "from={3}&size={4}";
    private static final String GET_GLOSSARY = "/servers/{0}/open-metadata/access-services/glossary-view/users/{1}/glossaries/{2}";
    private static final String GET_GLOSSARIES = "/servers/{0}/open-metadata/access-services/glossary-view/users/{1}/glossaries?from={2}&size={3}";
    private static final String GET_TERM_HOME_GLOSSARY = "/servers/{0}/open-metadata/access-services/glossary-view/users/{1}/terms/{2}/home-glossary";
    private static final String GET_CATEGORY_HOME_GLOSSARY = "/servers/{0}/open-metadata/access-services/glossary-view/users/{1}/categories/{2}/home-glossary";
    private static final String GET_GLOSSARY_EXTERNAL_GLOSSARY_LINKS = "/servers/{0}/open-metadata/access-services/glossary-view/users/{1}/glossaries/{2}/external-glossary-links?from={3}&size={4}";
    private static final String GET_CATEGORIES = "/servers/{0}/open-metadata/access-services/glossary-view/users/{1}/categories";
    private static final String GET_CATEGORY = "/servers/{0}/open-metadata/access-services/glossary-view/users/{1}/categories/{2}";
    private static final String GET_CATEGORIES_OF_GLOSSARY = "/servers/{0}/open-metadata/access-services/glossary-view/users/{1}/glossaries/{2}/categories";
    private static final String GET_SUBCATEGORIES = "/servers/{0}/open-metadata/access-services/glossary-view/users/{1}/categories/{2}/subcategories";
    private static final String GET_CATEGORY_EXTERNAL_GLOSSARY_LINKS = "/servers/{0}/open-metadata/access-services/glossary-view/users/{1}/categories/{2}/external-glossary-links?from={3}&size={4}";
    private static final String GET_TERMS = "/servers/{0}/open-metadata/access-services/glossary-view/users/{1}/terms?from={2}&size={3}";
    private static final String GET_TERM = "/servers/{0}/open-metadata/access-services/glossary-view/users/{1}/terms/{2}";
    private static final String GET_TERMS_OF_GLOSSARY = "/servers/{0}/open-metadata/access-services/glossary-view/users/{1}/glossaries/{2}/terms";
    private static final String GET_TERMS_OF_CATEGORY = "/servers/{0}/open-metadata/access-services/glossary-view/users/{1}/categories/{2}/terms";
    private static final String GET_TERM_EXTERNAL_GLOSSARY_LINKS = "/servers/{0}/open-metadata/access-services/glossary-view/users/{1}/terms/{2}/external-glossary-links?from={3}&size={4}";
    private static final String GET_RELATED_TERMS = "/servers/{0}/open-metadata/access-services/glossary-view/users/{1}/terms/{2}/see-also?from={3}&size={4}";
    private static final String GET_SYNONYMS = "/servers/{0}/open-metadata/access-services/glossary-view/users/{1}/terms/{2}/synonyms?from={3}&size={4}";
    private static final String GET_ANTONYMS = "/servers/{0}/open-metadata/access-services/glossary-view/users/{1}/terms/{2}/antonyms?from={3}&size={4}";
    private static final String GET_PREFERRED_TERMS = "/servers/{0}/open-metadata/access-services/glossary-view/users/{1}/terms/{2}/preferred-terms?from={3}&size={4}";
    private static final String GET_REPLACEMENT_TERMS = "/servers/{0}/open-metadata/access-services/glossary-view/users/{1}/terms/{2}/replacement-terms?from={3}&size={4}";
    private static final String GET_TRANSLATIONS = "/servers/{0}/open-metadata/access-services/glossary-view/users/{1}/terms/{2}/translations-terms?from={3}&size={4}";
    private static final String GET_IS_A = "/servers/{0}/open-metadata/access-services/glossary-view/users/{1}/terms/{2}/is-a?from={3}&size={4}";
    private static final String GET_VALID_VALUES = "/servers/{0}/open-metadata/access-services/glossary-view/users/{1}/terms/{2}/valid-values?from={3}&size={4}";
    private static final String GET_USED_IN_CONTEXTS = "/servers/{0}/open-metadata/access-services/glossary-view/users/{1}/terms/{2}/used-in-contexts?from={3}&size={4}";
    private static final String GET_ASSIGNED_ELEMENTS = "/servers/{0}/open-metadata/access-services/glossary-view/users/{1}/terms/{2}/assigned-elements?from={3}&size={4}";
    private static final String GET_ATTRIBUTES = "/servers/{0}/open-metadata/access-services/glossary-view/users/{1}/terms/{2}/attributes?from={3}&size={4}";
    private static final String GET_SUBTYPES = "/servers/{0}/open-metadata/access-services/glossary-view/users/{1}/terms/{2}/subtypes?from={3}&size={4}";
    private static final String GET_TYPES = "/servers/{0}/open-metadata/access-services/glossary-view/users/{1}/terms/{2}/types?from={3}&size={4}";

    public GlossaryViewClient(String serverName, String serverPlatformRootURL) throws InvalidParameterException {
        super(serverName, serverPlatformRootURL);
    }

    public GlossaryViewClient(String serverName, String serverPlatformRootURL, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformRootURL, userId, password);
    }

    public List<Glossary> getAllGlossaries(String userId, Integer from, Integer size) throws PropertyServerException, org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException, GlossaryViewOmasException {
        GlossaryViewEntityDetailResponse response = this.getMultipleEntitiesPagedResponse("getAllGlossaries", GET_GLOSSARIES, this.serverName, userId, from, size);
        return this.castOmasResult(response.getResult());
    }

    public List<GlossaryTerm> getAllGlossaryTerms(String userId, Integer from, Integer size) throws PropertyServerException, org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException, GlossaryViewOmasException {
        GlossaryViewEntityDetailResponse response = this.getMultipleEntitiesPagedResponse("getAllGlossaryTerms", GET_TERMS, this.serverName, userId, from, size);
        return this.castOmasResult(response.getResult());
    }

    public List<GlossaryCategory> getAllCategories(String userId, Integer from, Integer size) throws PropertyServerException, org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException, GlossaryViewOmasException {
        GlossaryViewEntityDetailResponse response = this.getMultipleEntitiesPagedResponse("getAllCategories", GET_CATEGORIES, this.serverName, userId, from, size);
        return this.castOmasResult(response.getResult());
    }

    public Glossary getGlossary(String userId, String glossaryGUID) throws PropertyServerException, org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException, GlossaryViewOmasException {
        GlossaryViewEntityDetailResponse response = this.getSingleEntityResponse("getGlossary", GET_GLOSSARY, this.serverName, userId, glossaryGUID);
        return (Glossary)this.firstEntity(this.castOmasResult(response.getResult()));
    }

    public Glossary getTermHomeGlossary(String userId, String termGUID) throws PropertyServerException, org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException, GlossaryViewOmasException {
        GlossaryViewEntityDetailResponse response = this.getSingleEntityResponse("getTermHomeGlossary", GET_TERM_HOME_GLOSSARY, this.serverName, userId, termGUID);
        return (Glossary)this.firstEntity(this.castOmasResult(response.getResult()));
    }

    public Glossary getCategoryHomeGlossary(String userId, String categoryGUID) throws PropertyServerException, org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException, GlossaryViewOmasException {
        GlossaryViewEntityDetailResponse response = this.getSingleEntityResponse("getCategoryHomeGlossary", GET_CATEGORY_HOME_GLOSSARY, this.serverName, userId, categoryGUID);
        return (Glossary)this.firstEntity(this.castOmasResult(response.getResult()));
    }

    public List<ExternalGlossaryLink> getExternalGlossaryLinksOfGlossary(String userId, String glossaryGUID, Integer from, Integer size) throws PropertyServerException, org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException, GlossaryViewOmasException {
        GlossaryViewEntityDetailResponse response = this.getMultipleRelatedEntitiesPagedResponse("getExternalGlossaryLinksOfGlossary", GET_GLOSSARY_EXTERNAL_GLOSSARY_LINKS, this.serverName, userId, glossaryGUID, from, size);
        return this.castOmasResult(response.getResult());
    }

    public GlossaryCategory getCategory(String userId, String categoryGUID) throws PropertyServerException, org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException, GlossaryViewOmasException {
        GlossaryViewEntityDetailResponse response = this.getSingleEntityResponse("getCategory", GET_CATEGORY, this.serverName, userId, categoryGUID);
        return (GlossaryCategory)this.firstEntity(this.castOmasResult(response.getResult()));
    }

    public List<GlossaryCategory> getCategories(String userId, String glossaryGUID, Integer from, Integer size) throws PropertyServerException, org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException, GlossaryViewOmasException {
        GlossaryViewEntityDetailResponse response = this.getMultipleRelatedEntitiesPagedResponse("getCategories", GET_CATEGORIES_OF_GLOSSARY, this.serverName, userId, glossaryGUID, from, size);
        return this.castOmasResult(response.getResult());
    }

    public List<GlossaryCategory> getSubcategories(String userId, String categoryGUID, Integer from, Integer size) throws PropertyServerException, org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException, GlossaryViewOmasException {
        GlossaryViewEntityDetailResponse response = this.getMultipleRelatedEntitiesPagedResponse("getSubcategories", GET_SUBCATEGORIES, this.serverName, userId, categoryGUID, from, size);
        return this.castOmasResult(response.getResult());
    }

    public List<ExternalGlossaryLink> getExternalGlossaryLinksOfCategory(String userId, String categoryGUID, Integer from, Integer size) throws PropertyServerException, org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException, GlossaryViewOmasException {
        GlossaryViewEntityDetailResponse response = this.getMultipleRelatedEntitiesPagedResponse("getExternalGlossaryLinksOfCategory", GET_CATEGORY_EXTERNAL_GLOSSARY_LINKS, this.serverName, userId, categoryGUID, from, size);
        return this.castOmasResult(response.getResult());
    }

    public GlossaryTerm getTerm(String userId, String termGUID) throws PropertyServerException, org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException, GlossaryViewOmasException {
        GlossaryViewEntityDetailResponse response = this.getSingleEntityResponse("getTerm", GET_TERM, this.serverName, userId, termGUID);
        return (GlossaryTerm)this.castOmasResult(response.getResult()).get(0);
    }

    public List<GlossaryTerm> getTermsOfGlossary(String userId, String glossaryGUID, Integer from, Integer size) throws PropertyServerException, org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException, GlossaryViewOmasException {
        GlossaryViewEntityDetailResponse response = this.getMultipleRelatedEntitiesPagedResponse("getTermsOfGlossary", GET_TERMS_OF_GLOSSARY, this.serverName, userId, glossaryGUID, from, size);
        return this.castOmasResult(response.getResult());
    }

    public List<GlossaryTerm> getTermsOfCategory(String userId, String categoryGUID, Integer from, Integer size) throws PropertyServerException, org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException, GlossaryViewOmasException {
        GlossaryViewEntityDetailResponse response = this.getMultipleRelatedEntitiesPagedResponse("getTermsOfCategory", GET_TERMS_OF_CATEGORY, this.serverName, userId, categoryGUID, from, size);
        return this.castOmasResult(response.getResult());
    }

    public List<ExternalGlossaryLink> getExternalGlossaryLinksOfTerm(String userId, String termGUID, Integer from, Integer size) throws PropertyServerException, org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException, GlossaryViewOmasException {
        GlossaryViewEntityDetailResponse response = this.getMultipleRelatedEntitiesPagedResponse("getExternalGlossaryLinksOfTerm", GET_TERM_EXTERNAL_GLOSSARY_LINKS, this.serverName, userId, termGUID, from, size);
        return this.castOmasResult(response.getResult());
    }

    public List<GlossaryTerm> getRelatedTerms(String userId, String termGUID, Integer from, Integer size) throws PropertyServerException, org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException, GlossaryViewOmasException {
        GlossaryViewEntityDetailResponse response = this.getMultipleRelatedEntitiesPagedResponse("getRelatedTerms", GET_RELATED_TERMS, this.serverName, userId, termGUID, from, size);
        return this.castOmasResult(response.getResult());
    }

    public List<GlossaryTerm> getSynonyms(String userId, String termGUID, Integer from, Integer size) throws PropertyServerException, org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException, GlossaryViewOmasException {
        GlossaryViewEntityDetailResponse response = this.getMultipleRelatedEntitiesPagedResponse("getSynonyms", GET_SYNONYMS, this.serverName, userId, termGUID, from, size);
        return this.castOmasResult(response.getResult());
    }

    public List<GlossaryTerm> getAntonyms(String userId, String termGUID, Integer from, Integer size) throws PropertyServerException, org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException, GlossaryViewOmasException {
        GlossaryViewEntityDetailResponse response = this.getMultipleRelatedEntitiesPagedResponse("getAntonyms", GET_ANTONYMS, this.serverName, userId, termGUID, from, size);
        return this.castOmasResult(response.getResult());
    }

    public List<GlossaryTerm> getPreferredTerms(String userId, String termGUID, Integer from, Integer size) throws PropertyServerException, org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException, GlossaryViewOmasException {
        GlossaryViewEntityDetailResponse response = this.getMultipleRelatedEntitiesPagedResponse("getPreferredTerms", GET_PREFERRED_TERMS, this.serverName, userId, termGUID, from, size);
        return this.castOmasResult(response.getResult());
    }

    public List<GlossaryTerm> getReplacementTerms(String userId, String termGUID, Integer from, Integer size) throws PropertyServerException, org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException, GlossaryViewOmasException {
        GlossaryViewEntityDetailResponse response = this.getMultipleRelatedEntitiesPagedResponse("getReplacementTerms", GET_REPLACEMENT_TERMS, this.serverName, userId, termGUID, from, size);
        return this.castOmasResult(response.getResult());
    }

    public List<GlossaryTerm> getTranslations(String userId, String termGUID, Integer from, Integer size) throws PropertyServerException, org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException, GlossaryViewOmasException {
        GlossaryViewEntityDetailResponse response = this.getMultipleRelatedEntitiesPagedResponse("getTranslations", GET_TRANSLATIONS, this.serverName, userId, termGUID, from, size);
        return this.castOmasResult(response.getResult());
    }

    public List<GlossaryTerm> getIsA(String userId, String termGUID, Integer from, Integer size) throws PropertyServerException, org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException, GlossaryViewOmasException {
        GlossaryViewEntityDetailResponse response = this.getMultipleRelatedEntitiesPagedResponse("getIsA", GET_IS_A, this.serverName, userId, termGUID, from, size);
        return this.castOmasResult(response.getResult());
    }

    public List<GlossaryTerm> getValidValues(String userId, String termGUID, Integer from, Integer size) throws PropertyServerException, org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException, GlossaryViewOmasException {
        GlossaryViewEntityDetailResponse response = this.getMultipleRelatedEntitiesPagedResponse("getValidValues", GET_VALID_VALUES, this.serverName, userId, termGUID, from, size);
        return this.castOmasResult(response.getResult());
    }

    public List<GlossaryTerm> getUsedInContexts(String userId, String termGUID, Integer from, Integer size) throws PropertyServerException, org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException, GlossaryViewOmasException {
        GlossaryViewEntityDetailResponse response = this.getMultipleRelatedEntitiesPagedResponse("getUsedInContexts", GET_USED_IN_CONTEXTS, this.serverName, userId, termGUID, from, size);
        return this.castOmasResult(response.getResult());
    }

    public List<GlossaryTerm> getAssignedElements(String userId, String termGUID, Integer from, Integer size) throws PropertyServerException, org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException, GlossaryViewOmasException {
        GlossaryViewEntityDetailResponse response = this.getMultipleRelatedEntitiesPagedResponse("getAssignedElements", GET_ASSIGNED_ELEMENTS, this.serverName, userId, termGUID, from, size);
        return this.castOmasResult(response.getResult());
    }

    public List<GlossaryTerm> getAttributes(String userId, String termGUID, Integer from, Integer size) throws PropertyServerException, org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException, GlossaryViewOmasException {
        GlossaryViewEntityDetailResponse response = this.getMultipleRelatedEntitiesPagedResponse("getAttributes", GET_ATTRIBUTES, this.serverName, userId, termGUID, from, size);
        return this.castOmasResult(response.getResult());
    }

    public List<GlossaryTerm> getSubtypes(String userId, String termGUID, Integer from, Integer size) throws PropertyServerException, org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException, GlossaryViewOmasException {
        GlossaryViewEntityDetailResponse response = this.getMultipleRelatedEntitiesPagedResponse("getSubtypes", GET_SUBTYPES, this.serverName, userId, termGUID, from, size);
        return this.castOmasResult(response.getResult());
    }

    public List<GlossaryTerm> getTypes(String userId, String termGUID, Integer from, Integer size) throws PropertyServerException, org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException, GlossaryViewOmasException {
        GlossaryViewEntityDetailResponse response = this.getMultipleRelatedEntitiesPagedResponse("getTypes", GET_TYPES, this.serverName, userId, termGUID, from, size);
        return this.castOmasResult(response.getResult());
    }

    private <T extends GlossaryViewEntityDetail> List<T> castOmasResult(List<GlossaryViewEntityDetail> omasResult) {
        return omasResult.stream().map(e -> e).collect(Collectors.toList());
    }

    private <T extends GlossaryViewEntityDetail> T firstEntity(List<T> entities) {
        if (entities == null) {
            return null;
        }
        if (entities.size() == 1) {
            return (T)((GlossaryViewEntityDetail)entities.get(0));
        }
        return null;
    }
}

