/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.glossaryview.server.service;

import java.util.List;
import java.util.Optional;
import org.odpi.openmetadata.accessservices.glossaryview.exception.GlossaryViewOmasException;
import org.odpi.openmetadata.accessservices.glossaryview.server.service.GlossaryViewInstanceHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class OMRSClient {
    private GlossaryViewInstanceHandler instanceHandler = new GlossaryViewInstanceHandler();

    protected Optional<EntityDetail> getEntityDetail(String userId, String serverName, String guid, String entityTypeName, String methodName) throws GlossaryViewOmasException {
        Optional<EntityDetail> entityDetail;
        try {
            entityDetail = Optional.ofNullable(this.instanceHandler.getRepositoryHandler(userId, serverName, methodName).getEntityByGUID(userId, guid, "guid", entityTypeName, methodName));
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            throw new GlossaryViewOmasException(e.getReportedHTTPCode(), e.getReportingClassName(), e.getReportingActionDescription(), e.getErrorMessage(), e.getReportedSystemAction(), e.getReportedUserAction());
        }
        return entityDetail;
    }

    protected List<EntityDetail> getRelatedEntities(String userId, String serverName, String entityGUID, String entityTypeName, String relationshipTypeGUID, String relationshipTypeName, Integer from, Integer size, String methodName) throws GlossaryViewOmasException {
        List entityDetails;
        try {
            entityDetails = this.instanceHandler.getRepositoryHandler(userId, serverName, methodName).getEntitiesForRelationshipType(userId, entityGUID, entityTypeName, relationshipTypeGUID, relationshipTypeName, from.intValue(), size.intValue(), methodName);
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            throw new GlossaryViewOmasException(e.getReportedHTTPCode(), e.getReportingClassName(), e.getReportingActionDescription(), e.getErrorMessage(), e.getReportedSystemAction(), e.getReportedUserAction());
        }
        return entityDetails;
    }

    protected List<EntityDetail> getSubEntities(String userId, String serverName, String entityGUID, String entityTypeName, boolean anchorAtEnd1, String relationshipTypeGUID, String relationshipTypeName, Integer from, Integer size, String methodName) throws GlossaryViewOmasException {
        List entityDetails;
        try {
            entityDetails = this.instanceHandler.getRepositoryHandler(userId, serverName, methodName).getEntitiesForRelationshipEnd(userId, entityGUID, entityTypeName, anchorAtEnd1, relationshipTypeGUID, relationshipTypeName, from.intValue(), size.intValue(), methodName);
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            throw new GlossaryViewOmasException(e.getReportedHTTPCode(), e.getReportingClassName(), e.getReportingActionDescription(), e.getErrorMessage(), e.getReportedSystemAction(), e.getReportedUserAction());
        }
        return entityDetails;
    }

    protected List<EntityDetail> getAllEntityDetails(String userId, String serverName, String entityTypeGUID, Integer from, Integer size, String methodName) throws GlossaryViewOmasException {
        List entities;
        try {
            entities = this.instanceHandler.getRepositoryHandler(userId, serverName, methodName).getEntitiesByType(userId, entityTypeGUID, from.intValue(), size.intValue(), methodName);
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            throw new GlossaryViewOmasException(e.getReportedHTTPCode(), e.getReportingClassName(), e.getReportingActionDescription(), e.getErrorMessage(), e.getReportedSystemAction(), e.getReportedUserAction());
        }
        return entities;
    }

    protected Optional<OMRSRepositoryHelper> getOMRSRepositoryHelper(String userId, String serverName, String serviceOperationName) {
        Optional<OMRSRepositoryHelper> helper = Optional.empty();
        try {
            helper = Optional.ofNullable(this.instanceHandler.getRepositoryConnector(userId, serverName, serviceOperationName).getRepositoryHelper());
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            return helper;
        }
        return helper;
    }
}

