/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.glossaryview.server.service;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.odpi.openmetadata.accessservices.glossaryview.converters.EntityDetailToGlossaryViewEntityDetail;
import org.odpi.openmetadata.accessservices.glossaryview.exception.GlossaryViewOmasException;
import org.odpi.openmetadata.accessservices.glossaryview.rest.GlossaryViewEntityDetail;
import org.odpi.openmetadata.accessservices.glossaryview.rest.GlossaryViewEntityDetailResponse;
import org.odpi.openmetadata.accessservices.glossaryview.server.service.OMRSClient;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GlossaryViewOMAS
extends OMRSClient {
    private static final String GLOSSARY_VIEW_OMAS = "Glossary View OMAS";
    private final Predicate<EntityDetail> effectiveTimePredicate = entityDetail -> {
        if (entityDetail.getProperties() == null) {
            return true;
        }
        Date effectiveFromTime = entityDetail.getProperties().getEffectiveFromTime();
        Date effectiveToTime = entityDetail.getProperties().getEffectiveToTime();
        if (effectiveFromTime == null || effectiveToTime == null) {
            return true;
        }
        long now = Calendar.getInstance().getTimeInMillis();
        return effectiveFromTime.getTime() <= now && now <= effectiveToTime.getTime();
    };
    private final Function<EntityDetail, GlossaryViewEntityDetail> entityDetailConverter = new EntityDetailToGlossaryViewEntityDetail();

    protected GlossaryViewEntityDetailResponse getEntityDetailResponse(String userId, String serverName, String entityGUID, String entityTypeName, String methodName) {
        GlossaryViewEntityDetailResponse response = new GlossaryViewEntityDetailResponse();
        try {
            Optional<EntityDetail> entityDetail = this.getEntityDetail(userId, serverName, entityGUID, entityTypeName, methodName);
            entityDetail.ifPresent(detail -> response.addEntityDetail(this.entityDetailConverter.apply((EntityDetail)detail)));
        }
        catch (GlossaryViewOmasException ew) {
            this.prepare(response, ew.getReportedHTTPCode(), ew.getReportingClassName(), ew.getReportingActionDescription(), ew.getReportedUserAction(), ew.getErrorMessage(), ew.getReportedSystemAction(), ew.getRelatedProperties());
        }
        return response;
    }

    protected GlossaryViewEntityDetailResponse getRelatedEntitiesResponse(String userId, String serverName, String entityGUID, String entityTypeName, String relationshipTypeName, Integer from, Integer size, String methodName) {
        GlossaryViewEntityDetailResponse response = new GlossaryViewEntityDetailResponse();
        try {
            String relationshipTypeGUID = this.getTypeDefGUID(relationshipTypeName, userId, serverName);
            List<EntityDetail> entities = this.getRelatedEntities(userId, serverName, entityGUID, entityTypeName, relationshipTypeGUID, relationshipTypeName, from, size, methodName);
            if (entities == null) {
                return response;
            }
            response.addEntityDetails(entities.stream().filter(entity -> !entity.getGUID().equals(entityGUID)).filter(this.effectiveTimePredicate).map(this.entityDetailConverter).collect(Collectors.toList()));
        }
        catch (GlossaryViewOmasException ew) {
            this.prepare(response, ew.getReportedHTTPCode(), ew.getReportingClassName(), ew.getReportingActionDescription(), ew.getReportedUserAction(), ew.getErrorMessage(), ew.getReportedSystemAction(), ew.getRelatedProperties());
        }
        return response;
    }

    protected GlossaryViewEntityDetailResponse getSubEntitiesResponse(String userId, String serverName, String entityGUID, String entityTypeName, boolean anchorAtEnd1, String relationshipTypeName, Integer from, Integer size, String methodName) {
        GlossaryViewEntityDetailResponse response = new GlossaryViewEntityDetailResponse();
        try {
            String relationshipTypeGUID = this.getTypeDefGUID(relationshipTypeName, userId, serverName);
            List<EntityDetail> entities = this.getSubEntities(userId, serverName, entityGUID, entityTypeName, anchorAtEnd1, relationshipTypeGUID, relationshipTypeName, from, size, methodName);
            if (entities == null) {
                return response;
            }
            response.addEntityDetails(entities.stream().filter(entity -> !entity.getGUID().equals(entityGUID)).filter(this.effectiveTimePredicate).map(this.entityDetailConverter).collect(Collectors.toList()));
        }
        catch (GlossaryViewOmasException ew) {
            this.prepare(response, ew.getReportedHTTPCode(), ew.getReportingClassName(), ew.getReportingActionDescription(), ew.getReportedUserAction(), ew.getErrorMessage(), ew.getReportedSystemAction(), ew.getRelatedProperties());
        }
        return response;
    }

    protected GlossaryViewEntityDetailResponse getAllEntityDetailsResponse(String userId, String serverName, String entityTypeName, Integer from, Integer size, String methodName) {
        GlossaryViewEntityDetailResponse response = new GlossaryViewEntityDetailResponse();
        try {
            String entityTypeGUID = this.getTypeDefGUID(entityTypeName, userId, serverName);
            List<EntityDetail> entities = this.getAllEntityDetails(userId, serverName, entityTypeGUID, from, size, methodName);
            if (entities == null) {
                return response;
            }
            response.addEntityDetails(entities.stream().filter(this.effectiveTimePredicate).map(this.entityDetailConverter).collect(Collectors.toList()));
        }
        catch (GlossaryViewOmasException ew) {
            this.prepare(response, ew.getReportedHTTPCode(), ew.getReportingClassName(), ew.getReportingActionDescription(), ew.getReportedUserAction(), ew.getErrorMessage(), ew.getReportedSystemAction(), ew.getRelatedProperties());
        }
        return response;
    }

    private void prepare(GlossaryViewEntityDetailResponse response, int httpCode, String className, String actionDescription, String userAction, String errorMessage, String systemAction, Map<String, Object> properties) {
        response.setRelatedHTTPCode(httpCode);
        response.setExceptionClassName(className);
        response.setActionDescription(actionDescription);
        response.setExceptionUserAction(userAction);
        response.setExceptionErrorMessage(errorMessage);
        response.setExceptionSystemAction(systemAction);
        response.setExceptionProperties(properties);
    }

    private String getTypeDefGUID(String typeDefName, String userId, String serverName) throws GlossaryViewOmasException {
        String methodName = "getTypeDefGUID";
        try {
            OMRSRepositoryHelper helper = this.instanceHandler.getRepositoryConnector(userId, serverName, "getTypeDefGUID").getRepositoryHelper();
            if (helper != null) {
                return helper.getTypeDefByName(GLOSSARY_VIEW_OMAS, typeDefName).getGUID();
            }
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            throw new GlossaryViewOmasException(e.getReportedHTTPCode(), e.getReportingClassName(), e.getReportingActionDescription(), e.getErrorMessage(), e.getReportedSystemAction(), e.getReportedUserAction());
        }
        throw new GlossaryViewOmasException(500, GlossaryViewOmasException.class.getSimpleName(), "getTypeDefGUID", "GLOSSARY-VIEW-OMAS-001 Unable to retrieve repository helper", "Reached a line of code that should never be reached.", "This is logic error - raise an issue");
    }
}

