/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.glossaryview.server.admin;

import org.odpi.openmetadata.accessservices.glossaryview.server.admin.GlossaryViewAuditCode;
import org.odpi.openmetadata.accessservices.glossaryview.server.admin.GlossaryViewServiceInstance;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceAdmin;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class GlossaryViewAdmin
extends AccessServiceAdmin {
    private OMRSAuditLog auditLog;
    private GlossaryViewServiceInstance instance;
    private String serverName;

    public void initialize(AccessServiceConfig accessServiceConfig, OMRSTopicConnector enterpriseOMRSTopicConnector, OMRSRepositoryConnector repositoryConnector, OMRSAuditLog auditLog, String serverUserName) {
        String actionDescription = "initialize Glossary View OMAS";
        this.auditLog = auditLog;
        try {
            GlossaryViewAuditCode auditCode = GlossaryViewAuditCode.SERVICE_INITIALIZING;
            auditLog.logRecord("initialize Glossary View OMAS", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
            this.instance = new GlossaryViewServiceInstance(repositoryConnector, auditLog, serverUserName, repositoryConnector.getMaxPageSize());
            this.serverName = this.instance.getServerName();
            auditCode = GlossaryViewAuditCode.SERVICE_INITIALIZED;
            auditLog.logRecord("initialize Glossary View OMAS", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.serverName), accessServiceConfig.toString(), auditCode.getSystemAction(), auditCode.getUserAction());
        }
        catch (Throwable error) {
            GlossaryViewAuditCode auditCode = GlossaryViewAuditCode.SERVICE_INSTANCE_FAILURE;
            auditLog.logException("initialize Glossary View OMAS", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(error.getMessage()), accessServiceConfig.toString(), auditCode.getSystemAction(), auditCode.getUserAction(), error);
        }
    }

    public void shutdown() {
        if (this.instance != null) {
            this.instance.shutdown();
        }
        if (this.auditLog != null) {
            String actionDescription = "shutdown";
            GlossaryViewAuditCode auditCode = GlossaryViewAuditCode.SERVICE_SHUTDOWN;
            this.auditLog.logRecord("shutdown", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.serverName), null, auditCode.getSystemAction(), auditCode.getUserAction());
        }
    }
}

