/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.glossaryview.server.service;

import java.util.List;
import java.util.Optional;
import org.odpi.openmetadata.accessservices.glossaryview.exception.GlossaryViewOmasException;
import org.odpi.openmetadata.accessservices.glossaryview.server.service.GlossaryViewInstanceHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;

public class OMRSClient {
    private static final String DEFAULT_ACTION_DESCRIPTION_PREFIX = "Internal server error thrown by OMRS when executing";
    private static final String DEFAULT_SYSTEM_ACTION = "No known system actions performed";
    private static final String DEFAULT_USER_ACTION = "Possible user actions: retry or check logs";
    protected GlossaryViewInstanceHandler instanceHandler = new GlossaryViewInstanceHandler();

    protected Optional<EntityDetail> getEntityDetail(String userId, String serverName, String guid, String entityTypeName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, GlossaryViewOmasException {
        Optional<EntityDetail> entityDetail;
        try {
            entityDetail = Optional.ofNullable(this.instanceHandler.getRepositoryHandler(userId, serverName, methodName).getEntityByGUID(userId, guid, "guid", entityTypeName, methodName));
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GlossaryViewOmasException(500, this.getClass().getName(), "Internal server error thrown by OMRS when executing getEntityByGUID: guid " + guid + " entityTypeName" + entityTypeName, e.getClass() + " - " + e.getMessage(), DEFAULT_SYSTEM_ACTION, DEFAULT_USER_ACTION);
        }
        return entityDetail;
    }

    protected List<EntityDetail> getRelatedEntities(String userId, String serverName, String entityGUID, String entityTypeName, String relationshipTypeGUID, String relationshipTypeName, Integer from, Integer size, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, GlossaryViewOmasException {
        List entityDetails;
        try {
            entityDetails = this.instanceHandler.getRepositoryHandler(userId, serverName, methodName).getEntitiesForRelationshipType(userId, entityGUID, entityTypeName, relationshipTypeGUID, relationshipTypeName, from.intValue(), size.intValue(), methodName);
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GlossaryViewOmasException(500, this.getClass().getName(), "Internal server error thrown by OMRS when executing getEntitiesForRelationshipType: entityGUID " + entityGUID + " entityTypeName " + entityTypeName + " relationshipTypeGUID " + relationshipTypeGUID + " relationshipTypeName " + relationshipTypeName, e.getClass() + " - " + e.getMessage(), DEFAULT_SYSTEM_ACTION, DEFAULT_USER_ACTION);
        }
        return entityDetails;
    }

    protected List<EntityDetail> getSubEntities(String userId, String serverName, String entityGUID, String entityTypeName, boolean anchorAtEnd1, String relationshipTypeGUID, String relationshipTypeName, Integer from, Integer size, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, GlossaryViewOmasException {
        List entityDetails;
        try {
            entityDetails = this.instanceHandler.getRepositoryHandler(userId, serverName, methodName).getEntitiesForRelationshipEnd(userId, entityGUID, entityTypeName, anchorAtEnd1, relationshipTypeGUID, relationshipTypeName, from.intValue(), size.intValue(), methodName);
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GlossaryViewOmasException(500, this.getClass().getName(), "Internal server error thrown by OMRS when executing getEntitiesForRelationshipEnd: guid " + entityGUID + " entityTypeName " + entityTypeName + " anchorAtEnd1 " + anchorAtEnd1 + " relationshipTypeGUID " + relationshipTypeGUID + " relationshipTypeName " + relationshipTypeName, e.getClass() + " - " + e.getMessage(), DEFAULT_SYSTEM_ACTION, DEFAULT_USER_ACTION);
        }
        return entityDetails;
    }

    protected List<EntityDetail> getAllEntityDetails(String userId, String serverName, String entityTypeGUID, Integer from, Integer size, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, GlossaryViewOmasException {
        List entities;
        try {
            entities = this.instanceHandler.getRepositoryHandler(userId, serverName, methodName).getEntitiesByType(userId, entityTypeGUID, from.intValue(), size.intValue(), methodName);
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GlossaryViewOmasException(500, this.getClass().getName(), "Internal server error thrown by OMRS when executing getEntitiesByType: entityTypeGUID " + entityTypeGUID, e.getClass() + " - " + e.getMessage(), DEFAULT_SYSTEM_ACTION, DEFAULT_USER_ACTION);
        }
        return entities;
    }
}

