/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.glossaryview.server.admin;

import org.odpi.openmetadata.accessservices.glossaryview.server.admin.GlossaryViewAuditCode;
import org.odpi.openmetadata.accessservices.glossaryview.server.admin.GlossaryViewServiceInstance;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.registration.AccessServiceAdmin;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class GlossaryViewAdmin
extends AccessServiceAdmin {
    private AuditLog auditLog;
    private GlossaryViewServiceInstance instance;
    private String serverName;

    public void initialize(AccessServiceConfig accessServiceConfig, OMRSTopicConnector enterpriseOMRSTopicConnector, OMRSRepositoryConnector repositoryConnector, AuditLog auditLog, String serverUserName) {
        String actionDescription = "initialize Glossary View OMAS";
        this.auditLog = auditLog;
        try {
            GlossaryViewAuditCode auditCode = GlossaryViewAuditCode.SERVICE_INITIALIZING;
            AuditLogMessageDefinition messageDefinition = new AuditLogMessageDefinition(auditCode.getLogMessageId(), (AuditLogRecordSeverity)auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.serverName), auditCode.getSystemAction(), auditCode.getUserAction());
            auditLog.logMessage("initialize Glossary View OMAS", messageDefinition);
            this.instance = new GlossaryViewServiceInstance(repositoryConnector, auditLog, serverUserName, repositoryConnector.getMaxPageSize());
            this.serverName = this.instance.getServerName();
            auditCode = GlossaryViewAuditCode.SERVICE_INITIALIZED;
            messageDefinition = new AuditLogMessageDefinition(auditCode.getLogMessageId(), (AuditLogRecordSeverity)auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.serverName), auditCode.getSystemAction(), auditCode.getUserAction());
            auditLog.logMessage("initialize Glossary View OMAS", messageDefinition);
        }
        catch (Exception error) {
            GlossaryViewAuditCode auditCode = GlossaryViewAuditCode.SERVICE_INSTANCE_FAILURE;
            AuditLogMessageDefinition messageDefinition = new AuditLogMessageDefinition(auditCode.getLogMessageId(), (AuditLogRecordSeverity)auditCode.getSeverity(), auditCode.getFormattedLogMessage(error.getMessage()), auditCode.getSystemAction(), auditCode.getUserAction());
            auditLog.logException("initialize Glossary View OMAS", messageDefinition, (Throwable)error);
        }
    }

    public void shutdown() {
        if (this.instance != null) {
            this.instance.shutdown();
        }
        if (this.auditLog != null) {
            String actionDescription = "shutdown";
            GlossaryViewAuditCode auditCode = GlossaryViewAuditCode.SERVICE_SHUTDOWN;
            AuditLogMessageDefinition messageDefinition = new AuditLogMessageDefinition(auditCode.getLogMessageId(), (AuditLogRecordSeverity)auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.serverName), auditCode.getSystemAction(), auditCode.getUserAction());
            this.auditLog.logMessage("shutdown", messageDefinition);
        }
    }
}

