/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.glossaryview.server.service;

import java.util.List;
import java.util.Optional;
import org.odpi.openmetadata.accessservices.glossaryview.exception.GlossaryViewOmasException;
import org.odpi.openmetadata.accessservices.glossaryview.rest.GlossaryViewEntityDetail;
import org.odpi.openmetadata.accessservices.glossaryview.server.service.GlossaryViewInstanceHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;

public class OMRSClient {
    private static final String DEFAULT_ACTION_DESCRIPTION_PREFIX = "Internal server error thrown by OMRS when executing";
    private static final String DEFAULT_SYSTEM_ACTION = "No known system actions performed";
    private static final String DEFAULT_USER_ACTION = "Possible user actions: retry or check logs";
    protected GlossaryViewInstanceHandler instanceHandler = new GlossaryViewInstanceHandler();

    protected Optional<EntityDetail> getEntityDetail(String userId, String serverName, String guid, String entityTypeName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, GlossaryViewOmasException {
        Optional<EntityDetail> entityDetail;
        try {
            OpenMetadataAPIGenericHandler<GlossaryViewEntityDetail> entitiesHandler = this.instanceHandler.getEntitiesHandler(userId, serverName, methodName);
            entityDetail = Optional.ofNullable(entitiesHandler.getEntityFromRepository(userId, guid, "guid", entityTypeName, null, null, false, false, null, null, methodName));
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GlossaryViewOmasException(500, this.getClass().getName(), "Internal server error thrown by OMRS when executing getEntityFromRepository: guid " + guid + " entityTypeName" + entityTypeName, e.getClass() + " - " + e.getMessage(), DEFAULT_SYSTEM_ACTION, DEFAULT_USER_ACTION);
        }
        return entityDetail;
    }

    protected List<EntityDetail> getRelatedEntities(String userId, String serverName, String entityGUID, String entityTypeName, String relationshipTypeGUID, String relationshipTypeName, Integer from, Integer size, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, GlossaryViewOmasException {
        List entityDetails;
        try {
            OpenMetadataAPIGenericHandler<GlossaryViewEntityDetail> entitiesHandler = this.instanceHandler.getEntitiesHandler(userId, serverName, methodName);
            entityDetails = entitiesHandler.getAttachedEntities(userId, entityGUID, "guid", entityTypeName, relationshipTypeGUID, relationshipTypeName, null, null, null, 0, false, false, from.intValue(), size.intValue(), null, methodName);
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GlossaryViewOmasException(500, this.getClass().getName(), "Internal server error thrown by OMRS when executing getAttachedEntities: entityGUID " + entityGUID + " entityTypeName " + entityTypeName + " relationshipTypeGUID " + relationshipTypeGUID + " relationshipTypeName " + relationshipTypeName, e.getClass() + " - " + e.getMessage(), DEFAULT_SYSTEM_ACTION, DEFAULT_USER_ACTION);
        }
        return entityDetails;
    }

    protected List<EntityDetail> getSubEntities(String userId, String serverName, String entityGUID, String entityTypeName, String relationshipTypeGUID, String relationshipTypeName, Integer from, Integer size, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, GlossaryViewOmasException {
        List entityDetails;
        try {
            OpenMetadataAPIGenericHandler<GlossaryViewEntityDetail> entitiesHandler = this.instanceHandler.getEntitiesHandler(userId, serverName, methodName);
            entityDetails = entitiesHandler.getAttachedEntities(userId, entityGUID, "guid", entityTypeName, relationshipTypeGUID, relationshipTypeName, null, null, null, 2, false, false, null, from.intValue(), size.intValue(), null, methodName);
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GlossaryViewOmasException(500, this.getClass().getName(), "Internal server error thrown by OMRS when executing getAttachedEntities: guid " + entityGUID + " entityTypeName " + entityTypeName + " relationshipTypeGUID " + relationshipTypeGUID + " relationshipTypeName " + relationshipTypeName, e.getClass() + " - " + e.getMessage(), DEFAULT_SYSTEM_ACTION, DEFAULT_USER_ACTION);
        }
        return entityDetails;
    }

    protected List<EntityDetail> getAllEntityDetails(String userId, String serverName, String entityTypeName, String entityTypeGUID, Integer from, Integer size, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, GlossaryViewOmasException {
        List entities;
        try {
            OpenMetadataAPIGenericHandler<GlossaryViewEntityDetail> entitiesHandler = this.instanceHandler.getEntitiesHandler(userId, serverName, methodName);
            entities = entitiesHandler.getEntitiesByType(userId, entityTypeGUID, entityTypeName, null, false, false, null, from.intValue(), size.intValue(), null, methodName);
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GlossaryViewOmasException(500, this.getClass().getName(), "Internal server error thrown by OMRS when executing getEntitiesByType: entityTypeGUID " + entityTypeGUID, e.getClass() + " - " + e.getMessage(), DEFAULT_SYSTEM_ACTION, DEFAULT_USER_ACTION);
        }
        return entities;
    }
}

