/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.glossaryview.server.spring;

import javax.validation.constraints.Max;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.PositiveOrZero;
import org.apache.commons.lang3.time.StopWatch;
import org.odpi.openmetadata.accessservices.glossaryview.rest.GlossaryViewEntityDetailResponse;
import org.odpi.openmetadata.accessservices.glossaryview.server.service.GlossaryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Validated
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/glossary-view/users/{userId}"})
public class GlossaryResource {
    public static final String PAGE_FROM_DEFAULT_VALUE = "0";
    public static final String PAGE_SIZE_DEFAULT_VALUE = "1000";
    public static final int PAGE_SIZE_MAX_VALUE = 10000;
    private static final Logger log = LoggerFactory.getLogger(GlossaryResource.class);
    private GlossaryService glossaryService = new GlossaryService();

    @RequestMapping(method={RequestMethod.GET}, path={"/glossaries"})
    public GlossaryViewEntityDetailResponse getAllGlossaries(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="1000") @PositiveOrZero @Max(value=10000L) @PositiveOrZero @Max(value=10000L) Integer size) {
        StopWatch watch = StopWatch.createStarted();
        GlossaryViewEntityDetailResponse response = this.glossaryService.getAllGlossaries(userId, serverName, from, size);
        watch.stop();
        log.debug("Method: getAllGlossaries; Duration: " + watch.getTime() / 1000L + "seconds");
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/glossaries/{glossaryGUID}"})
    public GlossaryViewEntityDetailResponse getGlossary(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="glossaryGUID") @NotBlank String glossaryGUID) {
        StopWatch watch = StopWatch.createStarted();
        GlossaryViewEntityDetailResponse response = this.glossaryService.getGlossary(userId, serverName, glossaryGUID);
        watch.stop();
        log.debug("Method: getGlossary; Duration: " + watch.getTime() / 1000L + "seconds");
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/terms/{termGUID}/home-glossary"})
    public GlossaryViewEntityDetailResponse getTermHomeGlossary(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="termGUID") @NotBlank String termGUID) {
        StopWatch watch = StopWatch.createStarted();
        GlossaryViewEntityDetailResponse response = this.glossaryService.getTermHomeGlossary(userId, serverName, termGUID);
        watch.stop();
        log.debug("Method: getTermHomeGlossary; Duration: " + watch.getTime() / 1000L + "seconds");
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/categories/{categoryGUID}/home-glossary"})
    public GlossaryViewEntityDetailResponse getCategoryHomeGlossary(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="categoryGUID") @NotBlank String categoryGUID) {
        StopWatch watch = StopWatch.createStarted();
        GlossaryViewEntityDetailResponse response = this.glossaryService.getCategoryHomeGlossary(userId, serverName, categoryGUID);
        watch.stop();
        log.debug("Method: getCategoryHomeGlossary; Duration: " + watch.getTime() / 1000L + "seconds");
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/glossaries/{glossaryGUID}/external-glossary-links"})
    public GlossaryViewEntityDetailResponse getExternalGlossaryLinks(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="glossaryGUID") @NotBlank String glossaryGUID, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="1000") @PositiveOrZero @Max(value=10000L) @PositiveOrZero @Max(value=10000L) Integer size) {
        StopWatch watch = StopWatch.createStarted();
        GlossaryViewEntityDetailResponse response = this.glossaryService.getExternalGlossaryLinks(userId, serverName, glossaryGUID, from, size);
        watch.stop();
        log.debug("Method: getExternalGlossaryLinks; Duration: " + watch.getTime() / 1000L + "seconds");
        return response;
    }
}

