/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.glossaryview.server.spring;

import javax.validation.constraints.Max;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.PositiveOrZero;
import org.apache.commons.lang3.time.StopWatch;
import org.odpi.openmetadata.accessservices.glossaryview.rest.GlossaryViewEntityDetailResponse;
import org.odpi.openmetadata.accessservices.glossaryview.server.service.CategoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Validated
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/glossary-view/users/{userId}"})
public class CategoryResource {
    private static final Logger log = LoggerFactory.getLogger(CategoryResource.class);
    private CategoryService categoryService = new CategoryService();

    @RequestMapping(method={RequestMethod.GET}, path={"/categories/{categoryGUID}"})
    public GlossaryViewEntityDetailResponse getCategory(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="categoryGUID") @NotBlank String categoryGUID) {
        StopWatch watch = StopWatch.createStarted();
        GlossaryViewEntityDetailResponse response = this.categoryService.getCategory(userId, serverName, categoryGUID);
        watch.stop();
        log.debug("Method: getCategory; Duration: " + watch.getTime() / 1000L + "seconds");
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/glossaries/{glossaryGUID}/categories"})
    public GlossaryViewEntityDetailResponse getCategoriesViaCategoryAnchorRelationships(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="glossaryGUID") @NotBlank String glossaryGUID, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="1000") @PositiveOrZero @Max(value=10000L) @PositiveOrZero @Max(value=10000L) Integer size) {
        StopWatch watch = StopWatch.createStarted();
        GlossaryViewEntityDetailResponse response = this.categoryService.getCategoriesViaCategoryAnchorRelationships(userId, serverName, glossaryGUID, from, size);
        watch.stop();
        log.debug("Method: getCategoriesViaCategoryAnchorRelationships; Duration: " + watch.getTime() / 1000L + "seconds");
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/categories/{categoryGUID}/subcategories"})
    public GlossaryViewEntityDetailResponse getSubcategories(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="categoryGUID") @NotBlank String categoryGUID, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="1000") @PositiveOrZero @Max(value=10000L) @PositiveOrZero @Max(value=10000L) Integer size) {
        StopWatch watch = StopWatch.createStarted();
        GlossaryViewEntityDetailResponse response = this.categoryService.getSubcategories(userId, serverName, categoryGUID, from, size);
        watch.stop();
        log.debug("Method: getSubcategories; Duration: " + watch.getTime() / 1000L + "seconds");
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/categories/{categoryGUID}/external-glossary-links"})
    public GlossaryViewEntityDetailResponse getExternalGlossaryLinks(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="categoryGUID") @NotBlank String categoryGUID, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="1000") @PositiveOrZero @Max(value=10000L) @PositiveOrZero @Max(value=10000L) Integer size) {
        StopWatch watch = StopWatch.createStarted();
        GlossaryViewEntityDetailResponse response = this.categoryService.getExternalGlossaryLinks(userId, serverName, categoryGUID, from, size);
        watch.stop();
        log.debug("Method: getExternalGlossaryLinks; Duration: " + watch.getTime() / 1000L + "seconds");
        return response;
    }
}

