/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.glossaryview.server.spring;

import javax.validation.constraints.Max;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.PositiveOrZero;
import org.apache.commons.lang3.time.StopWatch;
import org.odpi.openmetadata.accessservices.glossaryview.rest.GlossaryViewEntityDetailResponse;
import org.odpi.openmetadata.accessservices.glossaryview.server.service.TermService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Validated
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/glossary-view/users/{userId}"})
public class TermResource {
    private static final Logger log = LoggerFactory.getLogger(TermResource.class);
    private TermService termService = new TermService();

    @RequestMapping(method={RequestMethod.GET}, path={"/terms/{termGUID}"})
    public GlossaryViewEntityDetailResponse getTerm(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="termGUID") @NotBlank String termGUID) {
        StopWatch watch = StopWatch.createStarted();
        GlossaryViewEntityDetailResponse response = this.termService.getTerm(userId, serverName, termGUID);
        watch.stop();
        log.debug("Method: getTerm; Duration: " + watch.getTime() / 1000L + "seconds");
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/glossaries/{glossaryGUID}/terms"})
    public GlossaryViewEntityDetailResponse getTermsViaTermAnchorRelationships(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="glossaryGUID") @NotBlank String glossaryGUID, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="1000") @PositiveOrZero @Max(value=10000L) @PositiveOrZero @Max(value=10000L) Integer size) {
        StopWatch watch = StopWatch.createStarted();
        GlossaryViewEntityDetailResponse response = this.termService.getTermsViaTermAnchorRelationships(userId, serverName, glossaryGUID, from, size);
        watch.stop();
        log.debug("Method: getTermsViaTermAnchorRelationships; Duration: " + watch.getTime() / 1000L + "seconds");
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/categories/{categoryGUID}/terms"})
    public GlossaryViewEntityDetailResponse getTermsViaTermCategorizationRelationships(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="categoryGUID") @NotBlank String categoryGUID, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="1000") @PositiveOrZero @Max(value=10000L) @PositiveOrZero @Max(value=10000L) Integer size) {
        StopWatch watch = StopWatch.createStarted();
        GlossaryViewEntityDetailResponse response = this.termService.getTermsViaTermCategorizationRelationships(userId, serverName, categoryGUID, from, size);
        watch.stop();
        log.debug("Method: getTermsViaTermCategorizationRelationships; Duration: " + watch.getTime() / 1000L + "seconds");
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/terms/{termGUID}/external-glossary-links"})
    public GlossaryViewEntityDetailResponse getExternalGlossaryLinks(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="termGUID") @NotBlank String termGUID, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="1000") @PositiveOrZero @Max(value=10000L) @PositiveOrZero @Max(value=10000L) Integer size) {
        StopWatch watch = StopWatch.createStarted();
        GlossaryViewEntityDetailResponse response = this.termService.getExternalGlossaryLinks(userId, serverName, termGUID, from, size);
        watch.stop();
        log.debug("Method: getExternalGlossaryLinks; Duration: " + watch.getTime() / 1000L + "seconds");
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/terms/{termGUID}/see-also"})
    public GlossaryViewEntityDetailResponse getRelatedTerms(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="termGUID") @NotBlank String termGUID, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="1000") @PositiveOrZero @Max(value=10000L) @PositiveOrZero @Max(value=10000L) Integer size) {
        StopWatch watch = StopWatch.createStarted();
        GlossaryViewEntityDetailResponse response = this.termService.getRelatedTerms(userId, serverName, termGUID, from, size);
        watch.stop();
        log.debug("Method: getRelatedTerms; Duration: " + watch.getTime() / 1000L + "seconds");
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/terms/{termGUID}/synonyms"})
    public GlossaryViewEntityDetailResponse getSynonyms(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="termGUID") @NotBlank String termGUID, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="1000") @PositiveOrZero @Max(value=10000L) @PositiveOrZero @Max(value=10000L) Integer size) {
        StopWatch watch = StopWatch.createStarted();
        GlossaryViewEntityDetailResponse response = this.termService.getSynonyms(userId, serverName, termGUID, from, size);
        watch.stop();
        log.debug("Method: getSynonyms; Duration: " + watch.getTime() / 1000L + "seconds");
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/terms/{termGUID}/antonyms"})
    public GlossaryViewEntityDetailResponse getAntonyms(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="termGUID") @NotBlank String termGUID, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="1000") @PositiveOrZero @Max(value=10000L) @PositiveOrZero @Max(value=10000L) Integer size) {
        StopWatch watch = StopWatch.createStarted();
        GlossaryViewEntityDetailResponse response = this.termService.getAntonyms(userId, serverName, termGUID, from, size);
        watch.stop();
        log.debug("Method: getAntonyms; Duration: " + watch.getTime() / 1000L + "seconds");
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/terms/{termGUID}/preferred-terms"})
    public GlossaryViewEntityDetailResponse getPreferredTerms(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="termGUID") @NotBlank String termGUID, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="1000") @PositiveOrZero @Max(value=10000L) @PositiveOrZero @Max(value=10000L) Integer size) {
        StopWatch watch = StopWatch.createStarted();
        GlossaryViewEntityDetailResponse response = this.termService.getPreferredTerms(userId, serverName, termGUID, from, size);
        watch.stop();
        log.debug("Method: getPreferredTerms; Duration: " + watch.getTime() / 1000L + "seconds");
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/terms/{termGUID}/replacement-terms"})
    public GlossaryViewEntityDetailResponse getReplacementTerms(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="termGUID") @NotBlank String termGUID, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="1000") @PositiveOrZero @Max(value=10000L) @PositiveOrZero @Max(value=10000L) Integer size) {
        StopWatch watch = StopWatch.createStarted();
        GlossaryViewEntityDetailResponse response = this.termService.getReplacementTerms(userId, serverName, termGUID, from, size);
        watch.stop();
        log.debug("Method: getReplacementTerms; Duration: " + watch.getTime() / 1000L + "seconds");
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/terms/{termGUID}/translations"})
    public GlossaryViewEntityDetailResponse getTranslations(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="termGUID") @NotBlank String termGUID, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="1000") @PositiveOrZero @Max(value=10000L) @PositiveOrZero @Max(value=10000L) Integer size) {
        StopWatch watch = StopWatch.createStarted();
        GlossaryViewEntityDetailResponse response = this.termService.getTranslations(userId, serverName, termGUID, from, size);
        watch.stop();
        log.debug("Method: getTranslations; Duration: " + watch.getTime() / 1000L + "seconds");
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/terms/{termGUID}/is-a"})
    public GlossaryViewEntityDetailResponse getIsA(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="termGUID") @NotBlank String termGUID, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="1000") @PositiveOrZero @Max(value=10000L) @PositiveOrZero @Max(value=10000L) Integer size) {
        StopWatch watch = StopWatch.createStarted();
        GlossaryViewEntityDetailResponse response = this.termService.getIsA(userId, serverName, termGUID, from, size);
        watch.stop();
        log.debug("Method: getIsA; Duration: " + watch.getTime() / 1000L + "seconds");
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/terms/{termGUID}/valid-values"})
    public GlossaryViewEntityDetailResponse getValidValues(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="termGUID") @NotBlank String termGUID, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="1000") @PositiveOrZero @Max(value=10000L) @PositiveOrZero @Max(value=10000L) Integer size) {
        StopWatch watch = StopWatch.createStarted();
        GlossaryViewEntityDetailResponse response = this.termService.getValidValues(userId, serverName, termGUID, from, size);
        watch.stop();
        log.debug("Method: getValidValues; Duration: " + watch.getTime() / 1000L + "seconds");
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/terms/{termGUID}/used-in-contexts"})
    public GlossaryViewEntityDetailResponse getUsedInContexts(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="termGUID") @NotBlank String termGUID, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="1000") @PositiveOrZero @Max(value=10000L) @PositiveOrZero @Max(value=10000L) Integer size) {
        StopWatch watch = StopWatch.createStarted();
        GlossaryViewEntityDetailResponse response = this.termService.getUsedInContexts(userId, serverName, termGUID, from, size);
        watch.stop();
        log.debug("Method: getUsedInContexts; Duration: " + watch.getTime() / 1000L + "seconds");
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/terms/{termGUID}/assigned-elements"})
    public GlossaryViewEntityDetailResponse getAssignedElements(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="termGUID") @NotBlank String termGUID, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="1000") @PositiveOrZero @Max(value=10000L) @PositiveOrZero @Max(value=10000L) Integer size) {
        StopWatch watch = StopWatch.createStarted();
        GlossaryViewEntityDetailResponse response = this.termService.getAssignedElements(userId, serverName, termGUID, from, size);
        watch.stop();
        log.debug("Method: getAssignedElements; Duration: " + watch.getTime() / 1000L + "seconds");
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/terms/{termGUID}/attributes"})
    public GlossaryViewEntityDetailResponse getAttributes(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="termGUID") @NotBlank String termGUID, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="1000") @PositiveOrZero @Max(value=10000L) @PositiveOrZero @Max(value=10000L) Integer size) {
        StopWatch watch = StopWatch.createStarted();
        GlossaryViewEntityDetailResponse response = this.termService.getAttributes(userId, serverName, termGUID, from, size);
        watch.stop();
        log.debug("Method: getAttributes; Duration: " + watch.getTime() / 1000L + "seconds");
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/terms/{termGUID}/subtypes"})
    public GlossaryViewEntityDetailResponse getSubtypes(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="termGUID") @NotBlank String termGUID, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="1000") @PositiveOrZero @Max(value=10000L) @PositiveOrZero @Max(value=10000L) Integer size) {
        StopWatch watch = StopWatch.createStarted();
        GlossaryViewEntityDetailResponse response = this.termService.getSubtypes(userId, serverName, termGUID, from, size);
        watch.stop();
        log.debug("Method: getSubtypes; Duration: " + watch.getTime() / 1000L + "seconds");
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/terms/{termGUID}/types"})
    public GlossaryViewEntityDetailResponse getTypes(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="termGUID") @NotBlank String termGUID, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="1000") @PositiveOrZero @Max(value=10000L) @PositiveOrZero @Max(value=10000L) Integer size) {
        StopWatch watch = StopWatch.createStarted();
        GlossaryViewEntityDetailResponse response = this.termService.getTypes(userId, serverName, termGUID, from, size);
        watch.stop();
        log.debug("Method: getTypes; Duration: " + watch.getTime() / 1000L + "seconds");
        return response;
    }
}

