/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.glossaryview.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.validation.constraints.Max;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.PositiveOrZero;
import org.odpi.openmetadata.accessservices.glossaryview.rest.GlossaryViewEntityDetailResponse;
import org.odpi.openmetadata.accessservices.glossaryview.server.service.CategoryService;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Validated
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/glossary-view/users/{userId}"})
@Tag(name="Glossary View OMAS", description="The Glossary View OMAS provides APIs and events for retrieving glossaries, categories and terms.", externalDocs=@ExternalDocumentation(description="Glossary View Open Metadata Access Service (OMAS)", url="https://egeria.odpi.org/open-metadata-implementation/access-services/glossary-view/"))
public class CategoryResource {
    private CategoryService categoryService = new CategoryService();

    @GetMapping(path={"/categories"})
    public GlossaryViewEntityDetailResponse getAllCategories(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="100") @PositiveOrZero @Max(value=1000L) @PositiveOrZero @Max(value=1000L) Integer size) {
        return this.categoryService.getAllCategories(userId, serverName, from, size);
    }

    @GetMapping(path={"/categories/{categoryGUID}"})
    public GlossaryViewEntityDetailResponse getCategory(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="categoryGUID") @NotBlank String categoryGUID) {
        return this.categoryService.getCategory(userId, serverName, categoryGUID);
    }

    @GetMapping(path={"/glossaries/{glossaryGUID}/categories"})
    public GlossaryViewEntityDetailResponse getCategoriesViaCategoryAnchorRelationships(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="glossaryGUID") @NotBlank String glossaryGUID, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="100") @PositiveOrZero @Max(value=1000L) @PositiveOrZero @Max(value=1000L) Integer size) {
        return this.categoryService.getCategoriesViaCategoryAnchorRelationships(userId, serverName, glossaryGUID, from, size);
    }

    @GetMapping(path={"/categories/{categoryGUID}/subcategories"})
    public GlossaryViewEntityDetailResponse getSubcategories(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="categoryGUID") @NotBlank String categoryGUID, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="100") @PositiveOrZero @Max(value=1000L) @PositiveOrZero @Max(value=1000L) Integer size) {
        return this.categoryService.getSubcategories(userId, serverName, categoryGUID, from, size);
    }

    @GetMapping(path={"/categories/{categoryGUID}/external-glossary-links"})
    public GlossaryViewEntityDetailResponse getExternalGlossaryLinks(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="categoryGUID") @NotBlank String categoryGUID, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="100") @PositiveOrZero @Max(value=1000L) @PositiveOrZero @Max(value=1000L) Integer size) {
        return this.categoryService.getExternalGlossaryLinks(userId, serverName, categoryGUID, from, size);
    }
}

