/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.glossaryview.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.validation.constraints.Max;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.PositiveOrZero;
import org.odpi.openmetadata.accessservices.glossaryview.rest.GlossaryViewEntityDetailResponse;
import org.odpi.openmetadata.accessservices.glossaryview.server.service.TermService;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Validated
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/glossary-view/users/{userId}"})
@Tag(name="Glossary View OMAS", description="The Glossary View OMAS provides APIs and events for retrieving glossaries, categories and terms.", externalDocs=@ExternalDocumentation(description="Glossary View Open Metadata Access Service (OMAS)", url="https://egeria-project.org/services/omas/glossary-view/overview/"))
public class TermResource {
    private TermService termService = new TermService();

    @GetMapping(path={"/terms"})
    public GlossaryViewEntityDetailResponse getAllTerms(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="100") @PositiveOrZero @Max(value=1000L) @PositiveOrZero @Max(value=1000L) Integer size) {
        return this.termService.getAllTerms(userId, serverName, from, size);
    }

    @GetMapping(path={"/terms/{termGUID}"})
    public GlossaryViewEntityDetailResponse getTerm(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="termGUID") @NotBlank String termGUID) {
        return this.termService.getTerm(userId, serverName, termGUID);
    }

    @GetMapping(path={"/glossaries/{glossaryGUID}/terms"})
    public GlossaryViewEntityDetailResponse getTermsViaTermAnchorRelationships(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="glossaryGUID") @NotBlank String glossaryGUID, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="100") @PositiveOrZero @Max(value=1000L) @PositiveOrZero @Max(value=1000L) Integer size) {
        return this.termService.getTermsViaTermAnchorRelationships(userId, serverName, glossaryGUID, from, size);
    }

    @GetMapping(path={"/categories/{categoryGUID}/terms"})
    public GlossaryViewEntityDetailResponse getTermsViaTermCategorizationRelationships(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="categoryGUID") @NotBlank String categoryGUID, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="100") @PositiveOrZero @Max(value=1000L) @PositiveOrZero @Max(value=1000L) Integer size) {
        return this.termService.getTermsViaTermCategorizationRelationships(userId, serverName, categoryGUID, from, size);
    }

    @GetMapping(path={"/terms/{termGUID}/external-glossary-links"})
    public GlossaryViewEntityDetailResponse getExternalGlossaryLinks(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="termGUID") @NotBlank String termGUID, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="100") @PositiveOrZero @Max(value=1000L) @PositiveOrZero @Max(value=1000L) Integer size) {
        return this.termService.getExternalGlossaryLinks(userId, serverName, termGUID, from, size);
    }

    @GetMapping(path={"/terms/{termGUID}/see-also"})
    public GlossaryViewEntityDetailResponse getRelatedTerms(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="termGUID") @NotBlank String termGUID, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="100") @PositiveOrZero @Max(value=1000L) @PositiveOrZero @Max(value=1000L) Integer size) {
        return this.termService.getRelatedTerms(userId, serverName, termGUID, from, size);
    }

    @GetMapping(path={"/terms/{termGUID}/synonyms"})
    public GlossaryViewEntityDetailResponse getSynonyms(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="termGUID") @NotBlank String termGUID, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="100") @PositiveOrZero @Max(value=1000L) @PositiveOrZero @Max(value=1000L) Integer size) {
        return this.termService.getSynonyms(userId, serverName, termGUID, from, size);
    }

    @GetMapping(path={"/terms/{termGUID}/antonyms"})
    public GlossaryViewEntityDetailResponse getAntonyms(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="termGUID") @NotBlank String termGUID, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="100") @PositiveOrZero @Max(value=1000L) @PositiveOrZero @Max(value=1000L) Integer size) {
        return this.termService.getAntonyms(userId, serverName, termGUID, from, size);
    }

    @GetMapping(path={"/terms/{termGUID}/preferred-terms"})
    public GlossaryViewEntityDetailResponse getPreferredTerms(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="termGUID") @NotBlank String termGUID, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="100") @PositiveOrZero @Max(value=1000L) @PositiveOrZero @Max(value=1000L) Integer size) {
        return this.termService.getPreferredTerms(userId, serverName, termGUID, from, size);
    }

    @GetMapping(path={"/terms/{termGUID}/replacement-terms"})
    public GlossaryViewEntityDetailResponse getReplacementTerms(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="termGUID") @NotBlank String termGUID, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="100") @PositiveOrZero @Max(value=1000L) @PositiveOrZero @Max(value=1000L) Integer size) {
        return this.termService.getReplacementTerms(userId, serverName, termGUID, from, size);
    }

    @GetMapping(path={"/terms/{termGUID}/translations"})
    public GlossaryViewEntityDetailResponse getTranslations(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="termGUID") @NotBlank String termGUID, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="100") @PositiveOrZero @Max(value=1000L) @PositiveOrZero @Max(value=1000L) Integer size) {
        return this.termService.getTranslations(userId, serverName, termGUID, from, size);
    }

    @GetMapping(path={"/terms/{termGUID}/is-a"})
    public GlossaryViewEntityDetailResponse getIsA(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="termGUID") @NotBlank String termGUID, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="100") @PositiveOrZero @Max(value=1000L) @PositiveOrZero @Max(value=1000L) Integer size) {
        return this.termService.getIsA(userId, serverName, termGUID, from, size);
    }

    @GetMapping(path={"/terms/{termGUID}/valid-values"})
    public GlossaryViewEntityDetailResponse getValidValues(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="termGUID") @NotBlank String termGUID, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="100") @PositiveOrZero @Max(value=1000L) @PositiveOrZero @Max(value=1000L) Integer size) {
        return this.termService.getValidValues(userId, serverName, termGUID, from, size);
    }

    @GetMapping(path={"/terms/{termGUID}/used-in-contexts"})
    public GlossaryViewEntityDetailResponse getUsedInContexts(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="termGUID") @NotBlank String termGUID, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="100") @PositiveOrZero @Max(value=1000L) @PositiveOrZero @Max(value=1000L) Integer size) {
        return this.termService.getUsedInContexts(userId, serverName, termGUID, from, size);
    }

    @GetMapping(path={"/terms/{termGUID}/assigned-elements"})
    public GlossaryViewEntityDetailResponse getAssignedElements(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="termGUID") @NotBlank String termGUID, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="100") @PositiveOrZero @Max(value=1000L) @PositiveOrZero @Max(value=1000L) Integer size) {
        return this.termService.getAssignedElements(userId, serverName, termGUID, from, size);
    }

    @GetMapping(path={"/terms/{termGUID}/attributes"})
    public GlossaryViewEntityDetailResponse getAttributes(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="termGUID") @NotBlank String termGUID, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="100") @PositiveOrZero @Max(value=1000L) @PositiveOrZero @Max(value=1000L) Integer size) {
        return this.termService.getAttributes(userId, serverName, termGUID, from, size);
    }

    @GetMapping(path={"/terms/{termGUID}/subtypes"})
    public GlossaryViewEntityDetailResponse getSubtypes(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="termGUID") @NotBlank String termGUID, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="100") @PositiveOrZero @Max(value=1000L) @PositiveOrZero @Max(value=1000L) Integer size) {
        return this.termService.getSubtypes(userId, serverName, termGUID, from, size);
    }

    @GetMapping(path={"/terms/{termGUID}/types"})
    public GlossaryViewEntityDetailResponse getTypes(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="termGUID") @NotBlank String termGUID, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="100") @PositiveOrZero @Max(value=1000L) @PositiveOrZero @Max(value=1000L) Integer size) {
        return this.termService.getTypes(userId, serverName, termGUID, from, size);
    }
}

