/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.glossaryview.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.PositiveOrZero;
import org.odpi.openmetadata.accessservices.glossaryview.rest.GlossaryViewEntityDetailResponse;
import org.odpi.openmetadata.accessservices.glossaryview.server.service.GlossaryService;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Validated
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/glossary-view/users/{userId}"})
@Tag(name="Glossary View OMAS", description="The Glossary View OMAS provides APIs and events for retrieving glossaries, categories and terms.", externalDocs=@ExternalDocumentation(description="Glossary View Open Metadata Access Service (OMAS)", url="https://egeria-project.org/services/omas/glossary-view/overview/"))
public class GlossaryResource {
    private final GlossaryService glossaryService = new GlossaryService();

    @GetMapping(path={"/glossaries"})
    public GlossaryViewEntityDetailResponse getAllGlossaries(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="100") @PositiveOrZero @Max(value=1000L) @PositiveOrZero @Max(value=1000L) Integer size) {
        return this.glossaryService.getAllGlossaries(userId, serverName, from, size);
    }

    @GetMapping(path={"/glossaries/{glossaryGUID}"})
    public GlossaryViewEntityDetailResponse getGlossary(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="glossaryGUID") @NotBlank String glossaryGUID) {
        return this.glossaryService.getGlossary(userId, serverName, glossaryGUID);
    }

    @GetMapping(path={"/terms/{termGUID}/home-glossary"})
    public GlossaryViewEntityDetailResponse getTermHomeGlossary(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="termGUID") @NotBlank String termGUID) {
        return this.glossaryService.getTermHomeGlossary(userId, serverName, termGUID);
    }

    @GetMapping(path={"/categories/{categoryGUID}/home-glossary"})
    public GlossaryViewEntityDetailResponse getCategoryHomeGlossary(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="categoryGUID") @NotBlank String categoryGUID) {
        return this.glossaryService.getCategoryHomeGlossary(userId, serverName, categoryGUID);
    }

    @GetMapping(path={"/glossaries/{glossaryGUID}/external-glossary-links"})
    public GlossaryViewEntityDetailResponse getExternalGlossaryLinks(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="glossaryGUID") @NotBlank String glossaryGUID, @RequestParam(name="from", defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="size", defaultValue="100") @PositiveOrZero @Max(value=1000L) @PositiveOrZero @Max(value=1000L) Integer size) {
        return this.glossaryService.getExternalGlossaryLinks(userId, serverName, glossaryGUID, from, size);
    }
}

