/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryworkflow.server;

import org.odpi.openmetadata.accessservices.assetmanager.client.management.CollaborationManagementClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.management.GlossaryManagementClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.management.StewardshipManagementClient;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceDescription;
import org.odpi.openmetadata.commonservices.multitenant.OMVSServiceInstance;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;

public class GlossaryWorkflowInstance
extends OMVSServiceInstance {
    private static final ViewServiceDescription myDescription = ViewServiceDescription.GLOSSARY_WORKFLOW;
    private final CollaborationManagementClient collaborationManagementClient;
    private final GlossaryManagementClient glossaryManagementClient;
    private final StewardshipManagementClient stewardshipManagementClient;

    public GlossaryWorkflowInstance(String serverName, AuditLog auditLog, String localServerUserId, int maxPageSize, String remoteServerName, String remoteServerURL) throws InvalidParameterException {
        super(serverName, myDescription.getViewServiceName(), auditLog, localServerUserId, maxPageSize, remoteServerName, remoteServerURL);
        this.collaborationManagementClient = new CollaborationManagementClient(remoteServerName, remoteServerURL, auditLog);
        this.glossaryManagementClient = new GlossaryManagementClient(remoteServerName, remoteServerURL, auditLog);
        this.stewardshipManagementClient = new StewardshipManagementClient(remoteServerName, remoteServerURL, auditLog);
    }

    public CollaborationManagementClient getCollaborationManagementClient() {
        return this.collaborationManagementClient;
    }

    public GlossaryManagementClient getGlossaryManagementClient() {
        return this.glossaryManagementClient;
    }

    public StewardshipManagementClient getStewardshipManagementClient() {
        return this.stewardshipManagementClient;
    }
}

