/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryworkflow.server;

import java.util.Arrays;
import org.odpi.openmetadata.accessservices.assetmanager.client.management.CollaborationManagementClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.management.GlossaryManagementClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.management.StewardshipManagementClient;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ActivityDescriptionProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.CanonicalVocabularyProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ClassificationProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.DataFieldValuesProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.EditingGlossaryProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryCategoryProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermActivityType;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermCategorization;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermContextDefinition;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermRelationship;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermRelationshipStatus;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermStatus;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GovernanceClassificationProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.NoteLogProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.NoteProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.OwnerProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ReferenceableProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.RelationshipProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.RetentionClassificationProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SecurityTagsProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SemanticAssignmentProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.StagingGlossaryProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SubjectAreaMemberProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TaxonomyProperties;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermElementResponse;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.EffectiveTimeRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.viewservices.glossaryworkflow.rest.ArchiveRequestBody;
import org.odpi.openmetadata.viewservices.glossaryworkflow.rest.ClassificationRequestBody;
import org.odpi.openmetadata.viewservices.glossaryworkflow.rest.ControlledGlossaryTermRequestBody;
import org.odpi.openmetadata.viewservices.glossaryworkflow.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.viewservices.glossaryworkflow.rest.GlossaryTemplateRequestBody;
import org.odpi.openmetadata.viewservices.glossaryworkflow.rest.GlossaryTermActivityTypeListResponse;
import org.odpi.openmetadata.viewservices.glossaryworkflow.rest.GlossaryTermRelationshipStatusListResponse;
import org.odpi.openmetadata.viewservices.glossaryworkflow.rest.GlossaryTermStatusListResponse;
import org.odpi.openmetadata.viewservices.glossaryworkflow.rest.GlossaryTermStatusRequestBody;
import org.odpi.openmetadata.viewservices.glossaryworkflow.rest.ReferenceableRequestBody;
import org.odpi.openmetadata.viewservices.glossaryworkflow.rest.ReferenceableUpdateRequestBody;
import org.odpi.openmetadata.viewservices.glossaryworkflow.rest.RelationshipRequestBody;
import org.odpi.openmetadata.viewservices.glossaryworkflow.rest.TemplateRequestBody;
import org.odpi.openmetadata.viewservices.glossaryworkflow.server.GlossaryWorkflowInstanceHandler;
import org.slf4j.LoggerFactory;

public class GlossaryWorkflowRESTServices {
    private static final GlossaryWorkflowInstanceHandler instanceHandler = new GlossaryWorkflowInstanceHandler();
    private static final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(GlossaryWorkflowRESTServices.class), instanceHandler.getServiceName());

    public GUIDResponse createGlossary(String serverName, String userId, ReferenceableRequestBody requestBody) {
        String methodName = "createGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGlossary");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createGlossary");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getElementProperties();
                if (referenceableProperties instanceof GlossaryProperties) {
                    GlossaryProperties glossaryProperties = (GlossaryProperties)referenceableProperties;
                    GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "createGlossary");
                    response.setGUID(handler.createGlossary(userId, glossaryProperties));
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(GlossaryProperties.class.getName(), "createGlossary");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createGlossary", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createGlossaryFromTemplate(String serverName, String userId, String templateGUID, boolean deepCopy, TemplateRequestBody requestBody) {
        String methodName = "createGlossaryFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGlossaryFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createGlossaryFromTemplate");
            if (requestBody != null) {
                GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "createGlossaryFromTemplate");
                response.setGUID(handler.createGlossaryFromTemplate(userId, templateGUID, requestBody.getElementProperties(), deepCopy));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createGlossaryFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createGlossaryFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGlossary(String serverName, String userId, String glossaryGUID, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "updateGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateGlossary");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGlossary");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getElementProperties();
                if (referenceableProperties instanceof GlossaryProperties) {
                    GlossaryProperties glossaryProperties = (GlossaryProperties)referenceableProperties;
                    GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "updateGlossary");
                    handler.updateGlossary(userId, glossaryGUID, isMergeUpdate, glossaryProperties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(GlossaryProperties.class.getName(), "updateGlossary");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateGlossary", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeGlossary(String serverName, String userId, String glossaryGUID, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "removeGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeGlossary");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeGlossary");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "removeGlossary");
            if (requestBody != null) {
                handler.removeGlossary(userId, glossaryGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.removeGlossary(userId, glossaryGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setGlossaryAsEditingGlossary(String serverName, String userId, String glossaryGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setGlossaryAsEditingGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setGlossaryAsEditingGlossary");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setGlossaryAsEditingGlossary");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof EditingGlossaryProperties) {
                    EditingGlossaryProperties properties = (EditingGlossaryProperties)classificationProperties;
                    GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "setGlossaryAsEditingGlossary");
                    handler.setGlossaryAsEditingGlossary(userId, glossaryGUID, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(EditingGlossaryProperties.class.getName(), "setGlossaryAsEditingGlossary");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setGlossaryAsEditingGlossary", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setGlossaryAsEditingGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearGlossaryAsEditingGlossary(String serverName, String userId, String glossaryGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearGlossaryAsEditingGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearGlossaryAsEditingGlossary");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearGlossaryAsEditingGlossary");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "clearGlossaryAsEditingGlossary");
            if (requestBody != null) {
                handler.clearGlossaryAsEditingGlossary(userId, glossaryGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearGlossaryAsEditingGlossary(userId, glossaryGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearGlossaryAsEditingGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setGlossaryAsStagingGlossary(String serverName, String userId, String glossaryGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setGlossaryAsStagingGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setGlossaryAsStagingGlossary");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setGlossaryAsStagingGlossary");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof StagingGlossaryProperties) {
                    StagingGlossaryProperties properties = (StagingGlossaryProperties)classificationProperties;
                    GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "setGlossaryAsStagingGlossary");
                    handler.setGlossaryAsStagingGlossary(userId, glossaryGUID, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(StagingGlossaryProperties.class.getName(), "setGlossaryAsStagingGlossary");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setGlossaryAsStagingGlossary", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setGlossaryAsStagingGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearGlossaryAsStagingGlossary(String serverName, String userId, String glossaryGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearGlossaryAsStagingGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearGlossaryAsStagingGlossary");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearGlossaryAsStagingGlossary");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "clearGlossaryAsStagingGlossary");
            if (requestBody != null) {
                handler.clearGlossaryAsStagingGlossary(userId, glossaryGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearGlossaryAsStagingGlossary(userId, glossaryGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearGlossaryAsStagingGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setGlossaryAsTaxonomy(String serverName, String userId, String glossaryGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setGlossaryAsTaxonomy";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setGlossaryAsTaxonomy");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setGlossaryAsTaxonomy");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof TaxonomyProperties) {
                    TaxonomyProperties properties = (TaxonomyProperties)classificationProperties;
                    GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "setGlossaryAsTaxonomy");
                    handler.setGlossaryAsTaxonomy(userId, glossaryGUID, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(TaxonomyProperties.class.getName(), "setGlossaryAsTaxonomy");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setGlossaryAsTaxonomy", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setGlossaryAsTaxonomy", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearGlossaryAsTaxonomy(String serverName, String userId, String glossaryGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearGlossaryAsTaxonomy";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearGlossaryAsTaxonomy");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearGlossaryAsTaxonomy");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "clearGlossaryAsTaxonomy");
            if (requestBody != null) {
                handler.clearGlossaryAsTaxonomy(userId, glossaryGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearGlossaryAsTaxonomy(userId, glossaryGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearGlossaryAsTaxonomy", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setGlossaryAsCanonical(String serverName, String userId, String glossaryGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setGlossaryAsCanonical";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setGlossaryAsCanonical");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setGlossaryAsCanonical");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof CanonicalVocabularyProperties) {
                    CanonicalVocabularyProperties properties = (CanonicalVocabularyProperties)classificationProperties;
                    GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "setGlossaryAsCanonical");
                    handler.setGlossaryAsCanonical(userId, glossaryGUID, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(CanonicalVocabularyProperties.class.getName(), "setGlossaryAsCanonical");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setGlossaryAsCanonical", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setGlossaryAsCanonical", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearGlossaryAsCanonical(String serverName, String userId, String glossaryGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearGlossaryAsCanonical";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearGlossaryAsCanonical");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearGlossaryAsCanonical");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "clearGlossaryAsCanonical");
            if (requestBody != null) {
                handler.clearGlossaryAsCanonical(userId, glossaryGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearGlossaryAsCanonical(userId, glossaryGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearGlossaryAsCanonical", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createGlossaryCategory(String serverName, String userId, String glossaryGUID, boolean isRootCategory, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "createGlossaryCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGlossaryCategory");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createGlossaryCategory");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getElementProperties();
                if (referenceableProperties instanceof GlossaryCategoryProperties) {
                    GlossaryCategoryProperties properties = (GlossaryCategoryProperties)referenceableProperties;
                    GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "createGlossaryCategory");
                    response.setGUID(handler.createGlossaryCategory(userId, glossaryGUID, properties, isRootCategory, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(GlossaryCategoryProperties.class.getName(), "createGlossaryCategory");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createGlossaryCategory", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createGlossaryCategory", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createGlossaryCategoryFromTemplate(String serverName, String userId, String glossaryGUID, String templateGUID, TemplateRequestBody requestBody) {
        String methodName = "createGlossaryCategoryFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGlossaryCategoryFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createGlossaryCategoryFromTemplate");
            if (requestBody != null) {
                GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "createGlossaryCategoryFromTemplate");
                response.setGUID(handler.createGlossaryCategoryFromTemplate(userId, glossaryGUID, templateGUID, requestBody.getElementProperties(), true));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createGlossaryCategoryFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createGlossaryCategoryFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGlossaryCategory(String serverName, String userId, String glossaryCategoryGUID, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "updateGlossaryCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateGlossaryCategory");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGlossaryCategory");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getElementProperties();
                if (referenceableProperties instanceof GlossaryCategoryProperties) {
                    GlossaryCategoryProperties properties = (GlossaryCategoryProperties)referenceableProperties;
                    GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "updateGlossaryCategory");
                    handler.updateGlossaryCategory(userId, glossaryCategoryGUID, isMergeUpdate, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(GlossaryCategoryProperties.class.getName(), "updateGlossaryCategory");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateGlossaryCategory", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateGlossaryCategory", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupCategoryParent(String serverName, String userId, String glossaryParentCategoryGUID, String glossaryChildCategoryGUID, boolean forLineage, boolean forDuplicateProcessing, RelationshipRequestBody requestBody) {
        String methodName = "setupCategoryParent";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupCategoryParent");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupCategoryParent");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "setupCategoryParent");
            if (requestBody != null) {
                if (requestBody.getProperties() != null) {
                    handler.setupCategoryParent(userId, glossaryParentCategoryGUID, glossaryChildCategoryGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    handler.setupCategoryParent(userId, glossaryParentCategoryGUID, glossaryChildCategoryGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                }
            } else {
                handler.setupCategoryParent(userId, glossaryParentCategoryGUID, glossaryChildCategoryGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupCategoryParent", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearCategoryParent(String serverName, String userId, String glossaryParentCategoryGUID, String glossaryChildCategoryGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "clearCategoryParent";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearCategoryParent");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearCategoryParent");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "clearCategoryParent");
            if (requestBody != null) {
                handler.clearCategoryParent(userId, glossaryParentCategoryGUID, glossaryChildCategoryGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearCategoryParent(userId, glossaryParentCategoryGUID, glossaryChildCategoryGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearCategoryParent", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeGlossaryCategory(String serverName, String userId, String glossaryCategoryGUID, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "removeGlossaryCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeGlossaryCategory");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeGlossaryCategory");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "removeGlossaryCategory");
            if (requestBody != null) {
                handler.removeGlossaryCategory(userId, glossaryCategoryGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.removeGlossaryCategory(userId, glossaryCategoryGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeGlossaryCategory", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermStatusListResponse getGlossaryTermStatuses(String serverName, String userId) {
        String methodName = "getGlossaryTermStatuses";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossaryTermStatuses");
        GlossaryTermStatusListResponse response = new GlossaryTermStatusListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryTermStatuses");
            response.setStatuses(Arrays.asList(GlossaryTermStatus.values()));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossaryTermStatuses", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermRelationshipStatusListResponse getGlossaryTermRelationshipStatuses(String serverName, String userId) {
        String methodName = "getGlossaryTermStatuses";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossaryTermStatuses");
        GlossaryTermRelationshipStatusListResponse response = new GlossaryTermRelationshipStatusListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryTermStatuses");
            response.setStatuses(Arrays.asList(GlossaryTermRelationshipStatus.values()));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossaryTermStatuses", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermActivityTypeListResponse getGlossaryTermActivityTypes(String serverName, String userId) {
        String methodName = "getGlossaryTermStatuses";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossaryTermStatuses");
        GlossaryTermActivityTypeListResponse response = new GlossaryTermActivityTypeListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryTermStatuses");
            response.setTypes(Arrays.asList(GlossaryTermActivityType.values()));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossaryTermStatuses", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createControlledGlossaryTerm(String serverName, String userId, String glossaryGUID, boolean forLineage, boolean forDuplicateProcessing, ControlledGlossaryTermRequestBody requestBody) {
        String methodName = "createControlledGlossaryTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createControlledGlossaryTerm");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createControlledGlossaryTerm");
            if (requestBody != null) {
                GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "createControlledGlossaryTerm");
                response.setGUID(handler.createControlledGlossaryTerm(userId, glossaryGUID, requestBody.getElementProperties(), requestBody.getInitialStatus(), requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createControlledGlossaryTerm", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createControlledGlossaryTerm", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createGlossaryTermFromTemplate(String serverName, String userId, String glossaryGUID, String templateGUID, boolean deepCopy, boolean templateSubstitute, GlossaryTemplateRequestBody requestBody) {
        String methodName = "createGlossaryTermFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGlossaryTermFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createGlossaryTermFromTemplate");
            if (requestBody != null) {
                GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "createGlossaryTermFromTemplate");
                response.setGUID(handler.createGlossaryTermFromTemplate(userId, glossaryGUID, templateGUID, requestBody.getElementProperties(), deepCopy, templateSubstitute, requestBody.getGlossaryTermStatus()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createGlossaryTermFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createGlossaryTermFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGlossaryTerm(String serverName, String userId, String glossaryTermGUID, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "updateGlossaryTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateGlossaryTerm");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGlossaryTerm");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getElementProperties();
                if (referenceableProperties instanceof GlossaryTermProperties) {
                    GlossaryTermProperties properties = (GlossaryTermProperties)referenceableProperties;
                    GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "updateGlossaryTerm");
                    handler.updateGlossaryTerm(userId, glossaryTermGUID, isMergeUpdate, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(GlossaryTermProperties.class.getName(), "updateGlossaryTerm");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateGlossaryTerm", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateGlossaryTerm", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGlossaryTermStatus(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, GlossaryTermStatusRequestBody requestBody) {
        String methodName = "updateGlossaryTermStatus";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateGlossaryTermStatus");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGlossaryTermStatus");
            if (requestBody != null) {
                GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "updateGlossaryTermStatus");
                handler.updateGlossaryTermStatus(userId, glossaryTermGUID, requestBody.getGlossaryTermStatus(), requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateGlossaryTermStatus", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateGlossaryTermStatus", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGlossaryTermFromTemplate(String serverName, String userId, String glossaryTermGUID, boolean isMergeClassifications, boolean isMergeProperties, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "updateGlossaryTermFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateGlossaryTermFromTemplate");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGlossaryTermFromTemplate");
            if (requestBody != null) {
                GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "updateGlossaryTermFromTemplate");
                handler.updateGlossaryTermFromTemplate(userId, glossaryTermGUID, requestBody.getParentGUID(), isMergeClassifications, isMergeProperties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateGlossaryTermFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateGlossaryTermFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse moveGlossaryTerm(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "moveGlossaryTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "moveGlossaryTerm");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "moveGlossaryTerm");
            if (requestBody != null) {
                GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "moveGlossaryTerm");
                handler.moveGlossaryTerm(userId, glossaryTermGUID, requestBody.getParentGUID(), requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "moveGlossaryTerm", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "moveGlossaryTerm", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupTermCategory(String serverName, String userId, String glossaryCategoryGUID, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, RelationshipRequestBody requestBody) {
        String methodName = "setupTermCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupTermCategory");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupTermCategory");
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof GlossaryTermCategorization) {
                    GlossaryTermCategorization properties = (GlossaryTermCategorization)relationshipProperties;
                    GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "setupTermCategory");
                    handler.setupTermCategory(userId, glossaryCategoryGUID, glossaryTermGUID, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(GlossaryTermCategorization.class.getName(), "setupTermCategory");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupTermCategory", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupTermCategory", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearTermCategory(String serverName, String userId, String glossaryCategoryGUID, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "clearTermCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearTermCategory");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearTermCategory");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "clearTermCategory");
            if (requestBody != null) {
                handler.clearTermCategory(userId, glossaryCategoryGUID, glossaryTermGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearTermCategory(userId, glossaryCategoryGUID, glossaryTermGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearTermCategory", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NameListResponse getTermRelationshipTypeNames(String serverName, String userId) {
        String methodName = "getTermRelationshipTypeNames";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTermRelationshipTypeNames");
        NameListResponse response = new NameListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTermRelationshipTypeNames");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "getTermRelationshipTypeNames");
            response.setNames(handler.getTermRelationshipTypeNames(userId));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getTermRelationshipTypeNames", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupTermRelationship(String serverName, String userId, String glossaryTermOneGUID, String relationshipTypeName, String glossaryTermTwoGUID, boolean forLineage, boolean forDuplicateProcessing, RelationshipRequestBody requestBody) {
        String methodName = "setupTermRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupTermRelationship");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupTermRelationship");
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof GlossaryTermRelationship) {
                    GlossaryTermRelationship properties = (GlossaryTermRelationship)relationshipProperties;
                    GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "setupTermRelationship");
                    handler.setupTermRelationship(userId, glossaryTermOneGUID, relationshipTypeName, glossaryTermTwoGUID, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(GlossaryTermRelationship.class.getName(), "setupTermRelationship");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupTermRelationship", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupTermRelationship", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateTermRelationship(String serverName, String userId, String glossaryTermOneGUID, String relationshipTypeName, String glossaryTermTwoGUID, boolean forLineage, boolean forDuplicateProcessing, RelationshipRequestBody requestBody) {
        String methodName = "updateTermRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateTermRelationship");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateTermRelationship");
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof GlossaryTermRelationship) {
                    GlossaryTermRelationship properties = (GlossaryTermRelationship)relationshipProperties;
                    GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "updateTermRelationship");
                    handler.updateTermRelationship(userId, glossaryTermOneGUID, relationshipTypeName, glossaryTermTwoGUID, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(GlossaryTermRelationship.class.getName(), "updateTermRelationship");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateTermRelationship", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateTermRelationship", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearTermRelationship(String serverName, String userId, String glossaryTermOneGUID, String relationshipTypeName, String glossaryTermTwoGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "clearTermRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearTermRelationship");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearTermRelationship");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "clearTermRelationship");
            if (requestBody != null) {
                handler.clearTermRelationship(userId, glossaryTermOneGUID, relationshipTypeName, glossaryTermTwoGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearTermRelationship(userId, glossaryTermOneGUID, relationshipTypeName, glossaryTermTwoGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearTermRelationship", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setTermAsAbstractConcept(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setTermAsAbstractConcept";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setTermAsAbstractConcept");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setTermAsAbstractConcept");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "setTermAsAbstractConcept");
            if (requestBody != null) {
                handler.setTermAsAbstractConcept(userId, glossaryTermGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.setTermAsAbstractConcept(userId, glossaryTermGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setTermAsAbstractConcept", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearTermAsAbstractConcept(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearTermAsAbstractConcept";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearTermAsAbstractConcept");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearTermAsAbstractConcept");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "clearTermAsAbstractConcept");
            if (requestBody != null) {
                handler.clearTermAsAbstractConcept(userId, glossaryTermGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearTermAsAbstractConcept(userId, glossaryTermGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearTermAsAbstractConcept", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setTermAsDataField(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setTermAsDataField";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setTermAsDataField");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setTermAsDataField");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "setTermAsDataField");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof DataFieldValuesProperties) {
                    DataFieldValuesProperties properties = (DataFieldValuesProperties)classificationProperties;
                    handler.setTermAsDataField(userId, glossaryTermGUID, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else if (requestBody.getProperties() == null) {
                    handler.setTermAsDataField(userId, glossaryTermGUID, null, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(DataFieldValuesProperties.class.getName(), "setTermAsDataField");
                }
            } else {
                handler.setTermAsDataField(userId, glossaryTermGUID, null, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setTermAsDataField", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearTermAsDataField(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearTermAsDataField";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearTermAsDataField");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearTermAsDataField");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "clearTermAsDataField");
            if (requestBody != null) {
                handler.clearTermAsDataField(userId, glossaryTermGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearTermAsDataField(userId, glossaryTermGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearTermAsDataField", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setTermAsDataValue(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setTermAsDataValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setTermAsDataValue");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setTermAsDataValue");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "setTermAsDataValue");
            if (requestBody != null) {
                handler.setTermAsDataValue(userId, glossaryTermGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.setTermAsDataValue(userId, glossaryTermGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setTermAsDataValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearTermAsDataValue(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearTermAsDataValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearTermAsDataValue");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearTermAsDataValue");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "clearTermAsDataValue");
            if (requestBody != null) {
                handler.clearTermAsDataValue(userId, glossaryTermGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearTermAsDataValue(userId, glossaryTermGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearTermAsDataValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setTermAsActivity(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setTermAsActivity";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setTermAsActivity");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setTermAsActivity");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof ActivityDescriptionProperties) {
                    ActivityDescriptionProperties properties = (ActivityDescriptionProperties)classificationProperties;
                    GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "setTermAsActivity");
                    handler.setTermAsActivity(userId, glossaryTermGUID, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(ActivityDescriptionProperties.class.getName(), "setTermAsActivity");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setTermAsActivity", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setTermAsActivity", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearTermAsActivity(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearTermAsActivity";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearTermAsActivity");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearTermAsActivity");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "clearTermAsActivity");
            if (requestBody != null) {
                handler.clearTermAsActivity(userId, glossaryTermGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearTermAsActivity(userId, glossaryTermGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearTermAsActivity", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setTermAsContext(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setTermAsContext";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setTermAsContext");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setTermAsContext");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof GlossaryTermContextDefinition) {
                    GlossaryTermContextDefinition properties = (GlossaryTermContextDefinition)classificationProperties;
                    GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "setTermAsContext");
                    handler.setTermAsContext(userId, glossaryTermGUID, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(GlossaryTermContextDefinition.class.getName(), "setTermAsContext");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setTermAsContext", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setTermAsContext", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearTermAsContext(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearTermAsContext";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearTermAsContext");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearTermAsContext");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "clearTermAsContext");
            if (requestBody != null) {
                handler.clearTermAsContext(userId, glossaryTermGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearTermAsContext(userId, glossaryTermGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearTermAsContext", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setTermAsSpineObject(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setTermAsSpineObject";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setTermAsSpineObject");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setTermAsSpineObject");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "setTermAsSpineObject");
            if (requestBody != null) {
                handler.setTermAsSpineObject(userId, glossaryTermGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.setTermAsSpineObject(userId, glossaryTermGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setTermAsSpineObject", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearTermAsSpineObject(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearTermAsSpineObject";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearTermAsSpineObject");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearTermAsSpineObject");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "clearTermAsSpineObject");
            if (requestBody != null) {
                handler.clearTermAsSpineObject(userId, glossaryTermGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearTermAsSpineObject(userId, glossaryTermGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearTermAsSpineObject", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setTermAsSpineAttribute(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setTermAsSpineAttribute";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setTermAsSpineAttribute");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setTermAsSpineAttribute");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "setTermAsSpineAttribute");
            if (requestBody != null) {
                handler.setTermAsSpineAttribute(userId, glossaryTermGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.setTermAsSpineAttribute(userId, glossaryTermGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setTermAsSpineAttribute", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearTermAsSpineAttribute(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearTermAsSpineAttribute";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearTermAsSpineAttribute");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearTermAsSpineAttribute");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "clearTermAsSpineAttribute");
            if (requestBody != null) {
                handler.clearTermAsSpineAttribute(userId, glossaryTermGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearTermAsSpineAttribute(userId, glossaryTermGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearTermAsSpineAttribute", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setTermAsObjectIdentifier(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setTermAsObjectIdentifier";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setTermAsObjectIdentifier");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setTermAsObjectIdentifier");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "setTermAsObjectIdentifier");
            if (requestBody != null) {
                handler.setTermAsObjectIdentifier(userId, glossaryTermGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.setTermAsObjectIdentifier(userId, glossaryTermGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setTermAsObjectIdentifier", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearTermAsObjectIdentifier(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearTermAsObjectIdentifier";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearTermAsObjectIdentifier");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearTermAsObjectIdentifier");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "clearTermAsObjectIdentifier");
            if (requestBody != null) {
                handler.clearTermAsObjectIdentifier(userId, glossaryTermGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearTermAsObjectIdentifier(userId, glossaryTermGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearTermAsObjectIdentifier", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermElementResponse undoGlossaryTermUpdate(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "undoGlossaryTermUpdate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "undoGlossaryTermUpdate");
        GlossaryTermElementResponse response = new GlossaryTermElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "undoGlossaryTermUpdate");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "undoGlossaryTermUpdate");
            if (requestBody != null) {
                response.setElement(handler.undoGlossaryTermUpdate(userId, glossaryTermGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "undoGlossaryTermUpdate", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "undoGlossaryTermUpdate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse archiveGlossaryTerm(String serverName, String userId, String glossaryTermGUID, boolean forDuplicateProcessing, ArchiveRequestBody requestBody) {
        String methodName = "archiveGlossaryTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "archiveGlossaryTerm");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "archiveGlossaryTerm");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "archiveGlossaryTerm");
            if (requestBody != null) {
                handler.archiveGlossaryTerm(userId, glossaryTermGUID, requestBody.getElementProperties(), requestBody.getEffectiveTime(), forDuplicateProcessing);
            } else {
                handler.archiveGlossaryTerm(userId, glossaryTermGUID, null, null, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "archiveGlossaryTerm", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeGlossaryTerm(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "removeGlossaryTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeGlossaryTerm");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeGlossaryTerm");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "removeGlossaryTerm");
            if (requestBody != null) {
                handler.removeGlossaryTerm(userId, glossaryTermGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.removeGlossaryTerm(userId, glossaryTermGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeGlossaryTerm", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createNoteLog(String serverName, String userId, String elementGUID, boolean isPublic, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "createNoteLog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createNoteLog");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createNoteLog");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getElementProperties();
                if (referenceableProperties instanceof NoteLogProperties) {
                    NoteLogProperties properties = (NoteLogProperties)referenceableProperties;
                    CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "createNoteLog");
                    response.setGUID(handler.createNoteLog(userId, elementGUID, properties, isPublic, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(NoteLogProperties.class.getName(), "createNoteLog");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createNoteLog", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createNoteLog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateNoteLog(String serverName, String userId, String noteLogGUID, boolean isMergeUpdate, boolean isPublic, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "updateNoteLog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateNoteLog");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateNoteLog");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getElementProperties();
                if (referenceableProperties instanceof NoteLogProperties) {
                    NoteLogProperties properties = (NoteLogProperties)referenceableProperties;
                    CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "updateNoteLog");
                    handler.updateNoteLog(userId, noteLogGUID, isMergeUpdate, isPublic, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(NoteLogProperties.class.getName(), "updateNoteLog");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateNoteLog", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateNoteLog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeNoteLog(String serverName, String userId, String noteLogGUID, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "removeNoteLog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeNoteLog");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeNoteLog");
            CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "removeNoteLog");
            if (requestBody != null) {
                handler.removeNoteLog(userId, noteLogGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.removeNoteLog(userId, noteLogGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeNoteLog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createNote(String serverName, String userId, String noteLogGUID, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "createNote";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createNote");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createNote");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getElementProperties();
                if (referenceableProperties instanceof NoteProperties) {
                    NoteProperties properties = (NoteProperties)referenceableProperties;
                    CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "createNote");
                    response.setGUID(handler.createNote(userId, noteLogGUID, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(NoteProperties.class.getName(), "createNote");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createNote", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createNote", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateNote(String serverName, String userId, String noteGUID, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "updateNote";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateNote");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateNote");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getElementProperties();
                if (referenceableProperties instanceof NoteProperties) {
                    NoteProperties properties = (NoteProperties)referenceableProperties;
                    CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "updateNote");
                    handler.updateNote(userId, noteGUID, isMergeUpdate, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(NoteProperties.class.getName(), "updateNote");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateNote", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateNote", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeNote(String serverName, String userId, String noteGUID, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "removeNote";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeNote");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeNote");
            CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "removeNote");
            if (requestBody != null) {
                handler.removeNote(userId, noteGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.removeNote(userId, noteGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeNote", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setConfidenceClassification(String serverName, String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setConfidenceClassification";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setConfidenceClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setConfidenceClassification");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof GovernanceClassificationProperties) {
                    GovernanceClassificationProperties properties = (GovernanceClassificationProperties)classificationProperties;
                    StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "setConfidenceClassification");
                    handler.setConfidenceClassification(userId, elementGUID, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(GovernanceClassificationProperties.class.getName(), "setConfidenceClassification");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setConfidenceClassification", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setConfidenceClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearConfidenceClassification(String serverName, String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeRequestBody requestBody) {
        String methodName = "clearConfidenceClassification";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearConfidenceClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearConfidenceClassification");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "clearConfidenceClassification");
            if (requestBody != null) {
                handler.clearConfidenceClassification(userId, elementGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearConfidenceClassification(userId, elementGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearConfidenceClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setCriticalityClassification(String serverName, String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setCriticalityClassification";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setCriticalityClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setCriticalityClassification");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof GovernanceClassificationProperties) {
                    GovernanceClassificationProperties properties = (GovernanceClassificationProperties)classificationProperties;
                    StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "setCriticalityClassification");
                    handler.setCriticalityClassification(userId, elementGUID, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(GovernanceClassificationProperties.class.getName(), "setCriticalityClassification");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setCriticalityClassification", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setCriticalityClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearCriticalityClassification(String serverName, String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeRequestBody requestBody) {
        String methodName = "clearCriticalityClassification";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearCriticalityClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearCriticalityClassification");
            if (requestBody != null) {
                StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "clearCriticalityClassification");
                handler.clearCriticalityClassification(userId, elementGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "clearCriticalityClassification", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearCriticalityClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setConfidentialityClassification(String serverName, String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setConfidentialityClassification";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setConfidentialityClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setConfidentialityClassification");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof GovernanceClassificationProperties) {
                    GovernanceClassificationProperties properties = (GovernanceClassificationProperties)classificationProperties;
                    StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "setConfidentialityClassification");
                    handler.setConfidentialityClassification(userId, elementGUID, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(GovernanceClassificationProperties.class.getName(), "setConfidentialityClassification");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setConfidentialityClassification", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setConfidentialityClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearConfidentialityClassification(String serverName, String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeRequestBody requestBody) {
        String methodName = "clearConfidentialityClassification";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearConfidentialityClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearConfidentialityClassification");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "clearConfidentialityClassification");
            if (requestBody != null) {
                handler.clearConfidentialityClassification(userId, elementGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearConfidentialityClassification(userId, elementGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearConfidentialityClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setRetentionClassification(String serverName, String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setRetentionClassification";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setRetentionClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setRetentionClassification");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof RetentionClassificationProperties) {
                    RetentionClassificationProperties properties = (RetentionClassificationProperties)classificationProperties;
                    StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "setRetentionClassification");
                    handler.setRetentionClassification(userId, elementGUID, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(RetentionClassificationProperties.class.getName(), "setRetentionClassification");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setRetentionClassification", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setRetentionClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearRetentionClassification(String serverName, String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeRequestBody requestBody) {
        String methodName = "clearRetentionClassification";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearRetentionClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearRetentionClassification");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "clearRetentionClassification");
            if (requestBody != null) {
                handler.clearRetentionClassification(userId, elementGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearRetentionClassification(userId, elementGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearRetentionClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addSecurityTags(String serverName, String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "addSecurityTags";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addSecurityTags");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addSecurityTags");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof SecurityTagsProperties) {
                    SecurityTagsProperties properties = (SecurityTagsProperties)classificationProperties;
                    StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "addSecurityTags");
                    handler.addSecurityTags(userId, elementGUID, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(SecurityTagsProperties.class.getName(), "addSecurityTags");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addSecurityTags", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addSecurityTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearSecurityTags(String serverName, String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearSecurityTags";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearSecurityTags");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearSecurityTags");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "clearSecurityTags");
            if (requestBody != null) {
                handler.clearSecurityTags(userId, elementGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearSecurityTags(userId, elementGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearSecurityTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addOwnership(String serverName, String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "addOwnership";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addOwnership");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addOwnership");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof OwnerProperties) {
                    OwnerProperties properties = (OwnerProperties)classificationProperties;
                    StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "addOwnership");
                    handler.addOwnership(userId, elementGUID, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(OwnerProperties.class.getName(), "addOwnership");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addOwnership", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addOwnership", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearOwnership(String serverName, String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearOwnership";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearOwnership");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearOwnership");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "clearOwnership");
            if (requestBody != null) {
                handler.clearOwnership(userId, elementGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearOwnership(userId, elementGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearOwnership", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addElementToSubjectArea(String serverName, String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "addElementToSubjectArea";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addElementToSubjectArea");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addElementToSubjectArea");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof SubjectAreaMemberProperties) {
                    SubjectAreaMemberProperties properties = (SubjectAreaMemberProperties)classificationProperties;
                    StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "addElementToSubjectArea");
                    handler.addElementToSubjectArea(userId, elementGUID, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(SubjectAreaMemberProperties.class.getName(), "addElementToSubjectArea");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addElementToSubjectArea", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addElementToSubjectArea", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeElementFromSubjectArea(String serverName, String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "removeElementFromSubjectArea";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeElementFromSubjectArea");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeElementFromSubjectArea");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "removeElementFromSubjectArea");
            if (requestBody == null) {
                handler.removeElementFromSubjectArea(userId, elementGUID, null, forLineage, forDuplicateProcessing);
            } else {
                handler.removeElementFromSubjectArea(userId, elementGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeElementFromSubjectArea", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupSemanticAssignment(String serverName, String userId, String elementGUID, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, RelationshipRequestBody requestBody) {
        String methodName = "setupSemanticAssignment";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupSemanticAssignment");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupSemanticAssignment");
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof SemanticAssignmentProperties) {
                    SemanticAssignmentProperties properties = (SemanticAssignmentProperties)relationshipProperties;
                    StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "setupSemanticAssignment");
                    handler.setupSemanticAssignment(userId, elementGUID, glossaryTermGUID, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(SemanticAssignmentProperties.class.getName(), "setupSemanticAssignment");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupSemanticAssignment", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupSemanticAssignment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearSemanticAssignment(String serverName, String userId, String elementGUID, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "clearSemanticAssignment";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearSemanticAssignment");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearSemanticAssignment");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "clearSemanticAssignment");
            if (requestBody == null) {
                handler.clearSemanticAssignment(userId, elementGUID, glossaryTermGUID, null, forLineage, forDuplicateProcessing);
            } else {
                handler.clearSemanticAssignment(userId, elementGUID, glossaryTermGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearSemanticAssignment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addGovernanceDefinitionToElement(String serverName, String userId, String definitionGUID, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, RelationshipRequestBody requestBody) {
        String methodName = "addGovernanceDefinitionToElement";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addGovernanceDefinitionToElement");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addGovernanceDefinitionToElement");
            if (requestBody != null) {
                StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "addGovernanceDefinitionToElement");
                handler.addGovernanceDefinitionToElement(userId, definitionGUID, elementGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addGovernanceDefinitionToElement", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addGovernanceDefinitionToElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeGovernanceDefinitionFromElement(String serverName, String userId, String definitionGUID, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "removeGovernanceDefinitionFromElement";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeGovernanceDefinitionFromElement");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeGovernanceDefinitionFromElement");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "removeGovernanceDefinitionFromElement");
            if (requestBody == null) {
                handler.removeGovernanceDefinitionFromElement(userId, elementGUID, definitionGUID, null, forLineage, forDuplicateProcessing);
            } else {
                handler.removeGovernanceDefinitionFromElement(userId, elementGUID, definitionGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeGovernanceDefinitionFromElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

