/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryworkflow.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum GlossaryWorkflowAuditCode implements AuditLogMessageSet
{
    SERVICE_INITIALIZING("OMVS-GLOSSARY-WORKFLOW-0001", OMRSAuditLogRecordSeverity.STARTUP, "The Glossary Workflow Open Metadata View Service (OMVS) is initializing", "The local server is initializing the Glossary Workflow Open Metadata View Service. If the initialization is successful then audit message OMVS-GLOSSARY-WORKFLOW-0002 will be issued, if there were errors then they should be shown in the audit log. ", "No action is required. This is part of the normal operation of the Glossary Workflow Open Metadata View Service."),
    SERVICE_INITIALIZED("OMVS-GLOSSARY-WORKFLOW-0002", OMRSAuditLogRecordSeverity.STARTUP, "The Glossary Workflow Open Metadata View Service (OMVS) is initialized", "The Glossary Workflow OMVS has completed initialization. Calls will be accepted by this service, if OMRS is also configured and the view server has been started. ", "No action is required.  This is part of the normal operation of the Glossary Workflow Open Metadata View Service. Once the OMRS is configured and the server is started, Glossary Workflowview service requests can be accepted."),
    SERVICE_SHUTDOWN("OMVS-GLOSSARY-WORKFLOW-0003", OMRSAuditLogRecordSeverity.SHUTDOWN, "The Glossary Workflow Open Metadata View Service (OMVS) is shutting down", "The local server has requested shutdown of the Glossary Workflow OMVS.", "No action is required. The operator should verify that shutdown was intended. This is part of the normal operation of the Glossary Workflow OMVS."),
    SERVICE_INSTANCE_FAILURE("OMVS-GLOSSARY-WORKFLOW-0004", OMRSAuditLogRecordSeverity.EXCEPTION, "The Glossary Workflow Open Metadata View Service (OMVS) is unable to initialize a new instance; error message is {0}", "The view service detected an error during the start up of a specific server instance.  Its services are not available for the server.", "Review the error message and any other reported failures to determine the cause of the problem.  Once this is resolved, restart the server."),
    SERVICE_TERMINATING("OMVS-GLOSSARY-WORKFLOW-0005", OMRSAuditLogRecordSeverity.SHUTDOWN, "The Glossary Workflow Open Metadata View Service (OMVS) is shutting down server instance {0}", "The local handler has requested shut down of the Glossary Workflow OMVS.", "No action is required. This is part of the normal operation of the service."),
    UNEXPECTED_EXCEPTION("OMVS-GLOSSARY-WORKFLOW-0006", OMRSAuditLogRecordSeverity.EXCEPTION, "The Open Metadata Service has generated an unexpected {0} exception during method {1}.  The message was: {2}", "The request returned an Exception.", "This is probably a logic error. Review the stack trace to identify where the error occurred and work to resolve the cause.");

    private String logMessageId;
    private OMRSAuditLogRecordSeverity severity;
    private String logMessage;
    private String systemAction;
    private String userAction;
    private static final Logger log;

    private GlossaryWorkflowAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        AuditLogMessageDefinition messageDefinition = new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "GlossaryWorkflowAuditCode{logMessageId='" + this.logMessageId + "', severity=" + this.severity + ", logMessage='" + this.logMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "', messageDefinition=" + this.getMessageDefinition() + "}";
    }

    static {
        log = LoggerFactory.getLogger(GlossaryWorkflowAuditCode.class);
    }
}

