/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryworkflow.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermElementResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.EffectiveTimeRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.viewservices.glossaryworkflow.rest.ArchiveRequestBody;
import org.odpi.openmetadata.viewservices.glossaryworkflow.rest.ClassificationRequestBody;
import org.odpi.openmetadata.viewservices.glossaryworkflow.rest.ControlledGlossaryTermRequestBody;
import org.odpi.openmetadata.viewservices.glossaryworkflow.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.viewservices.glossaryworkflow.rest.GlossaryTemplateRequestBody;
import org.odpi.openmetadata.viewservices.glossaryworkflow.rest.GlossaryTermActivityTypeListResponse;
import org.odpi.openmetadata.viewservices.glossaryworkflow.rest.GlossaryTermRelationshipStatusListResponse;
import org.odpi.openmetadata.viewservices.glossaryworkflow.rest.GlossaryTermStatusListResponse;
import org.odpi.openmetadata.viewservices.glossaryworkflow.rest.GlossaryTermStatusRequestBody;
import org.odpi.openmetadata.viewservices.glossaryworkflow.rest.ReferenceableRequestBody;
import org.odpi.openmetadata.viewservices.glossaryworkflow.rest.ReferenceableUpdateRequestBody;
import org.odpi.openmetadata.viewservices.glossaryworkflow.rest.RelationshipRequestBody;
import org.odpi.openmetadata.viewservices.glossaryworkflow.rest.TemplateRequestBody;
import org.odpi.openmetadata.viewservices.glossaryworkflow.server.GlossaryWorkflowRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/view-services/glossary-workflow/users/{userId}"})
@Tag(name="Glossary Workflow OMVS", description="The Glossary Workflow OMVS enables the caller to create glossary terms and organize them into categories as part of a controlled workflow process.  It supports the editing glossary and multiple states.", externalDocs=@ExternalDocumentation(description="Glossary Workflow Open Metadata View Service (OMVS)", url="https://egeria-project.org/services/omvs/glossary-workflow/overview/"))
public class GlossaryWorkflowResource {
    private final GlossaryWorkflowRESTServices restAPI = new GlossaryWorkflowRESTServices();

    @PostMapping(path={"/glossaries"})
    public GUIDResponse createGlossary(@PathVariable String serverName, @PathVariable String userId, @RequestBody ReferenceableRequestBody requestBody) {
        return this.restAPI.createGlossary(serverName, userId, requestBody);
    }

    @PostMapping(path={"/glossaries/from-template/{templateGUID}"})
    public GUIDResponse createGlossaryFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @RequestParam(required=false, defaultValue="true") boolean deepCopy, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createGlossaryFromTemplate(serverName, userId, templateGUID, deepCopy, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/update"})
    public VoidResponse updateGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean isMergeUpdate, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.updateGlossary(serverName, userId, glossaryGUID, isMergeUpdate, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/remove"})
    public VoidResponse removeGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.removeGlossary(serverName, userId, glossaryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/is-editing-glossary"})
    public VoidResponse setGlossaryAsEditingGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ClassificationRequestBody requestBody) {
        return this.restAPI.setGlossaryAsEditingGlossary(serverName, userId, glossaryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/is-editing-glossary/remove"})
    public VoidResponse clearGlossaryAsEditingGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearGlossaryAsEditingGlossary(serverName, userId, glossaryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/is-staging-glossary"})
    public VoidResponse setGlossaryAsStagingGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ClassificationRequestBody requestBody) {
        return this.restAPI.setGlossaryAsStagingGlossary(serverName, userId, glossaryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/is-staging-glossary/remove"})
    public VoidResponse clearGlossaryAsStagingGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearGlossaryAsStagingGlossary(serverName, userId, glossaryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/is-taxonomy"})
    public VoidResponse setGlossaryAsTaxonomy(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ClassificationRequestBody requestBody) {
        return this.restAPI.setGlossaryAsTaxonomy(serverName, userId, glossaryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/is-taxonomy/remove"})
    public VoidResponse clearGlossaryAsTaxonomy(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearGlossaryAsTaxonomy(serverName, userId, glossaryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/is-canonical-vocabulary"})
    public VoidResponse setGlossaryAsCanonical(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ClassificationRequestBody requestBody) {
        return this.restAPI.setGlossaryAsCanonical(serverName, userId, glossaryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/is-canonical-vocabulary/remove"})
    public VoidResponse clearGlossaryAsCanonical(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearGlossaryAsCanonical(serverName, userId, glossaryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/categories"})
    public GUIDResponse createGlossaryCategory(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean isRootCategory, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.createGlossaryCategory(serverName, userId, glossaryGUID, isRootCategory, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/categories/from-template/{templateGUID}"})
    public GUIDResponse createGlossaryCategoryFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @PathVariable String templateGUID, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createGlossaryCategoryFromTemplate(serverName, userId, glossaryGUID, templateGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryCategoryGUID}/update"})
    public VoidResponse updateGlossaryCategory(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryCategoryGUID, @RequestParam(required=false, defaultValue="false") boolean isMergeUpdate, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.updateGlossaryCategory(serverName, userId, glossaryCategoryGUID, isMergeUpdate, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryParentCategoryGUID}/subcategories/{glossaryChildCategoryGUID}"})
    public VoidResponse setupCategoryParent(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryParentCategoryGUID, @PathVariable String glossaryChildCategoryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) RelationshipRequestBody requestBody) {
        return this.restAPI.setupCategoryParent(serverName, userId, glossaryParentCategoryGUID, glossaryChildCategoryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryParentCategoryGUID}/subcategories/{glossaryChildCategoryGUID}/remove"})
    public VoidResponse clearCategoryParent(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryParentCategoryGUID, @PathVariable String glossaryChildCategoryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.clearCategoryParent(serverName, userId, glossaryParentCategoryGUID, glossaryChildCategoryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryCategoryGUID}/remove"})
    public VoidResponse removeGlossaryCategory(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryCategoryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.removeGlossaryCategory(serverName, userId, glossaryCategoryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @GetMapping(path={"/glossaries/terms/status-list"})
    public GlossaryTermStatusListResponse getGlossaryTermStatuses(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getGlossaryTermStatuses(serverName, userId);
    }

    @GetMapping(path={"/glossaries/terms/relationships/status-list"})
    public GlossaryTermRelationshipStatusListResponse getGlossaryTermRelationshipStatuses(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getGlossaryTermRelationshipStatuses(serverName, userId);
    }

    @GetMapping(path={"/glossaries/terms/activity-types"})
    public GlossaryTermActivityTypeListResponse getGlossaryTermActivityTypes(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getGlossaryTermActivityTypes(serverName, userId);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/terms/new-controlled"})
    public GUIDResponse createControlledGlossaryTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ControlledGlossaryTermRequestBody requestBody) {
        return this.restAPI.createControlledGlossaryTerm(serverName, userId, glossaryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/terms/from-template/{templateGUID}"})
    public GUIDResponse createGlossaryTermFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @PathVariable String templateGUID, @RequestParam(required=false, defaultValue="true") boolean deepCopy, @RequestParam(required=false, defaultValue="true") boolean templateSubstitute, @RequestBody GlossaryTemplateRequestBody requestBody) {
        return this.restAPI.createGlossaryTermFromTemplate(serverName, userId, glossaryGUID, templateGUID, deepCopy, templateSubstitute, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/update"})
    public VoidResponse updateGlossaryTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean isMergeUpdate, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.updateGlossaryTerm(serverName, userId, glossaryTermGUID, isMergeUpdate, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/status"})
    public VoidResponse updateGlossaryTermStatus(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody GlossaryTermStatusRequestBody requestBody) {
        return this.restAPI.updateGlossaryTermStatus(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/update/from-template"})
    public VoidResponse updateGlossaryTermFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean isMergeClassifications, @RequestParam(required=false, defaultValue="false") boolean isMergeProperties, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.updateGlossaryTermFromTemplate(serverName, userId, glossaryTermGUID, isMergeClassifications, isMergeProperties, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/move"})
    public VoidResponse moveGlossaryTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.moveGlossaryTerm(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryCategoryGUID}/terms/{glossaryTermGUID}"})
    public VoidResponse setupTermCategory(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryCategoryGUID, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupTermCategory(serverName, userId, glossaryCategoryGUID, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryCategoryGUID}/terms/{glossaryTermGUID}/remove"})
    public VoidResponse clearTermCategory(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryCategoryGUID, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.clearTermCategory(serverName, userId, glossaryCategoryGUID, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @GetMapping(path={"/glossaries/terms/relationships/type-names"})
    public NameListResponse getTermRelationshipTypeNames(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getTermRelationshipTypeNames(serverName, userId);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermOneGUID}/relationships/{relationshipTypeName}/terms/{glossaryTermTwoGUID}"})
    public VoidResponse setupTermRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermOneGUID, @PathVariable String relationshipTypeName, @PathVariable String glossaryTermTwoGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupTermRelationship(serverName, userId, glossaryTermOneGUID, relationshipTypeName, glossaryTermTwoGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermOneGUID}/relationships/{relationshipTypeName}/terms/{glossaryTermTwoGUID}/update"})
    public VoidResponse updateTermRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermOneGUID, @PathVariable String relationshipTypeName, @PathVariable String glossaryTermTwoGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.updateTermRelationship(serverName, userId, glossaryTermOneGUID, relationshipTypeName, glossaryTermTwoGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermOneGUID}/relationships/{relationshipTypeName}/terms/{glossaryTermTwoGUID}/remove"})
    public VoidResponse clearTermRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermOneGUID, @PathVariable String relationshipTypeName, @PathVariable String glossaryTermTwoGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.clearTermRelationship(serverName, userId, glossaryTermOneGUID, relationshipTypeName, glossaryTermTwoGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-abstract-concept"})
    public VoidResponse setTermAsAbstractConcept(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.setTermAsAbstractConcept(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-abstract-concept/remove"})
    public VoidResponse clearTermAsAbstractConcept(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearTermAsAbstractConcept(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-data-field"})
    public VoidResponse setTermAsDataField(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.setTermAsDataField(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-data-field/remove"})
    public VoidResponse clearTermAsDataField(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearTermAsDataField(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-data-value"})
    public VoidResponse setTermAsDataValue(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.setTermAsDataValue(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-data-value/remove"})
    public VoidResponse clearTermAsDataValue(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearTermAsDataValue(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-activity"})
    public VoidResponse setTermAsActivity(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ClassificationRequestBody requestBody) {
        return this.restAPI.setTermAsActivity(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-activity/remove"})
    public VoidResponse clearTermAsActivity(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearTermAsActivity(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-context-definition"})
    public VoidResponse setTermAsContext(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ClassificationRequestBody requestBody) {
        return this.restAPI.setTermAsContext(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-context-definition/remove"})
    public VoidResponse clearTermAsContext(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearTermAsContext(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-spine-object"})
    public VoidResponse setTermAsSpineObject(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.setTermAsSpineObject(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-spine-object/remove"})
    public VoidResponse clearTermAsSpineObject(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearTermAsSpineObject(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-spine-attribute"})
    public VoidResponse setTermAsSpineAttribute(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.setTermAsSpineAttribute(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-spine-attribute/remove"})
    public VoidResponse clearTermAsSpineAttribute(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearTermAsSpineAttribute(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-object-identifier"})
    public VoidResponse setTermAsObjectIdentifier(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.setTermAsObjectIdentifier(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-object-identifier/remove"})
    public VoidResponse clearTermAsObjectIdentifier(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearTermAsObjectIdentifier(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/undo"})
    public GlossaryTermElementResponse undoGlossaryTermUpdate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.undoGlossaryTermUpdate(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/archive"})
    public VoidResponse archiveGlossaryTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ArchiveRequestBody requestBody) {
        return this.restAPI.archiveGlossaryTerm(serverName, userId, glossaryTermGUID, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/remove"})
    public VoidResponse removeGlossaryTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.removeGlossaryTerm(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(value={"/elements/{elementGUID}/note-logs"})
    public GUIDResponse createNoteLog(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="true") boolean isPublic, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.createNoteLog(serverName, userId, elementGUID, isPublic, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(value={"/note-logs/{noteLogGUID}/update"})
    public VoidResponse updateNoteLog(@PathVariable String serverName, @PathVariable String userId, @PathVariable String noteLogGUID, @RequestParam(required=false, defaultValue="false") boolean isMergeUpdate, @RequestParam(required=false, defaultValue="true") boolean isPublic, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.updateNoteLog(serverName, userId, noteLogGUID, isMergeUpdate, isPublic, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(value={"/note-logs/{noteLogGUID}/remove"})
    public VoidResponse removeNoteLog(@PathVariable String serverName, @PathVariable String userId, @PathVariable String noteLogGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.removeNoteLog(serverName, userId, noteLogGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(value={"/note-logs/{noteLogGUID}/notes"})
    public GUIDResponse createNote(@PathVariable String serverName, @PathVariable String userId, @PathVariable String noteLogGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.createNote(serverName, userId, noteLogGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(value={"/note-logs/notes/{noteGUID}/update"})
    public VoidResponse updateNote(@PathVariable String serverName, @PathVariable String userId, @PathVariable String noteGUID, @RequestParam(required=false, defaultValue="false") boolean isMergeUpdate, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.updateNote(serverName, userId, noteGUID, isMergeUpdate, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(value={"/note-logs/notes/{noteGUID}/remove"})
    public VoidResponse removeNote(@PathVariable String serverName, @PathVariable String userId, @PathVariable String noteGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.removeNote(serverName, userId, noteGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/confidence"})
    public VoidResponse setConfidenceClassification(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.setConfidenceClassification(serverName, userId, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/confidence/remove"})
    public VoidResponse clearConfidenceClassification(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeRequestBody requestBody) {
        return this.restAPI.clearConfidenceClassification(serverName, userId, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/criticality"})
    public VoidResponse setCriticalityClassification(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.setCriticalityClassification(serverName, userId, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/criticality/remove"})
    public VoidResponse clearCriticalityClassification(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeRequestBody requestBody) {
        return this.restAPI.clearCriticalityClassification(serverName, userId, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/confidentiality"})
    public VoidResponse setConfidentialityClassification(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.setConfidentialityClassification(serverName, userId, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/confidentiality/remove"})
    public VoidResponse clearConfidentialityClassification(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeRequestBody requestBody) {
        return this.restAPI.clearConfidentialityClassification(serverName, userId, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/retention"})
    public VoidResponse setRetentionClassification(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.setRetentionClassification(serverName, userId, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/retention/remove"})
    public VoidResponse clearRetentionClassification(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeRequestBody requestBody) {
        return this.restAPI.clearRetentionClassification(serverName, userId, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/security-tags"})
    public VoidResponse addSecurityTags(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.addSecurityTags(serverName, userId, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/security-tags/remove"})
    public VoidResponse clearSecurityTags(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearSecurityTags(serverName, userId, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/ownership"})
    public VoidResponse addOwnership(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.addOwnership(serverName, userId, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/ownership/remove"})
    public VoidResponse clearOwnership(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearOwnership(serverName, userId, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/subject-area-member"})
    public VoidResponse addElementToSubjectArea(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.addElementToSubjectArea(serverName, userId, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/subject-area-member/remove"})
    public VoidResponse removeElementFromSubjectArea(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.removeElementFromSubjectArea(serverName, userId, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/semantic-assignment/terms/{glossaryTermGUID}"})
    public VoidResponse setupSemanticAssignment(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) RelationshipRequestBody requestBody) {
        return this.restAPI.setupSemanticAssignment(serverName, userId, elementGUID, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/semantic-assignment/terms/{glossaryTermGUID}/remove"})
    public VoidResponse clearSemanticAssignment(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.clearSemanticAssignment(serverName, userId, elementGUID, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/governed-by/definition/{definitionGUID}"})
    public VoidResponse addGovernanceDefinitionToElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String definitionGUID, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) RelationshipRequestBody requestBody) {
        return this.restAPI.addGovernanceDefinitionToElement(serverName, userId, definitionGUID, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/governed-by/definition/{definitionGUID}/remove"})
    public VoidResponse removeGovernanceDefinitionFromElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String definitionGUID, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.removeGovernanceDefinitionFromElement(serverName, userId, definitionGUID, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }
}

