/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.engineservices.governanceaction.client;

import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.engineservices.governanceaction.api.GovernanceActionAPI;
import org.odpi.openmetadata.engineservices.governanceaction.client.rest.GovernanceActionRESTClient;
import org.odpi.openmetadata.engineservices.governanceaction.properties.ProviderReport;
import org.odpi.openmetadata.engineservices.governanceaction.rest.ProviderReportResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class GovernanceActionEngineClient
implements GovernanceActionAPI {
    private String serverName;
    private String serverPlatformRootURL;
    private GovernanceActionRESTClient restClient;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();

    public GovernanceActionEngineClient(String serverPlatformRootURL, String serverName) throws InvalidParameterException {
        this.serverPlatformRootURL = serverPlatformRootURL;
        this.serverName = serverName;
        this.restClient = new GovernanceActionRESTClient(serverName, serverPlatformRootURL);
    }

    public GovernanceActionEngineClient(String serverPlatformRootURL, String serverName, String userId, String password) throws InvalidParameterException {
        this.serverPlatformRootURL = serverPlatformRootURL;
        this.serverName = serverName;
        this.restClient = new GovernanceActionRESTClient(serverName, serverPlatformRootURL, userId, password);
    }

    public ProviderReport validateConnector(String userId, String connectorProviderClassName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "validateConnector";
        String nameParameter = "connectorProviderClassName";
        String urlTemplate = "/servers/{0}/open-metadata/engine-services/governance-action/users/{1}/validate-connector";
        this.invalidParameterHandler.validateUserId(userId, "validateConnector");
        this.invalidParameterHandler.validateName(connectorProviderClassName, "connectorProviderClassName", "validateConnector");
        ProviderReportResponse restResult = this.restClient.callProviderReportGetRESTCall("validateConnector", this.serverPlatformRootURL + "/servers/{0}/open-metadata/engine-services/governance-action/users/{1}/validate-connector", this.serverName, userId, connectorProviderClassName);
        return restResult.getProviderReport();
    }
}

