/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.engineservices.governanceaction.client;

import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.properties.ConnectorReport;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectorReportResponse;
import org.odpi.openmetadata.engineservices.governanceaction.api.GovernanceActionAPI;
import org.odpi.openmetadata.engineservices.governanceaction.client.rest.GovernanceActionRESTClient;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;

public class GovernanceActionEngineClient
implements GovernanceActionAPI {
    private final String serverName;
    private final String serverPlatformRootURL;
    private final GovernanceActionRESTClient restClient;
    private final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();

    public GovernanceActionEngineClient(String serverPlatformRootURL, String serverName) throws InvalidParameterException {
        this.serverPlatformRootURL = serverPlatformRootURL;
        this.serverName = serverName;
        this.restClient = new GovernanceActionRESTClient(serverName, serverPlatformRootURL);
    }

    public GovernanceActionEngineClient(String serverPlatformRootURL, String serverName, String userId, String password) throws InvalidParameterException {
        this.serverPlatformRootURL = serverPlatformRootURL;
        this.serverName = serverName;
        this.restClient = new GovernanceActionRESTClient(serverName, serverPlatformRootURL, userId, password);
    }

    public ConnectorReport validateConnector(String userId, String connectorProviderClassName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "validateConnector";
        String nameParameter = "connectorProviderClassName";
        String urlTemplate = "/servers/{0}/open-metadata/engine-services/governance-action/users/{1}/validate-connector";
        this.invalidParameterHandler.validateUserId(userId, "validateConnector");
        this.invalidParameterHandler.validateName(connectorProviderClassName, "connectorProviderClassName", "validateConnector");
        ConnectorReportResponse restResult = this.restClient.callOCFConnectorReportGetRESTCall("validateConnector", this.serverPlatformRootURL + "/servers/{0}/open-metadata/engine-services/governance-action/users/{1}/validate-connector", new Object[]{this.serverName, userId, connectorProviderClassName});
        return restResult.getConnectorReport();
    }
}

