/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.governanceactions.watchdog;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.governanceactions.ffdc.GovernanceActionConnectorsAuditCode;
import org.odpi.openmetadata.adapters.connectors.governanceactions.ffdc.GovernanceActionConnectorsErrorCode;
import org.odpi.openmetadata.adapters.connectors.governanceactions.watchdog.GenericWatchdogListener;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.governanceaction.WatchdogGovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.WatchdogGovernanceListener;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogEventType;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogGovernanceEvent;
import org.odpi.openmetadata.frameworks.governanceaction.ffdc.GovernanceServiceException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.NewActionTarget;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;

public abstract class GenericWatchdogGovernanceActionConnector
extends WatchdogGovernanceActionService {
    List<String> instancesToListenTo = new ArrayList<String>();
    String actionTargetName = null;
    String actionTargetTwoName = null;
    String newElementProcessName = null;
    String updatedElementProcessName = null;
    String deletedElementProcessName = null;
    String classifiedElementProcessName = null;
    String reclassifiedElementProcessName = null;
    String declassifiedElementProcessName = null;
    String newRelationshipProcessName = null;
    String updatedRelationshipProcessName = null;
    String deletedRelationshipProcessName = null;
    volatile boolean completed = false;

    void start(String defaultTypeName) throws ConnectorCheckedException {
        List actionTargetElements;
        super.start();
        String methodName = "start";
        GenericWatchdogListener listener = new GenericWatchdogListener(this);
        String interestingTypeName = this.getProperty("interestingTypeName", defaultTypeName);
        String instanceToListenTo = this.getProperty("instanceToMonitor", null);
        if (instanceToListenTo != null) {
            this.instancesToListenTo.add(instanceToListenTo);
        }
        if ((actionTargetElements = this.governanceContext.getActionTargetElements()) != null) {
            for (ActionTargetElement actionTargetElement : actionTargetElements) {
                if (actionTargetElement == null || !"instanceToMonitor".equals(actionTargetElement.getActionTargetName())) continue;
                this.instancesToListenTo.add(actionTargetElement.getActionTargetGUID());
            }
        }
        this.actionTargetName = this.getProperty("actionTargetName", "receivedElement");
        this.actionTargetTwoName = this.getProperty("actionTargetNameTwo", "receivedElementTwo");
        this.newElementProcessName = this.getProperty("newElementProcessName", null);
        this.updatedElementProcessName = this.getProperty("updatedElementProcessName", null);
        this.deletedElementProcessName = this.getProperty("deletedElementProcessName", null);
        this.classifiedElementProcessName = this.getProperty("classifiedElementProcessName", null);
        this.reclassifiedElementProcessName = this.getProperty("reclassifiedElementProcessName", null);
        this.declassifiedElementProcessName = this.getProperty("declassifiedElementProcessName", null);
        this.newRelationshipProcessName = this.getProperty("newRelationshipProcessName", null);
        this.updatedRelationshipProcessName = this.getProperty("updatedRelationshipProcessName", null);
        this.deletedRelationshipProcessName = this.getProperty("deletedRelationshipProcessName", null);
        try {
            ArrayList<WatchdogEventType> interestingEventTypes = new ArrayList<WatchdogEventType>();
            if (this.newElementProcessName != null) {
                interestingEventTypes.add(WatchdogEventType.NEW_ELEMENT);
                interestingEventTypes.add(WatchdogEventType.REFRESHED_ELEMENT);
            }
            if (this.updatedElementProcessName != null) {
                interestingEventTypes.add(WatchdogEventType.UPDATED_ELEMENT_PROPERTIES);
            }
            if (this.deletedElementProcessName != null) {
                interestingEventTypes.add(WatchdogEventType.DELETED_ELEMENT);
            }
            if (this.classifiedElementProcessName != null) {
                interestingEventTypes.add(WatchdogEventType.NEW_CLASSIFICATION);
            }
            if (this.reclassifiedElementProcessName != null) {
                interestingEventTypes.add(WatchdogEventType.UPDATED_CLASSIFICATION_PROPERTIES);
            }
            if (this.declassifiedElementProcessName != null) {
                interestingEventTypes.add(WatchdogEventType.DELETED_CLASSIFICATION);
            }
            if (this.newRelationshipProcessName != null) {
                interestingEventTypes.add(WatchdogEventType.NEW_RELATIONSHIP);
            }
            if (this.updatedRelationshipProcessName != null) {
                interestingEventTypes.add(WatchdogEventType.UPDATED_RELATIONSHIP_PROPERTIES);
            }
            if (this.deletedRelationshipProcessName != null) {
                interestingEventTypes.add(WatchdogEventType.DELETED_RELATIONSHIP);
            }
            ArrayList<String> interestingMetadataTypes = new ArrayList<String>();
            interestingMetadataTypes.add(interestingTypeName);
            if (this.instancesToListenTo.isEmpty()) {
                this.instancesToListenTo = null;
                this.governanceContext.registerListener((WatchdogGovernanceListener)listener, interestingEventTypes, interestingMetadataTypes, null);
            } else if (this.instancesToListenTo.size() == 1) {
                this.governanceContext.registerListener((WatchdogGovernanceListener)listener, interestingEventTypes, interestingMetadataTypes, this.instancesToListenTo.get(0));
                this.instancesToListenTo = null;
            } else {
                this.governanceContext.registerListener((WatchdogGovernanceListener)listener, interestingEventTypes, interestingMetadataTypes, null);
            }
        }
        catch (Exception error) {
            block21: {
                try {
                    ArrayList<String> outputGuards = new ArrayList<String>();
                    outputGuards.add("monitoring-failed");
                    this.governanceContext.recordCompletionStatus(CompletionStatus.FAILED, outputGuards);
                }
                catch (Exception nestedError) {
                    if (this.auditLog == null) break block21;
                    this.auditLog.logException("start", GovernanceActionConnectorsAuditCode.UNABLE_TO_SET_COMPLETION_STATUS.getMessageDefinition(this.governanceServiceName, nestedError.getClass().getName(), nestedError.getMessage()), (Throwable)nestedError);
                }
            }
            if (this.auditLog != null) {
                this.auditLog.logException("start", GovernanceActionConnectorsAuditCode.UNABLE_TO_REGISTER_LISTENER.getMessageDefinition(this.governanceServiceName, error.getClass().getName(), error.getMessage()), (Throwable)error);
            }
            throw new GovernanceServiceException(GovernanceActionConnectorsErrorCode.UNABLE_TO_REGISTER_LISTENER.getMessageDefinition(this.governanceServiceName, error.getClass().getName(), error.getMessage()), error.getClass().getName(), "start", (Throwable)error);
        }
    }

    abstract void processEvent(WatchdogGovernanceEvent var1) throws GovernanceServiceException;

    protected String diffProperties(ElementProperties oldProperties, ElementProperties newProperties) {
        String propertyList;
        block12: {
            block11: {
                propertyList = null;
                if (oldProperties != null) break block11;
                if (newProperties == null) break block12;
                Iterator propertyIterator = newProperties.getPropertyNames();
                while (propertyIterator.hasNext()) {
                    if (propertyList == null) {
                        propertyList = (String)propertyIterator.next();
                        continue;
                    }
                    propertyList = propertyList + ", " + (String)propertyIterator.next();
                }
                break block12;
            }
            if (newProperties == null) {
                Iterator propertyIterator = oldProperties.getPropertyNames();
                while (propertyIterator.hasNext()) {
                    if (propertyList == null) {
                        propertyList = (String)propertyIterator.next();
                        continue;
                    }
                    propertyList = propertyList + ", " + (String)propertyIterator.next();
                }
            } else {
                ArrayList oldPropertyNames = new ArrayList();
                ArrayList<String> newPropertyNames = new ArrayList<String>();
                Iterator propertyIterator = oldProperties.getPropertyNames();
                while (propertyIterator.hasNext()) {
                    oldPropertyNames.add(propertyIterator.next());
                }
                propertyIterator = newProperties.getPropertyNames();
                while (propertyIterator.hasNext()) {
                    String newPropertyName = (String)propertyIterator.next();
                    newPropertyNames.add(newPropertyName);
                    if (!oldPropertyNames.contains(newPropertyName) || oldProperties.getPropertyValue(newPropertyName).equals((Object)newProperties.getPropertyValue(newPropertyName))) continue;
                    if (propertyList == null) {
                        propertyList = newPropertyName;
                        continue;
                    }
                    propertyList = propertyList + ", " + newPropertyName;
                }
                for (String oldPropertyName : oldPropertyNames) {
                    if (newPropertyNames.contains(oldPropertyName)) continue;
                    if (propertyList == null) {
                        propertyList = oldPropertyName;
                        continue;
                    }
                    propertyList = propertyList + ", " + oldPropertyName;
                }
            }
        }
        return propertyList;
    }

    protected void initiateProcess(String processName, Map<String, String> requestParameters, List<NewActionTarget> actionTargets) throws GovernanceServiceException {
        String methodName = "initiateProcess";
        if (processName != null) {
            String requestParametersString = "<null>";
            if (requestParameters != null) {
                requestParametersString = requestParameters.toString();
            }
            String actionTargetsString = "<null>";
            if (actionTargets != null) {
                actionTargetsString = actionTargets.toString();
            }
            try {
                if (this.auditLog != null) {
                    this.auditLog.logMessage("initiateProcess", GovernanceActionConnectorsAuditCode.INITIATE_PROCESS.getMessageDefinition(this.governanceServiceName, processName, requestParametersString, actionTargetsString));
                }
                this.governanceContext.initiateGovernanceActionProcess(processName, requestParameters, null, actionTargets, null);
            }
            catch (OCFCheckedExceptionBase nestedError) {
                block9: {
                    if (this.auditLog != null) {
                        this.auditLog.logException("initiateProcess", GovernanceActionConnectorsAuditCode.INITIATE_PROCESS_EXCEPTION.getMessageDefinition(this.governanceServiceName, ((Object)((Object)nestedError)).getClass().getName(), processName, requestParametersString, actionTargetsString, nestedError.getMessage()), (Throwable)nestedError);
                    }
                    try {
                        ArrayList<String> outputGuards = new ArrayList<String>();
                        outputGuards.add("monitoring-failed");
                        this.governanceContext.recordCompletionStatus(CompletionStatus.FAILED, outputGuards);
                    }
                    catch (Exception contextError) {
                        if (this.auditLog == null) break block9;
                        this.auditLog.logException("initiateProcess", GovernanceActionConnectorsAuditCode.INITIATE_PROCESS_EXCEPTION.getMessageDefinition(this.governanceServiceName, contextError.getClass().getName(), processName, requestParametersString, actionTargetsString, contextError.getMessage()), (Throwable)contextError);
                    }
                }
                throw new GovernanceServiceException(nestedError.getMessage(), nestedError);
            }
        }
    }

    private String getProperty(String propertyName, String defaultValue) {
        Map requestParameters = this.governanceContext.getRequestParameters();
        Map configurationProperties = this.connectionProperties.getConfigurationProperties();
        String propertyValue = defaultValue;
        if (requestParameters != null && requestParameters.get(propertyName) != null) {
            propertyValue = (String)requestParameters.get(propertyName);
        } else if (configurationProperties != null && configurationProperties.get(propertyName) != null) {
            propertyValue = configurationProperties.get(propertyName).toString();
        }
        return propertyValue;
    }

    public void disconnect() throws ConnectorCheckedException {
        super.disconnect();
    }
}

