/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.governanceactions.provisioning;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.odpi.openmetadata.adapters.connectors.governanceactions.ffdc.GovernanceActionConnectorsAuditCode;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.OpenMetadataStore;
import org.odpi.openmetadata.frameworks.governanceaction.ProvisioningGovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ElementStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;

public class MoveCopyFileGovernanceActionConnector
extends ProvisioningGovernanceActionService {
    private static volatile Map<String, Integer> fileIndexMap = new HashMap<String, Integer>();
    private PropertyHelper propertyHelper = new PropertyHelper();

    private static synchronized String getDestinationFileName(String previousDestinationFileName, String destinationFolderName, File sourceFile, String fileNamePattern) {
        int fileIndex = fileIndexMap.get(destinationFolderName) != null ? fileIndexMap.get(destinationFolderName) + 1 : 0;
        String nextDestinationFileName = fileNamePattern != null ? MessageFormat.format(fileNamePattern, sourceFile.getName(), fileIndex) : sourceFile.getName();
        if (previousDestinationFileName != null && previousDestinationFileName.equals(nextDestinationFileName)) {
            return null;
        }
        fileIndexMap.put(destinationFolderName, fileIndex);
        return FilenameUtils.concat((String)destinationFolderName, (String)nextDestinationFileName);
    }

    private static synchronized String provisionFile(String governanceServiceName, String destinationFolderName, String sourceFilePathName, String fileNamePattern, boolean copyFile, AuditLog auditLog) throws IOException {
        String methodName = "provisionFile";
        File sourceFile = new File(sourceFilePathName);
        File destinationFolder = new File(destinationFolderName);
        if (!destinationFolder.exists()) {
            FileUtils.forceMkdir((File)destinationFolder);
        }
        String destinationFileName = MoveCopyFileGovernanceActionConnector.getDestinationFileName(null, destinationFolderName, sourceFile, fileNamePattern);
        while (destinationFileName != null) {
            File destinationFile = new File(destinationFileName);
            if (!FileUtils.directoryContains((File)destinationFolder, (File)destinationFile)) {
                if (copyFile) {
                    if (auditLog != null) {
                        auditLog.logMessage("provisionFile", GovernanceActionConnectorsAuditCode.COPY_FILE.getMessageDefinition(governanceServiceName, sourceFilePathName, destinationFileName));
                    }
                    FileUtils.copyFile((File)sourceFile, (File)destinationFile, (boolean)true);
                } else {
                    if (auditLog != null) {
                        auditLog.logMessage("provisionFile", GovernanceActionConnectorsAuditCode.MOVE_FILE.getMessageDefinition(governanceServiceName, sourceFilePathName, destinationFileName));
                    }
                    FileUtils.moveFile((File)sourceFile, (File)destinationFile);
                }
                return destinationFileName;
            }
            destinationFileName = MoveCopyFileGovernanceActionConnector.getDestinationFileName(destinationFileName, destinationFolderName, sourceFile, fileNamePattern);
        }
        if (auditLog != null) {
            auditLog.logMessage("provisionFile", GovernanceActionConnectorsAuditCode.PROVISIONING_FAILURE.getMessageDefinition(governanceServiceName, sourceFilePathName, destinationFolderName, fileNamePattern));
        }
        return null;
    }

    public void start() throws ConnectorCheckedException {
        CompletionStatus completionStatus;
        String methodName = "start";
        super.start();
        ArrayList<String> outputGuards = new ArrayList<String>();
        String lineageProcessName = ((Object)((Object)this)).getClass().getName();
        String destinationFileNamePattern = "{0}";
        String sourceFileName = null;
        String sourceFileGUID = null;
        String destinationFolderName = null;
        boolean copyFile = true;
        boolean deleteFile = false;
        boolean createLineage = true;
        Map configurationProperties = this.connectionProperties.getConfigurationProperties();
        if (configurationProperties != null) {
            Object fileNamePatternOption;
            Object processNameOption;
            Object noLineageOption;
            Object provisionExternalFiles = configurationProperties.get("provisionUncataloguedFiles");
            if (provisionExternalFiles != null && this.governanceContext.getRequestParameters() != null) {
                sourceFileName = (String)this.governanceContext.getRequestParameters().get("source-file");
                destinationFolderName = (String)this.governanceContext.getRequestParameters().get("destination-folder");
            }
            if ((noLineageOption = configurationProperties.get("noLineage")) != null) {
                createLineage = false;
            }
            if ((processNameOption = configurationProperties.get("processName")) != null) {
                lineageProcessName = processNameOption.toString();
            }
            if ((fileNamePatternOption = configurationProperties.get("targetFileNamePattern")) != null) {
                destinationFileNamePattern = fileNamePatternOption.toString();
            }
        }
        if ("move-file".equals(this.governanceContext.getRequestType())) {
            copyFile = false;
        } else if ("delete-file".equals(this.governanceContext.getRequestType())) {
            deleteFile = true;
        }
        if (this.governanceContext.getActionTargetElements() != null) {
            for (ActionTargetElement actionTargetElement : this.governanceContext.getActionTargetElements()) {
                OpenMetadataElement destinationMetadataElement;
                if (actionTargetElement == null) continue;
                if ("source-file".equals(actionTargetElement.getActionTargetName())) {
                    OpenMetadataElement sourceMetadataElement = actionTargetElement.getTargetElement();
                    if (sourceMetadataElement == null) continue;
                    sourceFileName = this.getPathName(sourceMetadataElement);
                    sourceFileGUID = sourceMetadataElement.getElementGUID();
                    continue;
                }
                if (!"destination-folder".equals(actionTargetElement.getActionTargetName()) || (destinationMetadataElement = actionTargetElement.getTargetElement()) == null) continue;
                destinationFolderName = this.getPathName(destinationMetadataElement);
            }
        }
        try {
            if (deleteFile) {
                if (sourceFileName != null) {
                    File fileToDelete = new File(sourceFileName);
                    FileUtils.forceDelete((File)fileToDelete);
                }
                outputGuards.add("provisioning-complete");
                completionStatus = CompletionStatus.ACTIONED;
            } else {
                String destinationFileName = MoveCopyFileGovernanceActionConnector.provisionFile(this.governanceServiceName, destinationFolderName, sourceFileName, destinationFileNamePattern, copyFile, this.auditLog);
                if (destinationFileName != null) {
                    if (createLineage) {
                        this.createLineage(sourceFileGUID, destinationFileName, lineageProcessName);
                    }
                    outputGuards.add("provisioning-complete");
                    completionStatus = CompletionStatus.ACTIONED;
                } else {
                    outputGuards.add("provisioning-failed");
                    completionStatus = CompletionStatus.FAILED;
                }
            }
        }
        catch (Exception error) {
            if (this.auditLog != null) {
                this.auditLog.logException("start", GovernanceActionConnectorsAuditCode.PROVISIONING_EXCEPTION.getMessageDefinition(this.governanceServiceName, error.getClass().getName(), sourceFileName, destinationFolderName, destinationFileNamePattern, error.getMessage()), (Throwable)error);
            }
            outputGuards.add("provisioning-failed");
            completionStatus = CompletionStatus.FAILED;
        }
        try {
            this.governanceContext.recordCompletionStatus(completionStatus, outputGuards, null);
        }
        catch (OCFCheckedExceptionBase error) {
            throw new ConnectorCheckedException(error.getReportedErrorMessage(), error);
        }
    }

    private String getPathName(OpenMetadataElement asset) {
        block13: {
            String methodName = "getPathName";
            String connectionRelationshipName = "ConnectionToAsset";
            String qualifiedNameParameterName = "qualifiedName";
            OpenMetadataStore store = this.governanceContext.getOpenMetadataStore();
            try {
                String pathName;
                List connectionLinks = store.getRelatedMetadataElements(asset.getElementGUID(), "ConnectionToAsset", 0, 0);
                if (connectionLinks == null || connectionLinks.isEmpty()) {
                    if (this.auditLog != null) {
                        this.auditLog.logMessage("getPathName", GovernanceActionConnectorsAuditCode.NO_LINKED_CONNECTION.getMessageDefinition(this.governanceServiceName, asset.getElementGUID()));
                    }
                } else if (connectionLinks.size() > 1) {
                    pathName = null;
                    for (RelatedMetadataElement connectionLink : connectionLinks) {
                        String networkAddress;
                        if (connectionLink == null || (networkAddress = this.getPathNameFromConnection(asset.getElementGUID(), connectionLink)) == null) continue;
                        if (pathName == null) {
                            pathName = networkAddress;
                            continue;
                        }
                        if (networkAddress.equals(pathName)) continue;
                        if (this.auditLog != null) {
                            this.auditLog.logMessage("getPathName", GovernanceActionConnectorsAuditCode.TOO_MANY_CONNECTIONS.getMessageDefinition(this.governanceServiceName, Integer.toString(connectionLinks.size()), asset.getElementGUID(), connectionLinks.toString()));
                        }
                        pathName = null;
                        break;
                    }
                    if (pathName != null) {
                        return pathName;
                    }
                } else {
                    pathName = this.getPathNameFromConnection(asset.getElementGUID(), (RelatedMetadataElement)connectionLinks.get(0));
                    if (pathName != null) {
                        return pathName;
                    }
                }
            }
            catch (Exception error) {
                if (this.auditLog == null) break block13;
                this.auditLog.logException("getPathName", GovernanceActionConnectorsAuditCode.ENDPOINT_EXCEPTION.getMessageDefinition(this.governanceServiceName, error.getClass().getName(), error.getMessage()), (Throwable)error);
            }
        }
        ElementProperties properties = asset.getElementProperties();
        String qualifiedName = this.propertyHelper.getStringProperty(this.governanceServiceName, "qualifiedName", properties, "getPathName");
        if (this.auditLog != null) {
            this.auditLog.logMessage("getPathName", GovernanceActionConnectorsAuditCode.QUALIFIED_NAME_PATH_NAME.getMessageDefinition(this.governanceServiceName, qualifiedName));
        }
        return qualifiedName;
    }

    private String getPathNameFromConnection(String assetGUID, RelatedMetadataElement connectionLink) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String endpointRelationshipName = "ConnectionEndpoint";
        String endpointNetworkAddressName = "networkAddress";
        String methodName = "getPathNameFromConnection";
        OpenMetadataStore store = this.governanceContext.getOpenMetadataStore();
        OpenMetadataElement connection = connectionLink.getElementProperties();
        if (connection == null) {
            if (this.auditLog != null) {
                this.auditLog.logMessage("getPathNameFromConnection", GovernanceActionConnectorsAuditCode.NO_RELATED_ASSET.getMessageDefinition(this.governanceServiceName, connectionLink.toString()));
            }
        } else {
            List endpointLinks = store.getRelatedMetadataElements(connection.getElementGUID(), "ConnectionEndpoint", 0, 0);
            if (endpointLinks == null || endpointLinks.isEmpty()) {
                if (this.auditLog != null) {
                    this.auditLog.logMessage("getPathNameFromConnection", GovernanceActionConnectorsAuditCode.NO_LINKED_ENDPOINT.getMessageDefinition(this.governanceServiceName, assetGUID, connection.getElementGUID()));
                }
            } else if (endpointLinks.size() > 1) {
                if (this.auditLog != null) {
                    this.auditLog.logMessage("getPathNameFromConnection", GovernanceActionConnectorsAuditCode.TOO_MANY_ENDPOINTS.getMessageDefinition(this.governanceServiceName, assetGUID, connection.getElementGUID(), Integer.toString(endpointLinks.size()), endpointLinks.toString()));
                }
            } else {
                OpenMetadataElement endpoint = ((RelatedMetadataElement)endpointLinks.get(0)).getElementProperties();
                if (endpoint == null) {
                    if (this.auditLog != null) {
                        this.auditLog.logMessage("getPathNameFromConnection", GovernanceActionConnectorsAuditCode.NO_RELATED_ASSET.getMessageDefinition(this.governanceServiceName, ((RelatedMetadataElement)endpointLinks.get(0)).toString()));
                    }
                } else {
                    ElementProperties properties = endpoint.getElementProperties();
                    String address = this.propertyHelper.getStringProperty(this.governanceServiceName, "networkAddress", properties, "getPathNameFromConnection");
                    if (address == null && this.auditLog != null) {
                        this.auditLog.logMessage("getPathNameFromConnection", GovernanceActionConnectorsAuditCode.NO_NETWORK_ADDRESS.getMessageDefinition(this.governanceServiceName, endpoint.getElementGUID(), connection.getElementGUID(), assetGUID));
                    }
                    return address;
                }
            }
        }
        return null;
    }

    private void createLineage(String sourceFileGUID, String destinationFilePathName, String lineageProcessName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String processTypeName = "TransientEmbeddedProcess";
        String fileName = FilenameUtils.getName((String)destinationFilePathName);
        String fileExtension = FilenameUtils.getExtension((String)destinationFilePathName);
        String assetTypeName = "DataFile";
        switch (fileExtension) {
            case "csv": {
                assetTypeName = "CSVFile";
                break;
            }
            case "json": {
                assetTypeName = "JSONFile";
                break;
            }
            case "avro": {
                assetTypeName = "AvroFileName";
                break;
            }
            case "pdf": 
            case "doc": 
            case "docx": 
            case "ppt": 
            case "pptx": 
            case "xls": 
            case "xlsx": 
            case "md": {
                assetTypeName = "Document";
                break;
            }
            case "jpg": 
            case "jpeg": 
            case "png": 
            case "gif": 
            case "mp3": 
            case "mp4": {
                assetTypeName = "MediaFile";
            }
        }
        String newFileGUID = this.governanceContext.createAsset(assetTypeName, destinationFilePathName, fileName, null, null);
        String processGUID = this.governanceContext.createProcess("TransientEmbeddedProcess", ElementStatus.ACTIVE, lineageProcessName + ":" + UUID.randomUUID().toString(), lineageProcessName, null, null);
        this.governanceContext.createLineageMapping(sourceFileGUID, processGUID);
        this.governanceContext.createLineageMapping(processGUID, newFileGUID);
    }
}

