/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.governanceactions.watchdog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.governanceactions.ffdc.GovernanceActionConnectorsAuditCode;
import org.odpi.openmetadata.adapters.connectors.governanceactions.ffdc.GovernanceActionConnectorsErrorCode;
import org.odpi.openmetadata.adapters.connectors.governanceactions.watchdog.GenericElementWatchdogListener;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.governanceaction.WatchdogGovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.WatchdogGovernanceListener;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogClassificationEvent;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogEventType;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogGovernanceEvent;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogMetadataElementEvent;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogRelatedElementsEvent;
import org.odpi.openmetadata.frameworks.governanceaction.ffdc.GovernanceServiceException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElements;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;

public class GenericElementWatchdogGovernanceActionConnector
extends WatchdogGovernanceActionService {
    private List<String> instancesToListenTo = new ArrayList<String>();
    private String newElementProcessName = null;
    private String updatedElementProcessName = null;
    private String deletedElementProcessName = null;
    private String classifiedElementProcessName = null;
    private String reclassifiedElementProcessName = null;
    private String declassifiedElementProcessName = null;
    private String newRelationshipProcessName = null;
    private String updatedRelationshipProcessName = null;
    private String deletedRelationshipProcessName = null;
    private volatile boolean completed = false;

    public void start() throws ConnectorCheckedException {
        List actionTargetElements;
        super.start();
        String defaultTypeName = "OpenMetadataRoot";
        String methodName = "start";
        GenericElementWatchdogListener listener = new GenericElementWatchdogListener(this);
        String interestingTypeName = this.getProperty("interestingTypeName", "OpenMetadataRoot");
        String instanceToListenTo = this.getProperty("instanceToMonitor", null);
        if (instanceToListenTo != null) {
            this.instancesToListenTo.add(instanceToListenTo);
        }
        if ((actionTargetElements = this.governanceContext.getActionTargetElements()) != null) {
            for (ActionTargetElement actionTargetElement : actionTargetElements) {
                if (actionTargetElement == null || !"instanceToMonitor".equals(actionTargetElement.getActionTargetName())) continue;
                this.instancesToListenTo.add(actionTargetElement.getActionTargetGUID());
            }
        }
        this.newElementProcessName = this.getProperty("newElementProcessName", null);
        this.updatedElementProcessName = this.getProperty("updatedElementProcessName", null);
        this.deletedElementProcessName = this.getProperty("deletedElementProcessName", null);
        this.classifiedElementProcessName = this.getProperty("classifiedElementProcessName", null);
        this.reclassifiedElementProcessName = this.getProperty("reclassifiedElementProcessName", null);
        this.declassifiedElementProcessName = this.getProperty("declassifiedElementProcessName", null);
        this.newRelationshipProcessName = this.getProperty("newRelationshipProcessName", null);
        this.updatedRelationshipProcessName = this.getProperty("updatedRelationshipProcessName", null);
        this.deletedRelationshipProcessName = this.getProperty("deletedRelationshipProcessName", null);
        try {
            ArrayList<WatchdogEventType> interestingEventTypes = new ArrayList<WatchdogEventType>();
            if (this.newElementProcessName != null) {
                interestingEventTypes.add(WatchdogEventType.NEW_ELEMENT);
                interestingEventTypes.add(WatchdogEventType.REFRESHED_ELEMENT);
            }
            if (this.updatedElementProcessName != null) {
                interestingEventTypes.add(WatchdogEventType.UPDATED_ELEMENT_PROPERTIES);
            }
            if (this.deletedElementProcessName != null) {
                interestingEventTypes.add(WatchdogEventType.DELETED_ELEMENT);
            }
            if (this.classifiedElementProcessName != null) {
                interestingEventTypes.add(WatchdogEventType.NEW_CLASSIFICATION);
            }
            if (this.reclassifiedElementProcessName != null) {
                interestingEventTypes.add(WatchdogEventType.UPDATED_CLASSIFICATION_PROPERTIES);
            }
            if (this.declassifiedElementProcessName != null) {
                interestingEventTypes.add(WatchdogEventType.DELETED_CLASSIFICATION);
            }
            if (this.newRelationshipProcessName != null) {
                interestingEventTypes.add(WatchdogEventType.NEW_RELATIONSHIP);
            }
            if (this.updatedRelationshipProcessName != null) {
                interestingEventTypes.add(WatchdogEventType.UPDATED_RELATIONSHIP_PROPERTIES);
            }
            if (this.deletedRelationshipProcessName != null) {
                interestingEventTypes.add(WatchdogEventType.DELETED_RELATIONSHIP);
            }
            ArrayList<String> interestingMetadataTypes = new ArrayList<String>();
            interestingMetadataTypes.add(interestingTypeName);
            if (this.instancesToListenTo.isEmpty()) {
                this.instancesToListenTo = null;
                this.governanceContext.registerListener((WatchdogGovernanceListener)listener, interestingEventTypes, interestingMetadataTypes, null);
            } else if (this.instancesToListenTo.size() == 1) {
                this.governanceContext.registerListener((WatchdogGovernanceListener)listener, interestingEventTypes, interestingMetadataTypes, this.instancesToListenTo.get(0));
                this.instancesToListenTo = null;
            } else {
                this.governanceContext.registerListener((WatchdogGovernanceListener)listener, interestingEventTypes, interestingMetadataTypes, null);
            }
        }
        catch (Exception error) {
            block21: {
                try {
                    ArrayList<String> outputGuards = new ArrayList<String>();
                    outputGuards.add("monitoring-failed");
                    this.governanceContext.recordCompletionStatus(CompletionStatus.FAILED, outputGuards, null);
                }
                catch (Exception nestedError) {
                    if (this.auditLog == null) break block21;
                    this.auditLog.logException("start", GovernanceActionConnectorsAuditCode.UNABLE_TO_SET_COMPLETION_STATUS.getMessageDefinition(this.governanceServiceName, nestedError.getClass().getName(), nestedError.getMessage()), (Throwable)nestedError);
                }
            }
            if (this.auditLog != null) {
                this.auditLog.logException("start", GovernanceActionConnectorsAuditCode.UNABLE_TO_REGISTER_LISTENER.getMessageDefinition(this.governanceServiceName, error.getClass().getName(), error.getMessage()), (Throwable)error);
            }
            throw new GovernanceServiceException(GovernanceActionConnectorsErrorCode.UNABLE_TO_REGISTER_LISTENER.getMessageDefinition(this.governanceServiceName, error.getClass().getName(), error.getMessage()), error.getClass().getName(), "start", (Throwable)error);
        }
    }

    void processEvent(WatchdogGovernanceEvent event) throws GovernanceServiceException {
        block30: {
            String methodName = "processEvent";
            if (!this.completed) {
                WatchdogRelatedElementsEvent relatedElementsEvent;
                RelatedMetadataElements relatedMetadataElements;
                if (event instanceof WatchdogMetadataElementEvent) {
                    WatchdogMetadataElementEvent metadataElementEvent = (WatchdogMetadataElementEvent)event;
                    String elementGUID = metadataElementEvent.getMetadataElement().getElementGUID();
                    HashMap<String, String> requestParameters = new HashMap<String, String>();
                    ArrayList<String> actionTargetGUIDs = new ArrayList<String>();
                    actionTargetGUIDs.add(elementGUID);
                    if (this.instancesToListenTo == null || this.instancesToListenTo.contains(elementGUID)) {
                        if (metadataElementEvent.getEventType() != WatchdogEventType.NEW_ELEMENT) {
                            this.initiateProcess(this.newElementProcessName, null, actionTargetGUIDs);
                        } else if (metadataElementEvent.getEventType() != WatchdogEventType.UPDATED_ELEMENT_PROPERTIES) {
                            ElementProperties previousElementProperties = null;
                            if (metadataElementEvent.getPreviousMetadataElement() != null) {
                                previousElementProperties = metadataElementEvent.getPreviousMetadataElement().getElementProperties();
                            }
                            requestParameters.put("ChangedProperties", this.diffProperties(previousElementProperties, metadataElementEvent.getMetadataElement().getElementProperties()));
                            this.initiateProcess(this.updatedElementProcessName, requestParameters, actionTargetGUIDs);
                        } else if (metadataElementEvent.getEventType() != WatchdogEventType.DELETED_ELEMENT) {
                            this.initiateProcess(this.deletedElementProcessName, null, actionTargetGUIDs);
                        } else {
                            WatchdogClassificationEvent classificationEvent = (WatchdogClassificationEvent)event;
                            requestParameters.put("ClassificationName", classificationEvent.getChangedClassification().getClassificationName());
                            if (metadataElementEvent.getEventType() != WatchdogEventType.NEW_CLASSIFICATION) {
                                this.initiateProcess(this.classifiedElementProcessName, requestParameters, actionTargetGUIDs);
                            } else if (metadataElementEvent.getEventType() != WatchdogEventType.UPDATED_CLASSIFICATION_PROPERTIES) {
                                ElementProperties previousElementProperties = null;
                                if (classificationEvent.getPreviousClassification() != null) {
                                    previousElementProperties = classificationEvent.getPreviousClassification().getClassificationProperties();
                                }
                                requestParameters.put("ChangedProperties", this.diffProperties(previousElementProperties, classificationEvent.getChangedClassification().getClassificationProperties()));
                                this.initiateProcess(this.reclassifiedElementProcessName, requestParameters, actionTargetGUIDs);
                            } else if (metadataElementEvent.getEventType() != WatchdogEventType.DELETED_CLASSIFICATION) {
                                this.initiateProcess(this.declassifiedElementProcessName, requestParameters, actionTargetGUIDs);
                            }
                        }
                        if ("process-single-event".equals(this.governanceContext.getRequestType())) {
                            this.completed = true;
                        }
                    }
                } else if (event instanceof WatchdogRelatedElementsEvent && (relatedMetadataElements = (relatedElementsEvent = (WatchdogRelatedElementsEvent)event).getRelatedMetadataElements()) != null) {
                    String end1GUID = relatedMetadataElements.getElementGUIDAtEnd1();
                    String end2GUID = relatedMetadataElements.getElementGUIDAtEnd2();
                    if (this.instancesToListenTo == null || this.instancesToListenTo.contains(end1GUID) || this.instancesToListenTo.contains(end2GUID)) {
                        HashMap<String, String> requestParameters = new HashMap<String, String>();
                        requestParameters.put("RelationshipGUID", relatedMetadataElements.getRelationshipGUID());
                        requestParameters.put("RelationshipTypeName", relatedMetadataElements.getRelationshipType().getElementTypeName());
                        ArrayList<String> actionTargetGUIDs = new ArrayList<String>();
                        actionTargetGUIDs.add(end1GUID);
                        actionTargetGUIDs.add(end2GUID);
                        if (relatedElementsEvent.getEventType() == WatchdogEventType.NEW_RELATIONSHIP) {
                            this.initiateProcess(this.newRelationshipProcessName, requestParameters, actionTargetGUIDs);
                        } else if (relatedElementsEvent.getEventType() == WatchdogEventType.UPDATED_RELATIONSHIP_PROPERTIES) {
                            ElementProperties previousElementProperties = null;
                            if (relatedElementsEvent.getPreviousRelatedMetadataElements() != null) {
                                previousElementProperties = relatedElementsEvent.getPreviousRelatedMetadataElements().getRelationshipProperties();
                            }
                            requestParameters.put("ChangedProperties", this.diffProperties(previousElementProperties, relatedMetadataElements.getRelationshipProperties()));
                            this.initiateProcess(this.updatedRelationshipProcessName, requestParameters, actionTargetGUIDs);
                        } else if (relatedElementsEvent.getEventType() == WatchdogEventType.DELETED_RELATIONSHIP) {
                            this.initiateProcess(this.deletedRelationshipProcessName, requestParameters, actionTargetGUIDs);
                        }
                        if ("process-single-event".equals(this.governanceContext.getRequestType())) {
                            this.completed = true;
                        }
                    }
                }
                if (this.completed) {
                    try {
                        ArrayList<String> outputGuards = new ArrayList<String>();
                        outputGuards.add("monitoring-failed");
                        this.governanceContext.recordCompletionStatus(CompletionStatus.FAILED, outputGuards, null);
                    }
                    catch (Exception error) {
                        if (this.auditLog == null) break block30;
                        this.auditLog.logException("processEvent", GovernanceActionConnectorsAuditCode.UNABLE_TO_SET_COMPLETION_STATUS.getMessageDefinition(this.governanceServiceName, error.getClass().getName(), error.getMessage()), (Throwable)error);
                    }
                }
            }
        }
    }

    private String diffProperties(ElementProperties oldProperties, ElementProperties newProperties) {
        String propertyList;
        block12: {
            block11: {
                propertyList = null;
                if (oldProperties != null) break block11;
                if (newProperties == null) break block12;
                Iterator propertyIterator = newProperties.getPropertyNames();
                while (propertyIterator.hasNext()) {
                    if (propertyList == null) {
                        propertyList = (String)propertyIterator.next();
                        continue;
                    }
                    propertyList = propertyList + ", " + (String)propertyIterator.next();
                }
                break block12;
            }
            if (newProperties == null) {
                Iterator propertyIterator = oldProperties.getPropertyNames();
                while (propertyIterator.hasNext()) {
                    if (propertyList == null) {
                        propertyList = (String)propertyIterator.next();
                        continue;
                    }
                    propertyList = propertyList + ", " + (String)propertyIterator.next();
                }
            } else {
                ArrayList oldPropertyNames = new ArrayList();
                ArrayList<String> newPropertyNames = new ArrayList<String>();
                Iterator propertyIterator = oldProperties.getPropertyNames();
                while (propertyIterator.hasNext()) {
                    oldPropertyNames.add(propertyIterator.next());
                }
                propertyIterator = newProperties.getPropertyNames();
                while (propertyIterator.hasNext()) {
                    String newPropertyName = (String)propertyIterator.next();
                    newPropertyNames.add(newPropertyName);
                    if (!oldPropertyNames.contains(newPropertyName) || oldProperties.getPropertyValue(newPropertyName).equals((Object)newProperties.getPropertyValue(newPropertyName))) continue;
                    if (propertyList == null) {
                        propertyList = newPropertyName;
                        continue;
                    }
                    propertyList = propertyList + ", " + newPropertyName;
                }
                for (String oldPropertyName : oldPropertyNames) {
                    if (newPropertyNames.contains(oldPropertyName)) continue;
                    if (propertyList == null) {
                        propertyList = oldPropertyName;
                        continue;
                    }
                    propertyList = propertyList + ", " + oldPropertyName;
                }
            }
        }
        return propertyList;
    }

    private String getProperty(String propertyName, String defaultValue) {
        Map requestParameters = this.governanceContext.getRequestParameters();
        Map configurationProperties = this.connectionProperties.getConfigurationProperties();
        String propertyValue = defaultValue;
        if (requestParameters != null && requestParameters.get(propertyName) != null) {
            propertyValue = (String)requestParameters.get(propertyName);
        } else if (configurationProperties != null && configurationProperties.get(propertyName) != null) {
            propertyValue = configurationProperties.get(propertyName).toString();
        }
        return propertyValue;
    }

    private void initiateProcess(String processName, Map<String, String> requestParameters, List<String> actionTargetGUIDs) throws GovernanceServiceException {
        if (processName != null) {
            try {
                this.governanceContext.initiateGovernanceActionProcess(processName, requestParameters, null, actionTargetGUIDs, null);
            }
            catch (OCFCheckedExceptionBase nestedError) {
                if (this.auditLog != null) {
                    // empty if block
                }
                try {
                    ArrayList<String> outputGuards = new ArrayList<String>();
                    outputGuards.add("monitoring-failed");
                    this.governanceContext.recordCompletionStatus(CompletionStatus.FAILED, outputGuards, null);
                }
                catch (Exception contextError) {
                    if (this.auditLog != null) {
                        // empty if block
                    }
                }
                throw new GovernanceServiceException(nestedError.getMessage(), nestedError);
            }
        }
    }

    public void disconnect() throws ConnectorCheckedException {
        super.disconnect();
    }
}

