/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.governanceactions.provisioning;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.odpi.openmetadata.adapters.connectors.governanceactions.ffdc.GovernanceActionConnectorsAuditCode;
import org.odpi.openmetadata.adapters.connectors.governanceactions.ffdc.GovernanceActionConnectorsErrorCode;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.governanceaction.OpenMetadataStore;
import org.odpi.openmetadata.frameworks.governanceaction.ProvisioningGovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ElementStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.NewActionTarget;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;

public class MoveCopyFileGovernanceActionConnector
extends ProvisioningGovernanceActionService {
    private static volatile Map<String, Integer> fileIndexMap = new HashMap<String, Integer>();
    private PropertyHelper propertyHelper = new PropertyHelper();
    private String topLevelProcessName = ((Object)((Object)this)).getClass().getName();
    private String destinationFileTemplateQualifiedName = null;
    private String topLevelProcessTemplateQualifiedName = null;
    private String destinationFileNamePattern = "{0}";
    private String sourceFileName = null;
    private String sourceFileGUID = null;
    private String destinationFolderName = null;
    private boolean copyFile = true;
    private boolean deleteFile = false;
    private boolean createLineage = true;
    private boolean sourceLineageFromFile = true;
    private boolean destinationLineageToFile = true;
    private boolean childProcessLineage = true;

    private static synchronized String getDestinationFileName(String previousDestinationFileName, String destinationFolderName, File sourceFile, String fileNamePattern) {
        int fileIndex = fileIndexMap.get(destinationFolderName) != null ? fileIndexMap.get(destinationFolderName) + 1 : 0;
        String nextDestinationFileName = fileNamePattern != null ? MessageFormat.format(fileNamePattern, sourceFile.getName(), fileIndex) : sourceFile.getName();
        if (previousDestinationFileName != null && previousDestinationFileName.equals(nextDestinationFileName)) {
            return null;
        }
        fileIndexMap.put(destinationFolderName, fileIndex);
        return FilenameUtils.concat((String)destinationFolderName, (String)nextDestinationFileName);
    }

    private static synchronized String provisionFile(String governanceServiceName, String destinationFolderName, String sourceFilePathName, String fileNamePattern, boolean copyFile, AuditLog auditLog) throws IOException {
        String methodName = "provisionFile";
        File sourceFile = new File(sourceFilePathName);
        File destinationFolder = new File(destinationFolderName);
        if (!destinationFolder.exists()) {
            FileUtils.forceMkdir((File)destinationFolder);
        }
        String destinationFileName = MoveCopyFileGovernanceActionConnector.getDestinationFileName(null, destinationFolderName, sourceFile, fileNamePattern);
        while (destinationFileName != null) {
            File destinationFile = new File(destinationFileName);
            if (!FileUtils.directoryContains((File)destinationFolder, (File)destinationFile)) {
                if (copyFile) {
                    if (auditLog != null) {
                        auditLog.logMessage("provisionFile", GovernanceActionConnectorsAuditCode.COPY_FILE.getMessageDefinition(governanceServiceName, sourceFilePathName, destinationFileName));
                    }
                    FileUtils.copyFile((File)sourceFile, (File)destinationFile, (boolean)true);
                } else {
                    if (auditLog != null) {
                        auditLog.logMessage("provisionFile", GovernanceActionConnectorsAuditCode.MOVE_FILE.getMessageDefinition(governanceServiceName, sourceFilePathName, destinationFileName));
                    }
                    FileUtils.moveFile((File)sourceFile, (File)destinationFile);
                }
                return destinationFileName;
            }
            destinationFileName = MoveCopyFileGovernanceActionConnector.getDestinationFileName(destinationFileName, destinationFolderName, sourceFile, fileNamePattern);
        }
        if (auditLog != null) {
            auditLog.logMessage("provisionFile", GovernanceActionConnectorsAuditCode.PROVISIONING_FAILURE.getMessageDefinition(governanceServiceName, sourceFilePathName, destinationFolderName, fileNamePattern));
        }
        return null;
    }

    public void initialize(String connectorInstanceId, ConnectionProperties connectionProperties) {
        super.initialize(connectorInstanceId, connectionProperties);
        Map configurationProperties = connectionProperties.getConfigurationProperties();
        if (configurationProperties != null) {
            Object processLineageOption;
            Object destinationLineageOption;
            Object sourceLineageOption;
            Object destinationFolderOption;
            Object fileNamePatternOption;
            Object templateNameOption;
            Object processNameOption;
            Object noLineageOption = configurationProperties.get("noLineage");
            if (noLineageOption != null) {
                this.createLineage = false;
            }
            if ((processNameOption = configurationProperties.get("topLevelProcessQualifiedName")) != null) {
                this.topLevelProcessName = processNameOption.toString();
            }
            if ((templateNameOption = configurationProperties.get("destinationFileTemplateQualifiedName")) != null) {
                this.destinationFileTemplateQualifiedName = templateNameOption.toString();
            }
            if ((templateNameOption = configurationProperties.get("topLevelProcessTemplateQualifiedName")) != null) {
                this.topLevelProcessTemplateQualifiedName = templateNameOption.toString();
            }
            if ((fileNamePatternOption = configurationProperties.get("targetFileNamePattern")) != null) {
                this.destinationFileNamePattern = fileNamePatternOption.toString();
            }
            if ((destinationFolderOption = configurationProperties.get("destinationFolder")) != null) {
                this.destinationFolderName = destinationFolderOption.toString();
            }
            if ((sourceLineageOption = configurationProperties.get("lineageFromSourceFolderOnly")) != null) {
                this.sourceLineageFromFile = false;
            }
            if ((destinationLineageOption = configurationProperties.get("lineageToDestinationFolderOnly")) != null) {
                this.destinationLineageToFile = false;
            }
            if ((processLineageOption = configurationProperties.get("topLevelProcessLineageOnly")) != null) {
                this.childProcessLineage = false;
            }
        }
    }

    public void start() throws ConnectorCheckedException {
        CompletionStatus completionStatus;
        String methodName = "start";
        super.start();
        ArrayList<String> outputGuards = new ArrayList<String>();
        if ("move-file".equals(this.governanceContext.getRequestType())) {
            this.copyFile = false;
        } else if ("delete-file".equals(this.governanceContext.getRequestType())) {
            this.deleteFile = true;
        }
        if (this.governanceContext.getRequestParameters() != null) {
            Map requestParameters = this.governanceContext.getRequestParameters();
            for (String requestParameterName : requestParameters.keySet()) {
                if (requestParameterName == null) continue;
                if ("sourceFile".equals(requestParameterName)) {
                    this.sourceFileName = (String)requestParameters.get(requestParameterName);
                    continue;
                }
                if (!"destinationFolder".equals(requestParameterName)) continue;
                this.destinationFolderName = (String)requestParameters.get(requestParameterName);
            }
        }
        if (this.governanceContext.getActionTargetElements() != null) {
            for (ActionTargetElement actionTargetElement : this.governanceContext.getActionTargetElements()) {
                OpenMetadataElement destinationMetadataElement;
                if (actionTargetElement == null) continue;
                if ("sourceFile".equals(actionTargetElement.getActionTargetName())) {
                    OpenMetadataElement sourceMetadataElement = actionTargetElement.getTargetElement();
                    if (sourceMetadataElement == null) continue;
                    this.sourceFileName = this.getPathName(sourceMetadataElement);
                    this.sourceFileGUID = sourceMetadataElement.getElementGUID();
                    continue;
                }
                if (!"destinationFolder".equals(actionTargetElement.getActionTargetName()) || (destinationMetadataElement = actionTargetElement.getTargetElement()) == null) continue;
                this.destinationFolderName = this.getPathName(destinationMetadataElement);
            }
        }
        if (this.sourceFileName == null) {
            if (this.auditLog != null) {
                this.auditLog.logMessage("start", GovernanceActionConnectorsAuditCode.NO_SOURCE_FILE_NAME.getMessageDefinition(this.governanceServiceName));
            }
            throw new ConnectorCheckedException(GovernanceActionConnectorsErrorCode.NO_SOURCE_FILE_NAME.getMessageDefinition(this.governanceServiceName), ((Object)((Object)this)).getClass().getName(), "start");
        }
        ArrayList<NewActionTarget> newActionTargets = null;
        try {
            if (this.deleteFile) {
                File fileToDelete = new File(this.sourceFileName);
                FileUtils.forceDelete((File)fileToDelete);
                outputGuards.add("provisioning-complete");
                completionStatus = CompletionStatus.ACTIONED;
            } else {
                String destinationFileName = MoveCopyFileGovernanceActionConnector.provisionFile(this.governanceServiceName, this.destinationFolderName, this.sourceFileName, this.destinationFileNamePattern, this.copyFile, this.auditLog);
                if (destinationFileName != null) {
                    String newActionTargetGUID = null;
                    if (this.createLineage) {
                        newActionTargetGUID = this.createLineage(destinationFileName);
                    }
                    if (newActionTargetGUID != null) {
                        newActionTargets = new ArrayList<NewActionTarget>();
                        NewActionTarget actionTarget = new NewActionTarget();
                        actionTarget.setActionTargetGUID(newActionTargetGUID);
                        actionTarget.setActionTargetName(destinationFileName);
                        newActionTargets.add(actionTarget);
                    }
                    outputGuards.add("provisioning-complete");
                    completionStatus = CompletionStatus.ACTIONED;
                } else {
                    outputGuards.add("provisioning-failed");
                    completionStatus = CompletionStatus.FAILED;
                }
            }
        }
        catch (Exception error) {
            if (this.auditLog != null) {
                this.auditLog.logException("start", GovernanceActionConnectorsAuditCode.PROVISIONING_EXCEPTION.getMessageDefinition(this.governanceServiceName, error.getClass().getName(), this.sourceFileName, this.destinationFolderName, this.destinationFileNamePattern, error.getMessage()), (Throwable)error);
            }
            outputGuards.add("provisioning-failed");
            completionStatus = CompletionStatus.FAILED;
        }
        try {
            this.governanceContext.recordCompletionStatus(completionStatus, outputGuards, null, newActionTargets);
        }
        catch (OCFCheckedExceptionBase error) {
            throw new ConnectorCheckedException(error.getReportedErrorMessage(), error);
        }
    }

    private String getPathName(OpenMetadataElement asset) {
        block13: {
            String methodName = "getPathName";
            String connectionRelationshipName = "ConnectionToAsset";
            String qualifiedNameParameterName = "qualifiedName";
            OpenMetadataStore store = this.governanceContext.getOpenMetadataStore();
            try {
                String pathName;
                List connectionLinks = store.getRelatedMetadataElements(asset.getElementGUID(), 2, "ConnectionToAsset", 0, 0);
                if (connectionLinks == null || connectionLinks.isEmpty()) {
                    if (this.auditLog != null) {
                        this.auditLog.logMessage("getPathName", GovernanceActionConnectorsAuditCode.NO_LINKED_CONNECTION.getMessageDefinition(this.governanceServiceName, asset.getElementGUID()));
                    }
                } else if (connectionLinks.size() > 1) {
                    pathName = null;
                    for (RelatedMetadataElement connectionLink : connectionLinks) {
                        String networkAddress;
                        if (connectionLink == null || (networkAddress = this.getPathNameFromConnection(asset.getElementGUID(), connectionLink)) == null) continue;
                        if (pathName == null) {
                            pathName = networkAddress;
                            continue;
                        }
                        if (networkAddress.equals(pathName)) continue;
                        if (this.auditLog != null) {
                            this.auditLog.logMessage("getPathName", GovernanceActionConnectorsAuditCode.TOO_MANY_CONNECTIONS.getMessageDefinition(this.governanceServiceName, Integer.toString(connectionLinks.size()), asset.getElementGUID(), connectionLinks.toString()));
                        }
                        pathName = null;
                        break;
                    }
                    if (pathName != null) {
                        return pathName;
                    }
                } else {
                    pathName = this.getPathNameFromConnection(asset.getElementGUID(), (RelatedMetadataElement)connectionLinks.get(0));
                    if (pathName != null) {
                        return pathName;
                    }
                }
            }
            catch (Exception error) {
                if (this.auditLog == null) break block13;
                this.auditLog.logException("getPathName", GovernanceActionConnectorsAuditCode.ENDPOINT_EXCEPTION.getMessageDefinition(this.governanceServiceName, error.getClass().getName(), error.getMessage()), (Throwable)error);
            }
        }
        ElementProperties properties = asset.getElementProperties();
        String qualifiedName = this.propertyHelper.getStringProperty(this.governanceServiceName, "qualifiedName", properties, "getPathName");
        if (this.auditLog != null) {
            this.auditLog.logMessage("getPathName", GovernanceActionConnectorsAuditCode.QUALIFIED_NAME_PATH_NAME.getMessageDefinition(this.governanceServiceName, qualifiedName));
        }
        return qualifiedName;
    }

    private String getPathNameFromConnection(String assetGUID, RelatedMetadataElement connectionLink) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String endpointRelationshipName = "ConnectionEndpoint";
        String endpointNetworkAddressName = "networkAddress";
        String methodName = "getPathNameFromConnection";
        OpenMetadataStore store = this.governanceContext.getOpenMetadataStore();
        OpenMetadataElement connection = connectionLink.getElementProperties();
        if (connection == null) {
            if (this.auditLog != null) {
                this.auditLog.logMessage("getPathNameFromConnection", GovernanceActionConnectorsAuditCode.NO_RELATED_ASSET.getMessageDefinition(this.governanceServiceName, connectionLink.toString()));
            }
        } else {
            List endpointLinks = store.getRelatedMetadataElements(connection.getElementGUID(), 2, "ConnectionEndpoint", 0, 0);
            if (endpointLinks == null || endpointLinks.isEmpty()) {
                if (this.auditLog != null) {
                    this.auditLog.logMessage("getPathNameFromConnection", GovernanceActionConnectorsAuditCode.NO_LINKED_ENDPOINT.getMessageDefinition(this.governanceServiceName, assetGUID, connection.getElementGUID()));
                }
            } else if (endpointLinks.size() > 1) {
                if (this.auditLog != null) {
                    this.auditLog.logMessage("getPathNameFromConnection", GovernanceActionConnectorsAuditCode.TOO_MANY_ENDPOINTS.getMessageDefinition(this.governanceServiceName, assetGUID, connection.getElementGUID(), Integer.toString(endpointLinks.size()), endpointLinks.toString()));
                }
            } else {
                OpenMetadataElement endpoint = ((RelatedMetadataElement)endpointLinks.get(0)).getElementProperties();
                if (endpoint == null) {
                    if (this.auditLog != null) {
                        this.auditLog.logMessage("getPathNameFromConnection", GovernanceActionConnectorsAuditCode.NO_RELATED_ASSET.getMessageDefinition(this.governanceServiceName, ((RelatedMetadataElement)endpointLinks.get(0)).toString()));
                    }
                } else {
                    ElementProperties properties = endpoint.getElementProperties();
                    String address = this.propertyHelper.getStringProperty(this.governanceServiceName, "networkAddress", properties, "getPathNameFromConnection");
                    if (address == null && this.auditLog != null) {
                        this.auditLog.logMessage("getPathNameFromConnection", GovernanceActionConnectorsAuditCode.NO_NETWORK_ADDRESS.getMessageDefinition(this.governanceServiceName, endpoint.getElementGUID(), connection.getElementGUID(), assetGUID));
                    }
                    return address;
                }
            }
        }
        return null;
    }

    private String createLineage(String destinationFilePathName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String newFileGUID;
        String methodName = "createLineage";
        String childProcessTypeName = "TransientEmbeddedProcess";
        String topLevelProcessTypeName = "DeployedConnector";
        OpenMetadataStore metadataStore = this.governanceContext.getOpenMetadataStore();
        String fileName = FilenameUtils.getName((String)destinationFilePathName);
        String fileExtension = FilenameUtils.getExtension((String)destinationFilePathName);
        String topLevelProcessGUID = this.governanceContext.getOpenMetadataStore().getMetadataElementGUIDByUniqueName(this.topLevelProcessName, null);
        if (topLevelProcessGUID == null) {
            topLevelProcessGUID = this.topLevelProcessTemplateQualifiedName == null ? this.governanceContext.createProcess("DeployedConnector", ElementStatus.ACTIVE, this.topLevelProcessName, this.topLevelProcessName, null) : this.governanceContext.createProcessFromTemplate(this.topLevelProcessTemplateQualifiedName, ElementStatus.ACTIVE, this.topLevelProcessName, this.topLevelProcessName, null);
        }
        String processGUID = this.childProcessLineage ? this.governanceContext.createChildProcess("TransientEmbeddedProcess", ElementStatus.ACTIVE, this.topLevelProcessName + this.connectorInstanceId, this.topLevelProcessName, null, topLevelProcessGUID) : topLevelProcessGUID;
        if (this.sourceFileGUID == null) {
            this.sourceFileGUID = metadataStore.getMetadataElementGUIDByUniqueName(this.sourceFileName, "pathName");
            if (this.sourceFileGUID == null) {
                this.sourceFileGUID = metadataStore.getMetadataElementGUIDByUniqueName(this.sourceFileName, null);
            }
            if (!this.sourceLineageFromFile) {
                this.sourceFileGUID = this.getFolderGUID(this.sourceFileGUID);
            }
        }
        if (this.destinationFileTemplateQualifiedName == null) {
            String assetTypeName = this.getAssetTypeName(fileExtension);
            newFileGUID = this.governanceContext.createAsset(assetTypeName, destinationFilePathName, fileName, null);
        } else {
            String assetTemplateGUID = this.governanceContext.getOpenMetadataStore().getMetadataElementGUIDByUniqueName(this.destinationFileTemplateQualifiedName, null);
            newFileGUID = this.governanceContext.createAssetFromTemplate(assetTemplateGUID, destinationFilePathName, fileName, null);
        }
        if (!this.destinationLineageToFile) {
            newFileGUID = this.getFolderGUID(newFileGUID);
        }
        this.sourceFileGUID = this.governanceContext.getOpenMetadataStore().getMetadataElementGUIDByUniqueName(this.sourceFileName, null);
        if (this.sourceFileGUID != null) {
            this.governanceContext.createLineageMapping(this.sourceFileGUID, processGUID);
        }
        this.governanceContext.createLineageMapping(processGUID, newFileGUID);
        if (this.auditLog != null) {
            this.auditLog.logMessage("createLineage", GovernanceActionConnectorsAuditCode.CREATED_LINEAGE.getMessageDefinition(this.governanceServiceName, this.sourceFileGUID, processGUID, newFileGUID));
        }
        return newFileGUID;
    }

    private String getFolderGUID(String fileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String folderGUID = null;
        List relatedMetadataElementList = this.governanceContext.getOpenMetadataStore().getRelatedMetadataElements(fileGUID, 2, "NestedFile", 0, 0);
        if (relatedMetadataElementList != null) {
            for (RelatedMetadataElement relatedMetadataElement : relatedMetadataElementList) {
                if (relatedMetadataElement == null) continue;
                folderGUID = relatedMetadataElement.getElementProperties().getElementGUID();
            }
        }
        return folderGUID;
    }

    private String getAssetTypeName(String fileExtension) {
        String assetTypeName = "DataFile";
        if (fileExtension != null) {
            switch (fileExtension) {
                case "csv": {
                    assetTypeName = "CSVFile";
                    break;
                }
                case "json": {
                    assetTypeName = "JSONFile";
                    break;
                }
                case "avro": {
                    assetTypeName = "AvroFileName";
                    break;
                }
                case "pdf": 
                case "doc": 
                case "docx": 
                case "ppt": 
                case "pptx": 
                case "xls": 
                case "xlsx": 
                case "md": {
                    assetTypeName = "Document";
                    break;
                }
                case "jpg": 
                case "jpeg": 
                case "png": 
                case "gif": 
                case "mp3": 
                case "mp4": {
                    assetTypeName = "MediaFile";
                }
            }
        }
        return assetTypeName;
    }
}

