/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.governanceactions.remediation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.odpi.openmetadata.adapters.connectors.governanceactions.ffdc.GovernanceActionConnectorsAuditCode;
import org.odpi.openmetadata.adapters.connectors.governanceactions.ffdc.GovernanceActionConnectorsErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.governanceaction.RemediationGovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;

public class ZonePublisherGovernanceActionConnector
extends RemediationGovernanceActionService {
    private static final String assetZoneClassification = "AssetZoneMembership";
    private static final String assetZoneProperty = "zoneMembership";
    private List<String> publishZones = null;

    public void initialize(String connectorInstanceId, ConnectionProperties connectionProperties) {
        Object publishZonesOption;
        super.initialize(connectorInstanceId, connectionProperties);
        Map configurationProperties = connectionProperties.getConfigurationProperties();
        if (configurationProperties != null && (publishZonesOption = configurationProperties.get("publishZones")) != null) {
            this.publishZones = this.getZoneArrayFromString(publishZonesOption.toString());
        }
    }

    public void start() throws ConnectorCheckedException {
        String methodName = "start";
        super.start();
        if (this.governanceContext.getRequestParameters() != null) {
            Map requestParameters = this.governanceContext.getRequestParameters();
            for (String requestParameterName : requestParameters.keySet()) {
                if (requestParameterName == null || !"publishZones".equals(requestParameterName)) continue;
                this.publishZones = this.getZoneArrayFromString((String)requestParameters.get(requestParameterName));
            }
        }
        ArrayList<String> outputGuards = new ArrayList<String>();
        try {
            CompletionStatus completionStatus;
            if (this.publishZones == null || this.publishZones.isEmpty()) {
                if (this.auditLog != null) {
                    this.auditLog.logMessage("start", GovernanceActionConnectorsAuditCode.NO_ZONES.getMessageDefinition(this.governanceServiceName));
                }
                completionStatus = CompletionStatus.INVALID;
                outputGuards.add("no-zones-detected");
            } else if (this.governanceContext.getActionTargetElements() == null) {
                if (this.auditLog != null) {
                    this.auditLog.logMessage("start", GovernanceActionConnectorsAuditCode.NO_TARGETS.getMessageDefinition(this.governanceServiceName));
                }
                completionStatus = CompletionStatus.INVALID;
                outputGuards.add("no-targets-detected");
            } else {
                ElementProperties properties = this.getZoneProperties();
                for (ActionTargetElement actionTarget : this.governanceContext.getActionTargetElements()) {
                    if (actionTarget == null) continue;
                    OpenMetadataElement element = actionTarget.getTargetElement();
                    if (this.auditLog != null) {
                        this.auditLog.logMessage("start", GovernanceActionConnectorsAuditCode.SETTING_ZONES.getMessageDefinition(this.governanceServiceName, element.getElementGUID(), this.publishZones.toString()));
                    }
                    this.governanceContext.classifyMetadataElement(element.getElementGUID(), assetZoneClassification, properties);
                }
                completionStatus = CompletionStatus.ACTIONED;
                outputGuards.add("zone-assigned");
            }
            this.governanceContext.recordCompletionStatus(completionStatus, outputGuards);
        }
        catch (OCFCheckedExceptionBase error) {
            throw new ConnectorCheckedException(error.getReportedErrorMessage(), error);
        }
        catch (Exception error) {
            throw new ConnectorCheckedException(GovernanceActionConnectorsErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.governanceServiceName, error.getClass().getName(), error.getMessage()), error.getClass().getName(), "start", (Throwable)error);
        }
    }

    private ElementProperties getZoneProperties() {
        PropertyHelper helper = new PropertyHelper();
        return helper.addStringArrayProperty(null, assetZoneProperty, this.publishZones);
    }

    private List<String> getZoneArrayFromString(String zones) {
        ArrayList<String> zoneArray = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(zones, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String zone = stringTokenizer.nextToken();
            String trimedZone = zone.trim();
            if (trimedZone.length() == 0) continue;
            zoneArray.add(trimedZone);
        }
        return zoneArray;
    }
}

