/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.governanceactions.watchdog;

import java.util.ArrayList;
import java.util.HashMap;
import org.odpi.openmetadata.adapters.connectors.governanceactions.ffdc.GovernanceActionConnectorsAuditCode;
import org.odpi.openmetadata.adapters.connectors.governanceactions.watchdog.GenericWatchdogGovernanceActionConnector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogClassificationEvent;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogEventType;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogGovernanceEvent;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogMetadataElementEvent;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogRelatedElementsEvent;
import org.odpi.openmetadata.frameworks.governanceaction.ffdc.GovernanceServiceException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.NewActionTarget;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElements;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;

public class GenericElementWatchdogGovernanceActionConnector
extends GenericWatchdogGovernanceActionConnector {
    public void start() throws ConnectorCheckedException {
        super.start("OpenMetadataRoot");
    }

    @Override
    void processEvent(WatchdogGovernanceEvent event) throws GovernanceServiceException {
        block30: {
            String methodName = "processEvent";
            if (!this.completed) {
                WatchdogRelatedElementsEvent relatedElementsEvent;
                RelatedMetadataElements relatedMetadataElements;
                if (event instanceof WatchdogMetadataElementEvent) {
                    WatchdogMetadataElementEvent metadataElementEvent = (WatchdogMetadataElementEvent)event;
                    String elementGUID = metadataElementEvent.getMetadataElement().getElementGUID();
                    HashMap<String, String> requestParameters = new HashMap<String, String>();
                    ArrayList<NewActionTarget> actionTargets = new ArrayList<NewActionTarget>();
                    NewActionTarget actionTarget = new NewActionTarget();
                    actionTarget.setActionTargetName(this.actionTargetName);
                    actionTarget.setActionTargetGUID(elementGUID);
                    actionTargets.add(actionTarget);
                    if (this.instancesToListenTo == null || this.instancesToListenTo.contains(elementGUID)) {
                        if (metadataElementEvent.getEventType() != WatchdogEventType.NEW_ELEMENT) {
                            this.initiateProcess(this.newElementProcessName, null, actionTargets);
                        } else if (metadataElementEvent.getEventType() != WatchdogEventType.UPDATED_ELEMENT_PROPERTIES) {
                            ElementProperties previousElementProperties = null;
                            if (metadataElementEvent.getPreviousMetadataElement() != null) {
                                previousElementProperties = metadataElementEvent.getPreviousMetadataElement().getElementProperties();
                            }
                            requestParameters.put("ChangedProperties", this.diffProperties(previousElementProperties, metadataElementEvent.getMetadataElement().getElementProperties()));
                            this.initiateProcess(this.updatedElementProcessName, requestParameters, actionTargets);
                        } else if (metadataElementEvent.getEventType() != WatchdogEventType.DELETED_ELEMENT) {
                            this.initiateProcess(this.deletedElementProcessName, null, actionTargets);
                        } else {
                            WatchdogClassificationEvent classificationEvent = (WatchdogClassificationEvent)event;
                            requestParameters.put("ClassificationName", classificationEvent.getChangedClassification().getClassificationName());
                            if (metadataElementEvent.getEventType() != WatchdogEventType.NEW_CLASSIFICATION) {
                                this.initiateProcess(this.classifiedElementProcessName, requestParameters, actionTargets);
                            } else if (metadataElementEvent.getEventType() != WatchdogEventType.UPDATED_CLASSIFICATION_PROPERTIES) {
                                ElementProperties previousElementProperties = null;
                                if (classificationEvent.getPreviousClassification() != null) {
                                    previousElementProperties = classificationEvent.getPreviousClassification().getClassificationProperties();
                                }
                                requestParameters.put("ChangedProperties", this.diffProperties(previousElementProperties, classificationEvent.getChangedClassification().getClassificationProperties()));
                                this.initiateProcess(this.reclassifiedElementProcessName, requestParameters, actionTargets);
                            } else if (metadataElementEvent.getEventType() != WatchdogEventType.DELETED_CLASSIFICATION) {
                                this.initiateProcess(this.declassifiedElementProcessName, requestParameters, actionTargets);
                            }
                        }
                        if ("process-single-event".equals(this.governanceContext.getRequestType())) {
                            this.completed = true;
                        }
                    }
                } else if (event instanceof WatchdogRelatedElementsEvent && (relatedMetadataElements = (relatedElementsEvent = (WatchdogRelatedElementsEvent)event).getRelatedMetadataElements()) != null) {
                    String end1GUID = relatedMetadataElements.getElementGUIDAtEnd1();
                    String end2GUID = relatedMetadataElements.getElementGUIDAtEnd2();
                    if (this.instancesToListenTo == null || this.instancesToListenTo.contains(end1GUID) || this.instancesToListenTo.contains(end2GUID)) {
                        HashMap<String, String> requestParameters = new HashMap<String, String>();
                        requestParameters.put("RelationshipGUID", relatedMetadataElements.getRelationshipGUID());
                        requestParameters.put("RelationshipTypeName", relatedMetadataElements.getRelationshipType().getElementTypeName());
                        ArrayList<NewActionTarget> actionTargets = new ArrayList<NewActionTarget>();
                        NewActionTarget actionTarget = new NewActionTarget();
                        actionTarget.setActionTargetName(this.actionTargetName);
                        actionTarget.setActionTargetGUID(end1GUID);
                        actionTargets.add(actionTarget);
                        actionTarget.setActionTargetName(this.actionTargetTwoName);
                        actionTarget.setActionTargetGUID(end2GUID);
                        actionTargets.add(actionTarget);
                        if (relatedElementsEvent.getEventType() == WatchdogEventType.NEW_RELATIONSHIP) {
                            this.initiateProcess(this.newRelationshipProcessName, requestParameters, actionTargets);
                        } else if (relatedElementsEvent.getEventType() == WatchdogEventType.UPDATED_RELATIONSHIP_PROPERTIES) {
                            ElementProperties previousElementProperties = null;
                            if (relatedElementsEvent.getPreviousRelatedMetadataElements() != null) {
                                previousElementProperties = relatedElementsEvent.getPreviousRelatedMetadataElements().getRelationshipProperties();
                            }
                            requestParameters.put("ChangedProperties", this.diffProperties(previousElementProperties, relatedMetadataElements.getRelationshipProperties()));
                            this.initiateProcess(this.updatedRelationshipProcessName, requestParameters, actionTargets);
                        } else if (relatedElementsEvent.getEventType() == WatchdogEventType.DELETED_RELATIONSHIP) {
                            this.initiateProcess(this.deletedRelationshipProcessName, requestParameters, actionTargets);
                        }
                        if ("process-single-event".equals(this.governanceContext.getRequestType())) {
                            this.completed = true;
                        }
                    }
                }
                if (this.completed) {
                    try {
                        ArrayList<String> outputGuards = new ArrayList<String>();
                        outputGuards.add("monitoring-failed");
                        this.governanceContext.recordCompletionStatus(CompletionStatus.FAILED, outputGuards);
                    }
                    catch (Exception error) {
                        if (this.auditLog == null) break block30;
                        this.auditLog.logException("processEvent", GovernanceActionConnectorsAuditCode.UNABLE_TO_SET_COMPLETION_STATUS.getMessageDefinition(this.governanceServiceName, error.getClass().getName(), error.getMessage()), (Throwable)error);
                    }
                }
            }
        }
    }

    @Override
    public void disconnect() throws ConnectorCheckedException {
        super.disconnect();
    }
}

