/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.governanceactions.watchdog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.governanceactions.ffdc.GovernanceActionConnectorsAuditCode;
import org.odpi.openmetadata.adapters.connectors.governanceactions.watchdog.GenericWatchdogGovernanceActionConnector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.governanceaction.GovernanceContext;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogClassificationEvent;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogEventType;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogGovernanceEvent;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogMetadataElementEvent;
import org.odpi.openmetadata.frameworks.governanceaction.ffdc.GovernanceServiceException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.NewActionTarget;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;

public class GenericFolderWatchdogGovernanceActionConnector
extends GenericWatchdogGovernanceActionConnector {
    private String folderName = null;
    private String folderGUID = null;

    public void initialize(String connectorInstanceId, ConnectionProperties connectionProperties) {
        Object folderNameOption;
        super.initialize(connectorInstanceId, connectionProperties);
        Map configurationProperties = connectionProperties.getConfigurationProperties();
        if (configurationProperties != null && (folderNameOption = configurationProperties.get("folderName")) != null) {
            this.folderName = folderNameOption.toString();
        }
    }

    public void start() throws ConnectorCheckedException {
        List actionTargetElements;
        super.validateContext((GovernanceContext)this.governanceContext);
        if (this.governanceContext.getRequestParameters() != null) {
            Map requestParameters = this.governanceContext.getRequestParameters();
            for (String requestParameterName : requestParameters.keySet()) {
                if (requestParameterName == null || !"folderName".equals(requestParameterName)) continue;
                this.folderName = (String)requestParameters.get(requestParameterName);
            }
        }
        if ((actionTargetElements = this.governanceContext.getActionTargetElements()) != null) {
            for (ActionTargetElement actionTargetElement : actionTargetElements) {
                if (actionTargetElement == null || !"folderTarget".equals(actionTargetElement.getActionTargetName())) continue;
                this.folderGUID = actionTargetElement.getActionTargetGUID();
            }
        }
        if (this.folderGUID == null && this.folderName != null) {
            try {
                this.folderGUID = this.governanceContext.getOpenMetadataStore().getMetadataElementGUIDByUniqueName(this.folderName, null, false, false, null);
            }
            catch (OCFCheckedExceptionBase error) {
                throw new ConnectorCheckedException(error.getMessage(), error);
            }
        }
        super.start("DataFile");
    }

    @Override
    void processEvent(WatchdogGovernanceEvent event) throws GovernanceServiceException {
        block18: {
            String methodName = "processEvent";
            if (!this.completed) {
                WatchdogMetadataElementEvent metadataElementEvent;
                String fileGUID;
                if (event instanceof WatchdogMetadataElementEvent && this.fileInFolder(fileGUID = (metadataElementEvent = (WatchdogMetadataElementEvent)event).getMetadataElement().getElementGUID())) {
                    HashMap<String, String> requestParameters = new HashMap<String, String>();
                    ArrayList<NewActionTarget> actionTargets = new ArrayList<NewActionTarget>();
                    NewActionTarget actionTarget = new NewActionTarget();
                    actionTarget.setActionTargetGUID(fileGUID);
                    actionTarget.setActionTargetName(this.actionTargetName);
                    actionTargets.add(actionTarget);
                    if (metadataElementEvent.getEventType() == WatchdogEventType.NEW_ELEMENT) {
                        this.initiateProcess(this.newElementProcessName, null, actionTargets);
                    } else if (metadataElementEvent.getEventType() == WatchdogEventType.UPDATED_ELEMENT_PROPERTIES) {
                        ElementProperties previousElementProperties = null;
                        if (metadataElementEvent.getPreviousMetadataElement() != null) {
                            previousElementProperties = metadataElementEvent.getPreviousMetadataElement().getElementProperties();
                        }
                        requestParameters.put("ChangedProperties", this.diffProperties(previousElementProperties, metadataElementEvent.getMetadataElement().getElementProperties()));
                        this.initiateProcess(this.updatedElementProcessName, requestParameters, actionTargets);
                    } else if (metadataElementEvent.getEventType() == WatchdogEventType.DELETED_ELEMENT) {
                        this.initiateProcess(this.deletedElementProcessName, null, actionTargets);
                    } else {
                        WatchdogClassificationEvent classificationEvent = (WatchdogClassificationEvent)event;
                        requestParameters.put("ClassificationName", classificationEvent.getChangedClassification().getClassificationName());
                        if (metadataElementEvent.getEventType() == WatchdogEventType.NEW_CLASSIFICATION) {
                            this.initiateProcess(this.classifiedElementProcessName, requestParameters, actionTargets);
                        } else if (metadataElementEvent.getEventType() == WatchdogEventType.UPDATED_CLASSIFICATION_PROPERTIES) {
                            ElementProperties previousElementProperties = null;
                            if (classificationEvent.getPreviousClassification() != null) {
                                previousElementProperties = classificationEvent.getPreviousClassification().getClassificationProperties();
                            }
                            requestParameters.put("ChangedProperties", this.diffProperties(previousElementProperties, classificationEvent.getChangedClassification().getClassificationProperties()));
                            this.initiateProcess(this.reclassifiedElementProcessName, requestParameters, actionTargets);
                        } else if (metadataElementEvent.getEventType() == WatchdogEventType.DELETED_CLASSIFICATION) {
                            this.initiateProcess(this.declassifiedElementProcessName, requestParameters, actionTargets);
                        }
                    }
                }
                if (this.completed) {
                    try {
                        ArrayList<String> outputGuards = new ArrayList<String>();
                        outputGuards.add("monitoring-failed");
                        this.governanceContext.recordCompletionStatus(CompletionStatus.FAILED, outputGuards);
                    }
                    catch (Exception error) {
                        if (this.auditLog == null) break block18;
                        this.auditLog.logException("processEvent", GovernanceActionConnectorsAuditCode.UNABLE_TO_SET_COMPLETION_STATUS.getMessageDefinition(this.governanceServiceName, error.getClass().getName(), error.getMessage()), (Throwable)error);
                    }
                }
            }
        }
    }

    private boolean fileInFolder(String fileGUID) throws GovernanceServiceException {
        if (this.folderGUID == null) {
            return true;
        }
        try {
            String parentFolderGUID = this.getFolderGUID(fileGUID, "NestedFile");
            if ("watch-member-of-folder".equals(this.governanceContext.getRequestType())) {
                if (parentFolderGUID != null) {
                    return parentFolderGUID.equals(this.folderGUID);
                }
            } else {
                while (parentFolderGUID != null) {
                    if (parentFolderGUID.equals(this.folderGUID)) {
                        return true;
                    }
                    parentFolderGUID = this.getFolderGUID(parentFolderGUID, "FolderHierarchy");
                }
            }
            return false;
        }
        catch (OCFCheckedExceptionBase error) {
            throw new GovernanceServiceException(error.getMessage(), error);
        }
    }

    private String getFolderGUID(String fileGUID, String relationshipName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String folderGUID = null;
        List relatedMetadataElementList = this.governanceContext.getOpenMetadataStore().getRelatedMetadataElements(fileGUID, 2, relationshipName, false, false, null, 0, 0);
        if (relatedMetadataElementList != null) {
            for (RelatedMetadataElement relatedMetadataElement : relatedMetadataElementList) {
                if (relatedMetadataElement == null) continue;
                folderGUID = relatedMetadataElement.getElementProperties().getElementGUID();
            }
        }
        return folderGUID;
    }

    @Override
    public void disconnect() throws ConnectorCheckedException {
        super.disconnect();
    }
}

