/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.governanceactions.remediation;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.adapters.connectors.governanceactions.ffdc.GovernanceActionConnectorsErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.governanceaction.OpenMetadataClient;
import org.odpi.openmetadata.frameworks.governanceaction.RemediationGovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.MatchCriteria;
import org.odpi.openmetadata.frameworks.governanceaction.search.PrimitiveTypeCategory;
import org.odpi.openmetadata.frameworks.governanceaction.search.PrimitiveTypePropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyComparisonOperator;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyCondition;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;

public class QualifiedNamePeerDuplicateGovernanceActionConnector
extends RemediationGovernanceActionService {
    private static final String QUALIFIED_NAME_PROPERTY = "qualifiedName";

    public void start() throws ConnectorCheckedException {
        String methodName = "start";
        super.start();
        ArrayList<String> outputGuards = new ArrayList<String>();
        CompletionStatus completionStatus = CompletionStatus.INVALID;
        try {
            if (this.governanceContext.getActionTargetElements() == null) {
                completionStatus = CompletionStatus.FAILED;
                outputGuards.add("no-targets-detected");
            } else if (this.governanceContext.getActionTargetElements().size() == 1) {
                ActionTargetElement actionTarget = (ActionTargetElement)this.governanceContext.getActionTargetElements().get(0);
                OpenMetadataElement targetElement = actionTarget.getTargetElement();
                OpenMetadataClient store = (OpenMetadataClient)this.governanceContext.getOpenMetadataStore();
                String qualifiedName = ((PropertyValue)targetElement.getElementProperties().getPropertyValueMap().get(QUALIFIED_NAME_PROPERTY)).valueAsString();
                SearchProperties searchProperties = this.getSearchProperties(qualifiedName);
                List elements = store.findMetadataElements(targetElement.getType().getTypeId(), null, searchProperties, null, null, null, null, false, true, new Date(), 0, 0);
                if (elements != null) {
                    String targetElementGUID = targetElement.getElementGUID();
                    if (elements.size() == 1 && ((OpenMetadataElement)elements.get(0)).getElementGUID().equalsIgnoreCase(targetElementGUID)) {
                        outputGuards.add("no-duplication-detected");
                    }
                    for (OpenMetadataElement duplicateAsset : elements) {
                        String duplicateAssetGUID = duplicateAsset.getElementGUID();
                        if (duplicateAssetGUID.equalsIgnoreCase(targetElementGUID)) continue;
                        store.linkElementsAsPeerDuplicates(targetElementGUID, duplicateAssetGUID, 1, null, null, null, null, null, true);
                        outputGuards.add("duplicate-detected");
                        completionStatus = CompletionStatus.ACTIONED;
                        break;
                    }
                }
            }
            this.governanceContext.recordCompletionStatus(completionStatus, outputGuards);
        }
        catch (OCFCheckedExceptionBase error) {
            throw new ConnectorCheckedException(error.getReportedErrorMessage(), error);
        }
        catch (Exception error) {
            throw new ConnectorCheckedException(GovernanceActionConnectorsErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.governanceServiceName, error.getClass().getName(), error.getMessage()), error.getClass().getName(), "start", (Throwable)error);
        }
    }

    private SearchProperties getSearchProperties(String qualifiedName) {
        SearchProperties searchProperties = new SearchProperties();
        ArrayList<PropertyCondition> conditions = new ArrayList<PropertyCondition>();
        PropertyCondition condition = new PropertyCondition();
        PrimitiveTypePropertyValue primitivePropertyValue = new PrimitiveTypePropertyValue();
        primitivePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING);
        primitivePropertyValue.setPrimitiveValue((Object)qualifiedName);
        primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName());
        condition.setProperty(QUALIFIED_NAME_PROPERTY);
        condition.setOperator(PropertyComparisonOperator.EQ);
        condition.setValue((PropertyValue)primitivePropertyValue);
        conditions.add(condition);
        searchProperties.setConditions(conditions);
        searchProperties.setMatchCriteria(MatchCriteria.ALL);
        return searchProperties;
    }
}

