/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.governanceactions.provisioning;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.odpi.openmetadata.adapters.connectors.governanceactions.ffdc.GovernanceActionConnectorsAuditCode;
import org.odpi.openmetadata.adapters.connectors.governanceactions.ffdc.GovernanceActionConnectorsErrorCode;
import org.odpi.openmetadata.adapters.connectors.governanceactions.provisioning.MoveCopyFileGuard;
import org.odpi.openmetadata.adapters.connectors.governanceactions.provisioning.RequestParameter;
import org.odpi.openmetadata.adapters.connectors.governanceactions.provisioning.RequestType;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStatus;
import org.odpi.openmetadata.frameworks.governanceaction.OpenMetadataStore;
import org.odpi.openmetadata.frameworks.governanceaction.ProvisioningGovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.NewActionTarget;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;

public class MoveCopyFileGovernanceActionConnector
extends ProvisioningGovernanceActionService {
    private static final Map<String, Integer> fileIndexMap = new HashMap<String, Integer>();
    private final PropertyHelper propertyHelper = new PropertyHelper();
    private String topLevelProcessName = "Egeria:MoveCopyDeleteFileGovernanceActionService";
    private String destinationFileTemplateQualifiedName = null;
    private String topLevelProcessTemplateQualifiedName = null;
    private String destinationFileNamePattern = "{0}";
    private String sourceFileName = null;
    private String sourceFileGUID = null;
    private String destinationFolderName = null;
    private boolean copyFile = true;
    private boolean deleteFile = false;
    private boolean createLineage = true;
    private boolean sourceLineageFromFile = true;
    private boolean destinationLineageToFile = true;
    private boolean childProcessLineage = true;

    private static synchronized String getDestinationFileName(String previousDestinationFileName, String destinationFolderName, File sourceFile, String fileNamePattern) {
        int fileIndex = fileIndexMap.get(destinationFolderName) != null ? fileIndexMap.get(destinationFolderName) + 1 : 0;
        String nextDestinationFileName = fileNamePattern != null ? FilenameUtils.concat((String)destinationFolderName, (String)MessageFormat.format(fileNamePattern, sourceFile.getName(), fileIndex)) : FilenameUtils.concat((String)destinationFolderName, (String)sourceFile.getName());
        if (previousDestinationFileName != null && previousDestinationFileName.equals(nextDestinationFileName)) {
            return null;
        }
        fileIndexMap.put(destinationFolderName, fileIndex);
        return nextDestinationFileName;
    }

    private static synchronized String provisionFile(String governanceServiceName, String destinationFolderName, String sourceFilePathName, String fileNamePattern, boolean copyFile, AuditLog auditLog) throws IOException {
        String methodName = "provisionFile";
        File sourceFile = new File(sourceFilePathName);
        File destinationFolder = new File(destinationFolderName);
        if (!destinationFolder.exists()) {
            FileUtils.forceMkdir((File)destinationFolder);
        }
        String destinationFileName = MoveCopyFileGovernanceActionConnector.getDestinationFileName(null, destinationFolderName, sourceFile, fileNamePattern);
        while (destinationFileName != null) {
            File destinationFile = new File(destinationFileName);
            if (!FileUtils.directoryContains((File)destinationFolder, (File)destinationFile)) {
                if (copyFile) {
                    if (auditLog != null) {
                        auditLog.logMessage("provisionFile", GovernanceActionConnectorsAuditCode.COPY_FILE.getMessageDefinition(governanceServiceName, sourceFilePathName, destinationFileName));
                    }
                    FileUtils.copyFile((File)sourceFile, (File)destinationFile, (boolean)true);
                } else {
                    if (auditLog != null) {
                        auditLog.logMessage("provisionFile", GovernanceActionConnectorsAuditCode.MOVE_FILE.getMessageDefinition(governanceServiceName, sourceFilePathName, destinationFileName));
                    }
                    FileUtils.moveFile((File)sourceFile, (File)destinationFile);
                }
                return destinationFileName;
            }
            destinationFileName = MoveCopyFileGovernanceActionConnector.getDestinationFileName(destinationFileName, destinationFolderName, sourceFile, fileNamePattern);
        }
        if (auditLog != null) {
            auditLog.logMessage("provisionFile", GovernanceActionConnectorsAuditCode.PROVISIONING_FAILURE.getMessageDefinition(governanceServiceName, sourceFilePathName, destinationFolderName, fileNamePattern));
        }
        return null;
    }

    public void start() throws ConnectorCheckedException {
        CompletionStatus completionStatus;
        String methodName = "start";
        super.start();
        ArrayList<String> outputGuards = new ArrayList<String>();
        String completionMessage = null;
        if (RequestType.MOVE_FILE.requestType.equals(this.governanceContext.getRequestType())) {
            this.copyFile = false;
        } else if (RequestType.DELETE_FILE.requestType.equals(this.governanceContext.getRequestType())) {
            this.deleteFile = true;
        }
        Map configurationProperties = this.connectionProperties.getConfigurationProperties();
        if (configurationProperties != null) {
            Object processLineageOption;
            Object destinationLineageOption;
            Object sourceLineageOption;
            Object destinationFolderOption;
            Object fileNamePatternOption;
            Object templateNameOption;
            Object processNameOption;
            Object noLineageOption = configurationProperties.get(RequestParameter.NO_LINEAGE.getName());
            if (noLineageOption != null) {
                this.createLineage = false;
            }
            if ((processNameOption = configurationProperties.get(RequestParameter.TOP_LEVEL_PROCESS_NAME.getName())) != null) {
                this.topLevelProcessName = processNameOption.toString();
            }
            if ((templateNameOption = configurationProperties.get(RequestParameter.DESTINATION_TEMPLATE_NAME.getName())) != null) {
                this.destinationFileTemplateQualifiedName = templateNameOption.toString();
            }
            if ((templateNameOption = configurationProperties.get(RequestParameter.TOP_LEVEL_PROCESS_TEMPLATE_NAME.getName())) != null) {
                this.topLevelProcessTemplateQualifiedName = templateNameOption.toString();
            }
            if ((fileNamePatternOption = configurationProperties.get(RequestParameter.TARGET_FILE_NAME_PATTERN.getName())) != null) {
                this.destinationFileNamePattern = fileNamePatternOption.toString();
            }
            if ((destinationFolderOption = configurationProperties.get(RequestParameter.DESTINATION_DIRECTORY.getName())) != null) {
                this.destinationFolderName = destinationFolderOption.toString();
            }
            if ((sourceLineageOption = configurationProperties.get(RequestParameter.LINEAGE_FROM_SOURCE_FOLDER_ONLY.getName())) != null) {
                this.sourceLineageFromFile = false;
            }
            if ((destinationLineageOption = configurationProperties.get(RequestParameter.LINEAGE_TO_DESTINATION_FOLDER_ONLY.getName())) != null) {
                this.destinationLineageToFile = false;
            }
            if ((processLineageOption = configurationProperties.get(RequestParameter.TOP_LEVEL_PROCESS_ONLY_LINEAGE.getName())) != null) {
                this.childProcessLineage = false;
            }
        }
        if (this.governanceContext.getRequestParameters() != null) {
            Map requestParameters = this.governanceContext.getRequestParameters();
            for (String requestParameterName : requestParameters.keySet()) {
                if (RequestParameter.SOURCE_FILE.name.equals(requestParameterName)) {
                    this.sourceFileName = (String)requestParameters.get(requestParameterName);
                    continue;
                }
                if (RequestParameter.DESTINATION_DIRECTORY.name.equals(requestParameterName)) {
                    this.destinationFolderName = (String)requestParameters.get(requestParameterName);
                    continue;
                }
                if (RequestParameter.DESTINATION_TEMPLATE_NAME.getName().equals(requestParameterName)) {
                    this.destinationFileTemplateQualifiedName = (String)requestParameters.get(requestParameterName);
                    continue;
                }
                if (RequestParameter.TARGET_FILE_NAME_PATTERN.getName().equals(requestParameterName)) {
                    this.destinationFileNamePattern = (String)requestParameters.get(requestParameterName);
                    continue;
                }
                if (RequestParameter.NO_LINEAGE.getName().equals(requestParameterName)) {
                    this.createLineage = false;
                    continue;
                }
                if (RequestParameter.TOP_LEVEL_PROCESS_NAME.getName().equals(requestParameterName)) {
                    this.topLevelProcessName = (String)requestParameters.get(requestParameterName);
                    continue;
                }
                if (RequestParameter.TOP_LEVEL_PROCESS_TEMPLATE_NAME.getName().equals(requestParameterName)) {
                    this.topLevelProcessTemplateQualifiedName = (String)requestParameters.get(requestParameterName);
                    continue;
                }
                if (RequestParameter.TOP_LEVEL_PROCESS_ONLY_LINEAGE.getName().equals(requestParameterName)) {
                    this.childProcessLineage = false;
                    continue;
                }
                if (RequestParameter.LINEAGE_FROM_SOURCE_FOLDER_ONLY.getName().equals(requestParameterName)) {
                    this.sourceLineageFromFile = false;
                    continue;
                }
                if (!RequestParameter.LINEAGE_TO_DESTINATION_FOLDER_ONLY.getName().equals(requestParameterName)) continue;
                this.destinationLineageToFile = false;
            }
        }
        if (this.governanceContext.getActionTargetElements() != null) {
            for (ActionTargetElement actionTargetElement : this.governanceContext.getActionTargetElements()) {
                OpenMetadataElement destinationMetadataElement;
                if (actionTargetElement == null) continue;
                if ("sourceFile".equals(actionTargetElement.getActionTargetName())) {
                    OpenMetadataElement sourceMetadataElement = actionTargetElement.getTargetElement();
                    if (sourceMetadataElement == null) continue;
                    this.sourceFileName = this.getPathName(sourceMetadataElement);
                    this.sourceFileGUID = sourceMetadataElement.getElementGUID();
                    continue;
                }
                if (!"destinationFolder".equals(actionTargetElement.getActionTargetName()) || (destinationMetadataElement = actionTargetElement.getTargetElement()) == null) continue;
                this.destinationFolderName = this.getPathName(destinationMetadataElement);
            }
        }
        if (this.sourceFileName == null) {
            if (this.auditLog != null) {
                this.auditLog.logMessage("start", GovernanceActionConnectorsAuditCode.NO_SOURCE_FILE_NAME.getMessageDefinition(this.governanceServiceName));
            }
            throw new ConnectorCheckedException(GovernanceActionConnectorsErrorCode.NO_SOURCE_FILE_NAME.getMessageDefinition(this.governanceServiceName), ((Object)((Object)this)).getClass().getName(), "start");
        }
        ArrayList<NewActionTarget> newActionTargets = null;
        try {
            if (this.deleteFile) {
                File fileToDelete = new File(this.sourceFileName);
                FileUtils.forceDelete((File)fileToDelete);
                outputGuards.add(MoveCopyFileGuard.PROVISIONING_COMPLETE.getName());
                completionStatus = MoveCopyFileGuard.PROVISIONING_COMPLETE.getCompletionStatus();
            } else {
                String destinationFileName = MoveCopyFileGovernanceActionConnector.provisionFile(this.governanceServiceName, this.destinationFolderName, this.sourceFileName, this.destinationFileNamePattern, this.copyFile, this.auditLog);
                if (destinationFileName != null) {
                    String newActionTargetGUID = null;
                    if (this.createLineage) {
                        newActionTargetGUID = this.createLineage(destinationFileName);
                    }
                    if (newActionTargetGUID != null) {
                        newActionTargets = new ArrayList<NewActionTarget>();
                        NewActionTarget actionTarget = new NewActionTarget();
                        actionTarget.setActionTargetGUID(newActionTargetGUID);
                        actionTarget.setActionTargetName("newAsset");
                        newActionTargets.add(actionTarget);
                    }
                    outputGuards.add(MoveCopyFileGuard.PROVISIONING_COMPLETE.getName());
                    completionStatus = MoveCopyFileGuard.PROVISIONING_COMPLETE.getCompletionStatus();
                } else {
                    outputGuards.add(MoveCopyFileGuard.PROVISIONING_FAILED_NO_FILE_NAMES.getName());
                    completionStatus = MoveCopyFileGuard.PROVISIONING_FAILED_NO_FILE_NAMES.getCompletionStatus();
                }
            }
        }
        catch (Exception error) {
            if (this.auditLog != null) {
                this.auditLog.logException("start", GovernanceActionConnectorsAuditCode.PROVISIONING_EXCEPTION.getMessageDefinition(this.governanceServiceName, error.getClass().getName(), this.sourceFileName, this.destinationFolderName, this.destinationFileNamePattern, error.getMessage()), (Throwable)error);
            }
            outputGuards.add(MoveCopyFileGuard.PROVISIONING_FAILED_EXCEPTION.getName());
            completionStatus = MoveCopyFileGuard.PROVISIONING_FAILED_EXCEPTION.getCompletionStatus();
            completionMessage = error.getMessage();
        }
        try {
            this.governanceContext.recordCompletionStatus(completionStatus, outputGuards, null, newActionTargets, completionMessage);
        }
        catch (OCFCheckedExceptionBase error) {
            throw new ConnectorCheckedException(error.getReportedErrorMessage(), error);
        }
    }

    private String getPathName(OpenMetadataElement asset) {
        String pathName;
        ElementProperties properties;
        block14: {
            String methodName = "getPathName";
            String connectionRelationshipName = "ConnectionToAsset";
            String qualifiedNameParameterName = "qualifiedName";
            String pathNameParameterName = "pathName";
            properties = asset.getElementProperties();
            pathName = this.propertyHelper.getStringProperty(this.governanceServiceName, "pathName", properties, "getPathName");
            if (pathName != null) {
                return pathName;
            }
            OpenMetadataStore store = this.governanceContext.getOpenMetadataStore();
            try {
                List connectionLinks = store.getRelatedMetadataElements(asset.getElementGUID(), 2, "ConnectionToAsset", 0, 0);
                if (connectionLinks == null || connectionLinks.isEmpty()) {
                    if (this.auditLog != null) {
                        this.auditLog.logMessage("getPathName", GovernanceActionConnectorsAuditCode.NO_LINKED_CONNECTION.getMessageDefinition(this.governanceServiceName, asset.getElementGUID()));
                    }
                } else if (connectionLinks.size() > 1) {
                    for (RelatedMetadataElement connectionLink : connectionLinks) {
                        String networkAddress;
                        if (connectionLink == null || (networkAddress = this.getPathNameFromConnection(asset.getElementGUID(), connectionLink)) == null) continue;
                        if (pathName == null) {
                            pathName = networkAddress;
                            continue;
                        }
                        if (networkAddress.equals(pathName)) continue;
                        if (this.auditLog != null) {
                            this.auditLog.logMessage("getPathName", GovernanceActionConnectorsAuditCode.TOO_MANY_CONNECTIONS.getMessageDefinition(this.governanceServiceName, Integer.toString(connectionLinks.size()), asset.getElementGUID(), connectionLinks.toString()));
                        }
                        pathName = null;
                        break;
                    }
                    if (pathName != null) {
                        return pathName;
                    }
                } else {
                    pathName = this.getPathNameFromConnection(asset.getElementGUID(), (RelatedMetadataElement)connectionLinks.get(0));
                    if (pathName != null) {
                        return pathName;
                    }
                }
            }
            catch (Exception error) {
                if (this.auditLog == null) break block14;
                this.auditLog.logException("getPathName", GovernanceActionConnectorsAuditCode.ENDPOINT_EXCEPTION.getMessageDefinition(this.governanceServiceName, error.getClass().getName(), error.getMessage()), (Throwable)error);
            }
        }
        pathName = this.propertyHelper.getStringProperty(this.governanceServiceName, "qualifiedName", properties, "getPathName");
        if (this.auditLog != null) {
            this.auditLog.logMessage("getPathName", GovernanceActionConnectorsAuditCode.QUALIFIED_NAME_PATH_NAME.getMessageDefinition(this.governanceServiceName, pathName));
        }
        return pathName;
    }

    private String getPathNameFromConnection(String assetGUID, RelatedMetadataElement connectionLink) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String endpointRelationshipName = "ConnectionEndpoint";
        String endpointNetworkAddressName = "networkAddress";
        String methodName = "getPathNameFromConnection";
        OpenMetadataStore store = this.governanceContext.getOpenMetadataStore();
        OpenMetadataElement connection = connectionLink.getElement();
        if (connection == null) {
            if (this.auditLog != null) {
                this.auditLog.logMessage("getPathNameFromConnection", GovernanceActionConnectorsAuditCode.NO_RELATED_ASSET.getMessageDefinition(this.governanceServiceName, connectionLink.toString()));
            }
        } else {
            List endpointLinks = store.getRelatedMetadataElements(connection.getElementGUID(), 2, "ConnectionEndpoint", 0, 0);
            if (endpointLinks == null || endpointLinks.isEmpty()) {
                if (this.auditLog != null) {
                    this.auditLog.logMessage("getPathNameFromConnection", GovernanceActionConnectorsAuditCode.NO_LINKED_ENDPOINT.getMessageDefinition(this.governanceServiceName, assetGUID, connection.getElementGUID()));
                }
            } else if (endpointLinks.size() > 1) {
                if (this.auditLog != null) {
                    this.auditLog.logMessage("getPathNameFromConnection", GovernanceActionConnectorsAuditCode.TOO_MANY_ENDPOINTS.getMessageDefinition(this.governanceServiceName, assetGUID, connection.getElementGUID(), Integer.toString(endpointLinks.size()), endpointLinks.toString()));
                }
            } else {
                OpenMetadataElement endpoint = ((RelatedMetadataElement)endpointLinks.get(0)).getElement();
                if (endpoint == null) {
                    if (this.auditLog != null) {
                        this.auditLog.logMessage("getPathNameFromConnection", GovernanceActionConnectorsAuditCode.NO_RELATED_ASSET.getMessageDefinition(this.governanceServiceName, ((RelatedMetadataElement)endpointLinks.get(0)).toString()));
                    }
                } else {
                    ElementProperties properties = endpoint.getElementProperties();
                    String address = this.propertyHelper.getStringProperty(this.governanceServiceName, "networkAddress", properties, "getPathNameFromConnection");
                    if (address == null && this.auditLog != null) {
                        this.auditLog.logMessage("getPathNameFromConnection", GovernanceActionConnectorsAuditCode.NO_NETWORK_ADDRESS.getMessageDefinition(this.governanceServiceName, endpoint.getElementGUID(), connection.getElementGUID(), assetGUID));
                    }
                    return address;
                }
            }
        }
        return null;
    }

    private String createLineage(String destinationFilePathName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String newFileGUID;
        String methodName = "createLineage";
        String childProcessTypeName = "TransientEmbeddedProcess";
        String topLevelProcessTypeName = "DeployedConnector";
        OpenMetadataStore metadataStore = this.governanceContext.getOpenMetadataStore();
        String fileName = FilenameUtils.getName((String)destinationFilePathName);
        String fileExtension = FilenameUtils.getExtension((String)destinationFilePathName);
        this.governanceContext.getOpenMetadataStore().setForLineage(true);
        String topLevelProcessGUID = this.governanceContext.getOpenMetadataStore().getMetadataElementGUIDByUniqueName(this.topLevelProcessName, null);
        if (topLevelProcessGUID == null) {
            topLevelProcessGUID = this.topLevelProcessTemplateQualifiedName == null ? this.governanceContext.createProcess("DeployedConnector", ElementStatus.ACTIVE, this.topLevelProcessName, this.topLevelProcessName, null) : this.governanceContext.createProcessFromTemplate(this.topLevelProcessTemplateQualifiedName, ElementStatus.ACTIVE, this.topLevelProcessName, this.topLevelProcessName, null);
        }
        String processGUID = this.childProcessLineage ? this.governanceContext.createChildProcess("TransientEmbeddedProcess", ElementStatus.ACTIVE, this.topLevelProcessName + this.connectorInstanceId, this.topLevelProcessName, null, topLevelProcessGUID) : topLevelProcessGUID;
        if (this.sourceFileGUID == null) {
            this.sourceFileGUID = metadataStore.getMetadataElementGUIDByUniqueName(this.sourceFileName, "pathName");
            if (this.sourceFileGUID == null) {
                this.sourceFileGUID = metadataStore.getMetadataElementGUIDByUniqueName(this.sourceFileName, null);
            }
            if (!this.sourceLineageFromFile) {
                this.sourceFileGUID = this.getFolderGUID(this.sourceFileGUID);
            }
        }
        ElementProperties extendedProperties = this.propertyHelper.addStringProperty(null, "pathName", destinationFilePathName);
        extendedProperties = this.propertyHelper.addStringProperty(extendedProperties, "fileName", fileName);
        String assetTypeName = this.getAssetTypeName(fileExtension);
        if (this.destinationFileTemplateQualifiedName == null) {
            newFileGUID = this.governanceContext.createAsset(assetTypeName, assetTypeName + ":" + destinationFilePathName, fileName, null, null, extendedProperties);
        } else {
            String assetTemplateGUID = this.governanceContext.getOpenMetadataStore().getMetadataElementGUIDByUniqueName(this.destinationFileTemplateQualifiedName, null);
            newFileGUID = this.governanceContext.createAssetFromTemplate(assetTypeName, assetTemplateGUID, "CSVFile:" + destinationFilePathName, fileName, null, null, extendedProperties);
            if (assetTemplateGUID == null && this.auditLog != null) {
                this.auditLog.logMessage("createLineage", GovernanceActionConnectorsAuditCode.MISSING_TEMPLATE.getMessageDefinition(this.governanceServiceName, this.destinationFileTemplateQualifiedName, RequestParameter.DESTINATION_TEMPLATE_NAME.getName(), newFileGUID));
            }
        }
        if (!this.destinationLineageToFile) {
            newFileGUID = this.getFolderGUID(newFileGUID);
        }
        this.sourceFileGUID = this.governanceContext.getOpenMetadataStore().getMetadataElementGUIDByUniqueName(this.sourceFileName, "pathName");
        if (this.sourceFileGUID != null) {
            this.governanceContext.createLineageRelationship("DataFlow", this.sourceFileGUID, null, null, null, processGUID);
        }
        this.governanceContext.createLineageRelationship("DataFlow", processGUID, null, null, null, newFileGUID);
        metadataStore.setForLineage(false);
        if (this.auditLog != null) {
            this.auditLog.logMessage("createLineage", GovernanceActionConnectorsAuditCode.CREATED_LINEAGE.getMessageDefinition(this.governanceServiceName, this.sourceFileGUID, processGUID, newFileGUID));
        }
        return newFileGUID;
    }

    private String getFolderGUID(String fileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String folderGUID = null;
        List relatedMetadataElementList = this.governanceContext.getOpenMetadataStore().getRelatedMetadataElements(fileGUID, 2, "NestedFile", 0, 0);
        if (relatedMetadataElementList != null) {
            for (RelatedMetadataElement relatedMetadataElement : relatedMetadataElementList) {
                if (relatedMetadataElement == null) continue;
                folderGUID = relatedMetadataElement.getElement().getElementGUID();
            }
        }
        return folderGUID;
    }

    private String getAssetTypeName(String fileExtension) {
        String assetTypeName = "DataFile";
        if (fileExtension != null) {
            assetTypeName = switch (fileExtension) {
                case "csv" -> "CSVFile";
                case "json" -> "JSONFile";
                case "avro" -> "AvroFile";
                case "pdf", "doc", "docx", "ppt", "pptx", "xls", "xlsx", "md" -> "Document";
                case "jpg", "jpeg", "png", "gif", "mp3", "mp4" -> "MediaFile";
                default -> assetTypeName;
            };
        }
        return assetTypeName;
    }
}

