/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.governanceactions.provisioning;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.governanceaction.controls.RequestParameterType;

public enum RequestParameter {
    SOURCE_FILE("sourceFile", "The name of a file to process.", "string", "myFile.csv"),
    TARGET_FILE_NAME_PATTERN("targetFileNamePattern", "A string pattern to construct the name of the destination file. Two placeholders can be used: 0 is for the source file name and 1 is for an index number that increments as files are created in the directory.  If this pattern is not set, the pattern defaults to '{0}' which means the source file name is used.", "string", ""),
    SOURCE_DIRECTORY("sourceDirectory", "The name of a directory (folder) to process.", "string", "directoryA/B/C"),
    DESTINATION_DIRECTORY("destinationDirectory", "The name of a directory (folder) to add files to.", "string", "directoryA/B/C"),
    NO_LINEAGE("noLineage", "If this property is set to any value, do not produce lineage as part of the provisioning process.", "string", ""),
    TOP_LEVEL_PROCESS_NAME("topLevelProcessQualifiedName", "Qualified name to use for the top level process that represents this governance action service.  It overrides the default value of 'Egeria:MoveCopyDeleteFileGovernanceActionService'.", "string", ""),
    TOP_LEVEL_PROCESS_TEMPLATE_NAME("topLevelProcessTemplateQualifiedName", "Qualified name of the template to use for the top level process that represents this governance action service.  If it is not specified, no template is used.", "", ""),
    DESTINATION_TEMPLATE_NAME("destinationFileTemplateQualifiedName", "Qualified name of the template to use for asset that represents the destination.", "", ""),
    TOP_LEVEL_PROCESS_ONLY_LINEAGE("topLevelProcessLineageOnly", "If this property is set, lineage mappings are connected to the top level process representing this governance action service.", "", ""),
    LINEAGE_TO_DESTINATION_FOLDER_ONLY("lineageToDestinationFolderOnly", "If this property is set, the lineage relationship from the governance action service to the destination is linked to the destination folder rather than the new file in the destination folder.  Without this value, the default behavior is to show lineage from governance action process to the destination file.", "", ""),
    LINEAGE_FROM_SOURCE_FOLDER_ONLY("lineageFromSourceFolderOnly", "If this property is set, the lineage relationship from the source to the governance action service is linked from the source folder rather than the source file.  Without this value, the default behavior is to show lineage from source file to governance action process.", "", "");

    public final String name;
    public final String description;
    public final String dataType;
    public final String example;

    private RequestParameter(String name, String description, String dataType, String example) {
        this.name = name;
        this.description = description;
        this.dataType = dataType;
        this.example = example;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getExample() {
        return this.example;
    }

    public static List<RequestParameterType> getRequestParameterTypes() {
        ArrayList<RequestParameterType> requestParameterTypes = new ArrayList<RequestParameterType>();
        for (RequestParameter requestParameter : RequestParameter.values()) {
            requestParameterTypes.add(requestParameter.getRequestParameterType());
        }
        return requestParameterTypes;
    }

    public RequestParameterType getRequestParameterType() {
        RequestParameterType requestParameterType = new RequestParameterType();
        requestParameterType.setName(this.name);
        requestParameterType.setDescription(this.description);
        requestParameterType.setDataType(this.dataType);
        requestParameterType.setExample(this.example);
        return requestParameterType;
    }

    public String toString() {
        return "RequestParameter{ name=" + this.name + "}";
    }
}

