/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.governanceactions.remediation;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.adapters.connectors.governanceactions.ffdc.GovernanceActionConnectorsErrorCode;
import org.odpi.openmetadata.adapters.connectors.governanceactions.remediation.OriginSeekerGuard;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementControlHeader;
import org.odpi.openmetadata.frameworks.governanceaction.OpenMetadataStore;
import org.odpi.openmetadata.frameworks.governanceaction.RemediationGovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.AttachedClassification;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public class OriginSeekerGovernanceActionConnector
extends RemediationGovernanceActionService {
    private static final String assetOriginClassification = "AssetOrigin";
    private static final String detectedOriginsProperty = "detectedOrigins";
    private static final ObjectWriter OBJECT_WRITER = new ObjectMapper().writer();
    private final PropertyHelper propertyHelper = new PropertyHelper();

    public void start() throws ConnectorCheckedException {
        String methodName = "start";
        super.start();
        ArrayList<String> outputGuards = new ArrayList<String>();
        CompletionStatus completionStatus = null;
        HashMap<String, String> newRequestParameters = null;
        try {
            if (this.governanceContext.getActionTargetElements() == null) {
                completionStatus = OriginSeekerGuard.NO_TARGETS_DETECTED.getCompletionStatus();
                outputGuards.add(OriginSeekerGuard.NO_TARGETS_DETECTED.getName());
            } else if (this.governanceContext.getActionTargetElements().size() == 1) {
                ActionTargetElement actionTarget = (ActionTargetElement)this.governanceContext.getActionTargetElements().get(0);
                OpenMetadataElement targetElement = actionTarget.getTargetElement();
                if (this.propertyHelper.isTypeOf((ElementControlHeader)targetElement, OpenMetadataType.ASSET.typeName)) {
                    AttachedClassification existingAssetOriginClassification = this.getAssetOriginClassification(targetElement);
                    if (existingAssetOriginClassification != null) {
                        completionStatus = OriginSeekerGuard.ORIGIN_ALREADY_ASSIGNED.getCompletionStatus();
                        outputGuards.add(OriginSeekerGuard.ORIGIN_ALREADY_ASSIGNED.getName());
                    }
                    if (completionStatus == null) {
                        ArrayList<String> coveredEntityGUIDs = new ArrayList<String>();
                        coveredEntityGUIDs.add(targetElement.getElementGUID());
                        List<ElementProperties> originClassifications = this.getOrigins(targetElement, coveredEntityGUIDs);
                        if (originClassifications == null) {
                            outputGuards.add(OriginSeekerGuard.NO_ORIGINS_DETECTED.getName());
                            completionStatus = OriginSeekerGuard.NO_ORIGINS_DETECTED.getCompletionStatus();
                        } else if (originClassifications.size() == 1) {
                            this.governanceContext.classifyMetadataElement(targetElement.getElementGUID(), assetOriginClassification, false, false, originClassifications.get(0), new Date());
                            outputGuards.add(OriginSeekerGuard.ORIGIN_ASSIGNED.getName());
                            completionStatus = OriginSeekerGuard.ORIGIN_ASSIGNED.getCompletionStatus();
                        } else {
                            newRequestParameters = new HashMap<String, String>();
                            String jsonString = OBJECT_WRITER.writeValueAsString(originClassifications);
                            newRequestParameters.put(detectedOriginsProperty, jsonString);
                            outputGuards.add(OriginSeekerGuard.MULTIPLE_ORIGINS_DETECTED.getName());
                            completionStatus = OriginSeekerGuard.MULTIPLE_ORIGINS_DETECTED.getCompletionStatus();
                        }
                    }
                } else {
                    completionStatus = OriginSeekerGuard.TARGET_NOT_ASSET.getCompletionStatus();
                    outputGuards.add(OriginSeekerGuard.TARGET_NOT_ASSET.getName());
                }
            } else {
                completionStatus = OriginSeekerGuard.MULTIPLE_TARGETS_DETECTED.getCompletionStatus();
                outputGuards.add(OriginSeekerGuard.MULTIPLE_TARGETS_DETECTED.getName());
            }
            this.governanceContext.recordCompletionStatus(completionStatus, outputGuards, newRequestParameters, null);
        }
        catch (OCFCheckedExceptionBase error) {
            throw new ConnectorCheckedException(error.getReportedErrorMessage(), error);
        }
        catch (Exception error) {
            throw new ConnectorCheckedException(GovernanceActionConnectorsErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.governanceServiceName, error.getClass().getName(), error.getMessage()), error.getClass().getName(), "start", (Throwable)error);
        }
    }

    private AttachedClassification getAssetOriginClassification(OpenMetadataElement asset) {
        List existingClassifications = asset.getClassifications();
        if (existingClassifications != null) {
            for (AttachedClassification existingClassification : existingClassifications) {
                if (existingClassification == null || !assetOriginClassification.equals(existingClassification.getClassificationName())) continue;
                return existingClassification;
            }
        }
        return null;
    }

    private List<ElementProperties> getOrigins(OpenMetadataElement asset, List<String> coveredEntityGUIDs) throws Exception {
        String lineageMappingRelationshipName = "LineageMapping";
        String dataFlowRelationshipName = "DataFlow";
        String controlFlowRelationshipName = "ControlFlow";
        String processCallRelationshipName = "ProcessCall";
        ArrayList<ElementProperties> results = new ArrayList<ElementProperties>();
        String[] relationshipArray = new String[]{"LineageMapping", "DataFlow", "ControlFlow", "ProcessCall"};
        List<String> lineageRelationships = Arrays.asList(relationshipArray);
        OpenMetadataStore store = this.governanceContext.getOpenMetadataStore();
        List lineageLinks = store.getRelatedMetadataElements(asset.getElementGUID(), 2, null, 0, 0);
        if (lineageLinks != null && !lineageLinks.isEmpty()) {
            for (RelatedMetadataElement lineageLink : lineageLinks) {
                OpenMetadataElement nextAsset;
                String relationshipName;
                if (lineageLink == null || !lineageRelationships.contains(relationshipName = lineageLink.getType().getTypeName()) || coveredEntityGUIDs.contains((nextAsset = lineageLink.getElement()).getElementGUID())) continue;
                coveredEntityGUIDs.add(nextAsset.getElementGUID());
                AttachedClassification existingAssetOriginClassification = this.getAssetOriginClassification(nextAsset);
                if (existingAssetOriginClassification == null) {
                    List<ElementProperties> upstreamResults = this.getOrigins(nextAsset, coveredEntityGUIDs);
                    if (upstreamResults == null || upstreamResults.isEmpty()) continue;
                    for (ElementProperties upstreamResult : upstreamResults) {
                        if (upstreamResult == null || results.contains(upstreamResult)) continue;
                        results.add(upstreamResult);
                    }
                    continue;
                }
                if (existingAssetOriginClassification.getClassificationProperties() == null || results.contains(existingAssetOriginClassification.getClassificationProperties())) continue;
                results.add(existingAssetOriginClassification.getClassificationProperties());
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }
}

