/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.governanceactions.watchdog;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.governanceaction.controls.RequestParameterType;

public enum GenericElementRequestParameter {
    INSTANCE_TO_MONITOR("instanceToMonitor", "Requests that the governance action service monitors a single metadata instance.", "", ""),
    INTERESTING_TYPE_NAME("interestingTypeName", "Defines the type of element that this monitor is focused on.", "", ""),
    ACTION_TARGET_NAME("actionTargetName", "Override the action target name used for the element that has been created, updated or deleted.  Default is 'receivedElement'.", "", ""),
    ACTION_TARGET_TWO_NAME("actionTargetNameTwo", "Override the action target name used for the related element to the one that has been created, updated or deleted.  Default is 'receivedElementTwo'.", "", ""),
    NEW_ELEMENT_PROCESS_NAME("newElementProcessName", "Qualified name of the process to run each time a new element event is detected.", "", ""),
    UPDATED_ELEMENT_PROCESS_NAME("updatedElementProcessName", "Qualified name of the process to run each time an update element event is detected.", "", ""),
    DELETED_ELEMENT_PROCESS_NAME("deletedElementProcessName", "Qualified name of the process to run each time a delete element event is detected.", "", ""),
    CLASSIFIED_ELEMENT_PROCESS_NAME("classifiedElementProcessName", "Qualified name of the process to run each time a classified element event is detected.", "", ""),
    RECLASSIFIED_ELEMENT_PROCESS_NAME("reclassifiedElementProcessName", "Qualified name of the process to run each time a reclassified element event is detected.", "", ""),
    DECLASSIFIED_ELEMENT_PROCESS_NAME("declassifiedElementProcessName", "Qualified name of the process to run each time a declassified element event is detected.", "", ""),
    NEW_RELATIONSHIP_PROCESS_NAME("newRelationshipProcessName", "Qualified name of the process to run each time a new relationship event is detected.", "", ""),
    UPDATED_RELATIONSHIP_PROCESS_NAME("updatedRelationshipProcessName", "Qualified name of the process to run each time an updated relationship event is detected.", "", ""),
    DELETED_RELATIONSHIP_PROCESS_NAME("deletedRelationshipProcessName", "Qualified name of the process to run each time a deleted relationship event is detected.", "", ""),
    CHANGED_PROPERTIES("ChangedProperties", "A common separated list of property names that have changed values that are added to the request properties.", "", "");

    public final String name;
    public final String description;
    public final String dataType;
    public final String example;

    private GenericElementRequestParameter(String name, String description, String dataType, String example) {
        this.name = name;
        this.description = description;
        this.dataType = dataType;
        this.example = example;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getExample() {
        return this.example;
    }

    public static List<RequestParameterType> getRequestParameterTypes() {
        ArrayList<RequestParameterType> requestParameterTypes = new ArrayList<RequestParameterType>();
        for (GenericElementRequestParameter requestParameter : GenericElementRequestParameter.values()) {
            requestParameterTypes.add(requestParameter.getRequestParameterType());
        }
        return requestParameterTypes;
    }

    public RequestParameterType getRequestParameterType() {
        RequestParameterType requestParameterType = new RequestParameterType();
        requestParameterType.setName(this.name);
        requestParameterType.setDescription(this.description);
        requestParameterType.setDataType(this.dataType);
        requestParameterType.setExample(this.example);
        return requestParameterType;
    }

    public String toString() {
        return "RequestParameter{ name=" + this.name + "}";
    }
}

