/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.governanceactions.watchdog;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.governanceaction.controls.RequestTypeType;

public enum GenericElementRequestType {
    PROCESS_SINGLE_EVENT("process-single-event", "Only a single event is processed."),
    PROCESS_MULTIPLE_EVENTS("process-multiple-events", "The monitoring should go on indefinitely, processing multiple events as they occur.");

    public final String requestType;
    public final String description;

    private GenericElementRequestType(String requestType, String description) {
        this.requestType = requestType;
        this.description = description;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public String getDescription() {
        return this.description;
    }

    public static List<RequestTypeType> getRequestTypeTypes() {
        ArrayList<RequestTypeType> requestTypeTypes = new ArrayList<RequestTypeType>();
        for (GenericElementRequestType requestTypeValue : GenericElementRequestType.values()) {
            RequestTypeType requestTypeType = new RequestTypeType();
            requestTypeType.setRequestType(requestTypeValue.requestType);
            requestTypeType.setDescription(requestTypeValue.description);
            requestTypeTypes.add(requestTypeType);
        }
        return requestTypeTypes;
    }

    public RequestTypeType getRequestTypeType() {
        RequestTypeType requestTypeType = new RequestTypeType();
        requestTypeType.setRequestType(this.requestType);
        requestTypeType.setDescription(this.description);
        return requestTypeType;
    }

    public String toString() {
        return "RequestType{" + this.requestType + "}";
    }
}

