/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.governanceactions.watchdog;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.governanceaction.controls.RequestTypeType;

public enum GenericFolderRequestType {
    DIRECT_REQUEST_TYPE("watch-member-of-folder", "Monitor the file assets that are directly connected to the watched folder."),
    NESTED_REQUEST_TYPE("watch-nested-in-folder", "Monitor the file assets that are both directly connected to the watched folder and any nested folder within it.");

    public final String requestType;
    public final String description;

    private GenericFolderRequestType(String requestType, String description) {
        this.requestType = requestType;
        this.description = description;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public String getDescription() {
        return this.description;
    }

    public static List<RequestTypeType> getRequestTypeTypes() {
        ArrayList<RequestTypeType> requestTypeTypes = new ArrayList<RequestTypeType>();
        for (GenericFolderRequestType requestTypeValue : GenericFolderRequestType.values()) {
            RequestTypeType requestTypeType = new RequestTypeType();
            requestTypeType.setRequestType(requestTypeValue.requestType);
            requestTypeType.setDescription(requestTypeValue.description);
            requestTypeTypes.add(requestTypeType);
        }
        return requestTypeTypes;
    }

    public RequestTypeType getRequestTypeType() {
        RequestTypeType requestTypeType = new RequestTypeType();
        requestTypeType.setRequestType(this.requestType);
        requestTypeType.setDescription(this.description);
        return requestTypeType;
    }

    public String toString() {
        return "RequestType{" + this.requestType + "}";
    }
}

