/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.governanceactions.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageSet;

public enum GovernanceActionConnectorsErrorCode implements ExceptionMessageSet
{
    NO_SOURCE_FILE_NAME(400, "GOVERNANCE-ACTION-CONNECTORS-400-006", "The {0} governance action service has been called without a source file name to work with", "The provisioning governance action service connector is designed to manage files on request.  It is unable to operate without the name of the source file and so it terminates with a FAILED completion status.", "The source file is passed to the governance action service through the request parameters or via the TargetForAction relationship.  Correct the information passed to the governance service and rerun the request"),
    FOLDER_ELEMENT_NOT_FOUND(404, "GOVERNANCE-ACTION-CONNECTORS-404-002", "A FileFolder element with a path name of {0} is not found in the open metadata ecosystem", "The governance action service is not able to proceed until the element has been created.", "The path name of the folder is passed either in the folderName configuration property; folderName request parameters or folderTarget action target."),
    UNABLE_TO_REGISTER_LISTENER(500, "GOVERNANCE-ACTION-CONNECTORS-500-003", "The {0} governance action service received a {1} exception when it registered a listener with the governance context.  The exception's message is: {2}", "The governance action throws a GovernanceServiceException in the hope that the .", "This is likely to be a configuration error.  Review the description of the exception's message to understand what is not set up correctly and and follow its instructions."),
    UNEXPECTED_EXCEPTION(500, "GOVERNANCE-ACTION-CONNECTORS-500-004", "The {0} governance action service received an unexpected exception {1} during its processing; the error message was: {2}", "The governance action returns an exception to the Governance Action Engine.", "Use details from the error message to determine the cause of the error and retry the service call once it is resolved.");

    private final int httpErrorCode;
    private final String errorMessageId;
    private final String errorMessage;
    private final String systemAction;
    private final String userAction;

    private GovernanceActionConnectorsErrorCode(int httpErrorCode, String errorMessageId, String errorMessage, String systemAction, String userAction) {
        this.httpErrorCode = httpErrorCode;
        this.errorMessageId = errorMessageId;
        this.errorMessage = errorMessage;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public ExceptionMessageDefinition getMessageDefinition() {
        return new ExceptionMessageDefinition(this.httpErrorCode, this.errorMessageId, this.errorMessage, this.systemAction, this.userAction);
    }

    public ExceptionMessageDefinition getMessageDefinition(String ... params) {
        ExceptionMessageDefinition messageDefinition = new ExceptionMessageDefinition(this.httpErrorCode, this.errorMessageId, this.errorMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "ErrorCode{httpErrorCode=" + this.httpErrorCode + ", errorMessageId='" + this.errorMessageId + "', errorMessage='" + this.errorMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

