/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.governanceactions.provisioning;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.governanceaction.controls.GuardType;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;

public enum MoveCopyFileGuard {
    PROVISIONING_COMPLETE("provisioning-complete", CompletionStatus.ACTIONED, "The provisioning request completed successfully with no errors.  The unique identifier (guid) of the asset describing the new destination file (if applicable) is output as an action target called assetGUID."),
    PROVISIONING_FAILED_NO_FILE_NAMES("provisioning-failed-no-file-names", CompletionStatus.FAILED, "The provisioning request could not start because there were no available file names that could be used in the destination folder."),
    PROVISIONING_FAILED_EXCEPTION("provisioning-failed-exception", CompletionStatus.FAILED, "An unexpected exception occurred during the provisioning process.  Look for exceptions logged in the audit log.");

    public final String name;
    public final CompletionStatus completionStatus;
    public final String description;

    private MoveCopyFileGuard(String name, CompletionStatus completionStatus, String description) {
        this.name = name;
        this.completionStatus = completionStatus;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public CompletionStatus getCompletionStatus() {
        return this.completionStatus;
    }

    public String getDescription() {
        return this.description;
    }

    public static List<GuardType> getGuardTypes() {
        ArrayList<GuardType> guardTypes = new ArrayList<GuardType>();
        for (MoveCopyFileGuard guard : MoveCopyFileGuard.values()) {
            GuardType guardType = new GuardType();
            guardType.setGuard(guard.getName());
            guardType.setDescription(guard.getDescription());
            guardType.setCompletionStatus(guard.getCompletionStatus());
            guardTypes.add(guardType);
        }
        return guardTypes;
    }

    public GuardType getGuardType() {
        GuardType guardType = new GuardType();
        guardType.setGuard(this.name);
        guardType.setDescription(this.description);
        guardType.setCompletionStatus(this.completionStatus);
        return guardType;
    }

    public String toString() {
        return "Guard{ name='" + this.name + "}";
    }
}

