/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.governanceactions.provisioning;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.governanceaction.controls.RequestTypeType;

public enum MoveCopyFileRequestType {
    COPY_FILE("copy-file", "Requests that a file is copied from the source location to a destination folder."),
    MOVE_FILE("move-file", "Requests that a file is moved from the source location to a destination folder."),
    DELETE_FILE("delete-file", "Requests that a file is deleted from its current location.");

    public final String requestType;
    public final String description;

    private MoveCopyFileRequestType(String requestType, String description) {
        this.requestType = requestType;
        this.description = description;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public String getDescription() {
        return this.description;
    }

    public static List<RequestTypeType> getRequestTypeTypes() {
        ArrayList<RequestTypeType> requestTypeTypes = new ArrayList<RequestTypeType>();
        for (MoveCopyFileRequestType requestTypeValue : MoveCopyFileRequestType.values()) {
            RequestTypeType requestTypeType = new RequestTypeType();
            requestTypeType.setRequestType(requestTypeValue.requestType);
            requestTypeType.setDescription(requestTypeValue.description);
            requestTypeTypes.add(requestTypeType);
        }
        return requestTypeTypes;
    }

    public RequestTypeType getRequestTypeType() {
        RequestTypeType requestTypeType = new RequestTypeType();
        requestTypeType.setRequestType(this.requestType);
        requestTypeType.setDescription(this.description);
        return requestTypeType;
    }

    public String toString() {
        return "MoveCopyFileRequestType{" + this.requestType + "}";
    }
}

