/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.governanceactions.remediation;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.governanceactions.ffdc.GovernanceActionConnectorsErrorCode;
import org.odpi.openmetadata.adapters.connectors.governanceactions.remediation.OriginSeekerGuard;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.governanceaction.OpenMetadataStore;
import org.odpi.openmetadata.frameworks.governanceaction.RemediationGovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.controls.ActionTarget;
import org.odpi.openmetadata.frameworks.governanceaction.controls.Guard;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.AttachedClassification;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElementList;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementControlHeader;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public class OriginSeekerGovernanceActionConnector
extends RemediationGovernanceActionService {
    private static final String detectedOriginsProperty = "detectedOrigins";
    private static final ObjectWriter OBJECT_WRITER = new ObjectMapper().writer();

    public void start() throws ConnectorCheckedException {
        String methodName = "start";
        super.start();
        ArrayList<String> outputGuards = new ArrayList<String>();
        HashMap<String, String> newRequestParameters = new HashMap<String, String>();
        this.governanceContext.getOpenMetadataStore().setForLineage(true);
        try {
            CompletionStatus completionStatus;
            if (this.governanceContext.getActionTargetElements() == null) {
                completionStatus = Guard.NO_TARGETS_DETECTED.getCompletionStatus();
                outputGuards.add(Guard.NO_TARGETS_DETECTED.getName());
            } else {
                ArrayList<ActionTargetElement> newAssetElements = new ArrayList<ActionTargetElement>();
                for (ActionTargetElement actionTargetElement : this.governanceContext.getActionTargetElements()) {
                    if (actionTargetElement == null || actionTargetElement.getActionTargetName() == null || !actionTargetElement.getActionTargetName().equals(ActionTarget.NEW_ASSET.getName())) continue;
                    newAssetElements.add(actionTargetElement);
                }
                if (newAssetElements.size() == 1) {
                    completionStatus = this.seekOrigin((ActionTargetElement)newAssetElements.get(0), newRequestParameters, outputGuards);
                } else {
                    completionStatus = Guard.MULTIPLE_TARGETS_DETECTED.getCompletionStatus();
                    outputGuards.add(Guard.MULTIPLE_TARGETS_DETECTED.getName());
                }
            }
            if (newRequestParameters.isEmpty()) {
                newRequestParameters = null;
            }
            this.governanceContext.recordCompletionStatus(completionStatus, outputGuards, newRequestParameters, null);
        }
        catch (OCFCheckedExceptionBase error) {
            throw new ConnectorCheckedException(error.getReportedErrorMessage(), error);
        }
        catch (Exception error) {
            throw new ConnectorCheckedException(GovernanceActionConnectorsErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.governanceServiceName, error.getClass().getName(), error.getMessage()), error.getClass().getName(), "start", (Throwable)error);
        }
    }

    private CompletionStatus seekOrigin(ActionTargetElement actionTarget, Map<String, String> newRequestParameters, List<String> outputGuards) throws Exception {
        CompletionStatus completionStatus = null;
        OpenMetadataElement targetElement = actionTarget.getTargetElement();
        if (this.propertyHelper.isTypeOf((ElementControlHeader)targetElement, OpenMetadataType.ASSET.typeName)) {
            AttachedClassification existingAssetOriginClassification = this.propertyHelper.getClassification(targetElement, "AssetOrigin");
            if (existingAssetOriginClassification != null) {
                completionStatus = OriginSeekerGuard.ORIGIN_ALREADY_ASSIGNED.getCompletionStatus();
                outputGuards.add(OriginSeekerGuard.ORIGIN_ALREADY_ASSIGNED.getName());
            }
            if (completionStatus == null) {
                ArrayList<String> coveredEntityGUIDs = new ArrayList<String>();
                coveredEntityGUIDs.add(targetElement.getElementGUID());
                List<ElementProperties> originClassifications = this.getOrigins(targetElement, coveredEntityGUIDs);
                if (originClassifications == null) {
                    outputGuards.add(OriginSeekerGuard.NO_ORIGINS_DETECTED.getName());
                    completionStatus = OriginSeekerGuard.NO_ORIGINS_DETECTED.getCompletionStatus();
                } else if (originClassifications.size() == 1) {
                    this.governanceContext.classifyMetadataElement(targetElement.getElementGUID(), "AssetOrigin", false, false, originClassifications.get(0), new Date());
                    outputGuards.add(OriginSeekerGuard.ORIGIN_ASSIGNED.getName());
                    completionStatus = OriginSeekerGuard.ORIGIN_ASSIGNED.getCompletionStatus();
                } else {
                    String jsonString = OBJECT_WRITER.writeValueAsString(originClassifications);
                    newRequestParameters.put(detectedOriginsProperty, jsonString);
                    outputGuards.add(OriginSeekerGuard.MULTIPLE_ORIGINS_DETECTED.getName());
                    completionStatus = OriginSeekerGuard.MULTIPLE_ORIGINS_DETECTED.getCompletionStatus();
                }
            }
        } else {
            completionStatus = Guard.TARGET_NOT_ASSET.getCompletionStatus();
            outputGuards.add(Guard.TARGET_NOT_ASSET.getName());
        }
        return completionStatus;
    }

    private List<ElementProperties> getOrigins(OpenMetadataElement asset, List<String> coveredEntityGUIDs) throws Exception {
        String lineageMappingRelationshipName = "LineageMapping";
        String dataFlowRelationshipName = "DataFlow";
        String controlFlowRelationshipName = "ControlFlow";
        String processCallRelationshipName = "ProcessCall";
        ArrayList<ElementProperties> results = new ArrayList<ElementProperties>();
        String[] relationshipArray = new String[]{"LineageMapping", "DataFlow", "ControlFlow", "ProcessCall"};
        List<String> lineageRelationships = Arrays.asList(relationshipArray);
        OpenMetadataStore store = this.governanceContext.getOpenMetadataStore();
        RelatedMetadataElementList lineageLinks = store.getRelatedMetadataElements(asset.getElementGUID(), 2, null, 0, 0);
        if (lineageLinks != null && lineageLinks.getElementList() != null && !lineageLinks.getElementList().isEmpty()) {
            for (RelatedMetadataElement lineageLink : lineageLinks.getElementList()) {
                OpenMetadataElement nextAsset;
                String relationshipName;
                if (lineageLink == null || !lineageRelationships.contains(relationshipName = lineageLink.getType().getTypeName()) || coveredEntityGUIDs.contains((nextAsset = lineageLink.getElement()).getElementGUID())) continue;
                coveredEntityGUIDs.add(nextAsset.getElementGUID());
                AttachedClassification existingAssetOriginClassification = this.propertyHelper.getClassification(nextAsset, "AssetOrigin");
                if (existingAssetOriginClassification == null) {
                    List<ElementProperties> upstreamResults = this.getOrigins(nextAsset, coveredEntityGUIDs);
                    if (upstreamResults == null || upstreamResults.isEmpty()) continue;
                    for (ElementProperties upstreamResult : upstreamResults) {
                        if (upstreamResult == null || results.contains(upstreamResult)) continue;
                        results.add(upstreamResult);
                    }
                    continue;
                }
                if (existingAssetOriginClassification.getClassificationProperties() == null || results.contains(existingAssetOriginClassification.getClassificationProperties())) continue;
                results.add(existingAssetOriginClassification.getClassificationProperties());
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }
}

