/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.governanceactions.remediation;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.governanceaction.controls.GuardType;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;

public enum QualifiedNamePeerDuplicateGuard {
    DUPLICATE_ASSIGNED("duplicate-detected", CompletionStatus.ACTIONED, "A new duplicate was detected and linked to the element."),
    DUPLICATE_ALREADY_ASSIGNED("duplicate-already-assigned", CompletionStatus.ACTIONED, "This element already is linked to its duplicate(s)."),
    NO_DUPLICATION_DETECTED("no-duplication-detected", CompletionStatus.ACTIONED, "No duplicates were detected."),
    DUPLICATE_DETECTION_FAILED("duplicate-detection-failed", CompletionStatus.FAILED, "An unexpected error occurred during duplicate detection."),
    NO_TARGETS_DETECTED("no-targets-detected", CompletionStatus.INVALID, "There is no supplied action target and so the governance service does not know which element to work on."),
    MULTIPLE_TARGETS_DETECTED("multiple-targets-detected", CompletionStatus.INVALID, "Multiple action targets supplied.  This governance service does not support multiple action targets because the result of the origin search could be different for each action target making it difficult to automate the response.");

    public final String name;
    public final CompletionStatus completionStatus;
    public final String description;

    private QualifiedNamePeerDuplicateGuard(String name, CompletionStatus completionStatus, String description) {
        this.name = name;
        this.completionStatus = completionStatus;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public CompletionStatus getCompletionStatus() {
        return this.completionStatus;
    }

    public String getDescription() {
        return this.description;
    }

    public static List<GuardType> getGuardTypes() {
        ArrayList<GuardType> guardTypes = new ArrayList<GuardType>();
        for (QualifiedNamePeerDuplicateGuard guard : QualifiedNamePeerDuplicateGuard.values()) {
            GuardType guardType = new GuardType();
            guardType.setGuard(guard.getName());
            guardType.setDescription(guard.getDescription());
            guardType.setCompletionStatus(guard.getCompletionStatus());
            guardTypes.add(guardType);
        }
        return guardTypes;
    }

    public GuardType getGuardType() {
        GuardType guardType = new GuardType();
        guardType.setGuard(this.name);
        guardType.setDescription(this.description);
        guardType.setCompletionStatus(this.completionStatus);
        return guardType;
    }

    public String toString() {
        return "Guard{ name='" + this.name + "}";
    }
}

