/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.governanceactions.remediation;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.governanceaction.controls.GuardType;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;

public enum ZonePublisherGuard {
    ZONE_ASSIGNED("zones-assigned", CompletionStatus.ACTIONED, "The requested published zones have been added to the AssetZoneMembership classification for the asset."),
    NO_ZONES_DETECTED("no-zones-detected", CompletionStatus.ACTIONED, "The requested published zones are null so any AssetZoneMembership classification attached to the asset has been removed so the asset is now visible to all."),
    ZONE_PUBLISHING_FAILED("zone-publishing-failed", CompletionStatus.FAILED, "An unexpected exception occurred while assigning zones to the action target asset(s).");

    public final String name;
    public final CompletionStatus completionStatus;
    public final String description;

    private ZonePublisherGuard(String name, CompletionStatus completionStatus, String description) {
        this.name = name;
        this.completionStatus = completionStatus;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public CompletionStatus getCompletionStatus() {
        return this.completionStatus;
    }

    public String getDescription() {
        return this.description;
    }

    public static List<GuardType> getGuardTypes() {
        ArrayList<GuardType> guardTypes = new ArrayList<GuardType>();
        for (ZonePublisherGuard guard : ZonePublisherGuard.values()) {
            GuardType guardType = new GuardType();
            guardType.setGuard(guard.getName());
            guardType.setDescription(guard.getDescription());
            guardType.setCompletionStatus(guard.getCompletionStatus());
            guardTypes.add(guardType);
        }
        return guardTypes;
    }

    public GuardType getGuardType() {
        GuardType guardType = new GuardType();
        guardType.setGuard(this.name);
        guardType.setDescription(this.description);
        guardType.setCompletionStatus(this.completionStatus);
        return guardType;
    }

    public String toString() {
        return "Guard{ name='" + this.name + "}";
    }
}

