/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.governanceactions.stewardship;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.governanceaction.controls.GuardType;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;

public enum DaysOfWeekGuard {
    SUNDAY("sunday", CompletionStatus.ACTIONED, "Today is Sunday."),
    MONDAY("monday", CompletionStatus.ACTIONED, "Today is Monday."),
    TUESDAY("tuesday", CompletionStatus.ACTIONED, "Today is Tuesday."),
    WEDNESDAY("wednesday", CompletionStatus.ACTIONED, "Today is Wednesday."),
    THURSDAY("thursday", CompletionStatus.ACTIONED, "Today is Thursday."),
    FRIDAY("friday", CompletionStatus.ACTIONED, "Today is Friday."),
    SATURDAY("saturday", CompletionStatus.ACTIONED, "Today is Saturday.");

    public final String name;
    public final CompletionStatus completionStatus;
    public final String description;

    private DaysOfWeekGuard(String name, CompletionStatus completionStatus, String description) {
        this.name = name;
        this.completionStatus = completionStatus;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public CompletionStatus getCompletionStatus() {
        return this.completionStatus;
    }

    public String getDescription() {
        return this.description;
    }

    public static List<GuardType> getGuardTypes() {
        ArrayList<GuardType> guardTypes = new ArrayList<GuardType>();
        for (DaysOfWeekGuard guard : DaysOfWeekGuard.values()) {
            GuardType guardType = new GuardType();
            guardType.setGuard(guard.getName());
            guardType.setDescription(guard.getDescription());
            guardType.setCompletionStatus(guard.getCompletionStatus());
            guardTypes.add(guardType);
        }
        return guardTypes;
    }

    public GuardType getGuardType() {
        GuardType guardType = new GuardType();
        guardType.setGuard(this.name);
        guardType.setDescription(this.description);
        guardType.setCompletionStatus(this.completionStatus);
        return guardType;
    }

    public String toString() {
        return "Guard{ name='" + this.name + "}";
    }
}

