/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.governanceactions.stewardship;

import java.util.ArrayList;
import org.odpi.openmetadata.adapters.connectors.governanceactions.ffdc.GovernanceActionConnectorsAuditCode;
import org.odpi.openmetadata.adapters.connectors.governanceactions.ffdc.GovernanceActionConnectorsErrorCode;
import org.odpi.openmetadata.adapters.connectors.governanceactions.stewardship.ManageAssetGuard;
import org.odpi.openmetadata.adapters.connectors.governanceactions.stewardship.ManageAssetRequestParameter;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.governanceaction.GeneralGovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.controls.ActionTarget;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.NewActionTarget;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

public class DeleteAssetGovernanceActionConnector
extends GeneralGovernanceActionService {
    public void start() throws ConnectorCheckedException {
        String methodName = "start";
        super.start();
        try {
            CompletionStatus completionStatus;
            AuditLogMessageDefinition messageDefinition;
            ArrayList<String> outputGuards = new ArrayList<String>();
            ArrayList<NewActionTarget> outputActionTargets = new ArrayList<NewActionTarget>();
            String templateGUID = this.getProperty(ManageAssetRequestParameter.TEMPLATE_GUID.getName(), null);
            if (templateGUID == null) {
                messageDefinition = GovernanceActionConnectorsAuditCode.NO_TEMPLATE_GUID.getMessageDefinition(this.governanceServiceName);
                outputGuards.add(ManageAssetGuard.MISSING_TEMPLATE.getName());
                completionStatus = ManageAssetGuard.MISSING_TEMPLATE.getCompletionStatus();
            } else {
                String assetGUID = this.governanceContext.getOpenMetadataStore().getMetadataElementFromTemplate(null, null, true, null, null, templateGUID, null, this.governanceContext.getRequestParameters(), null, null, null, true);
                OpenMetadataElement assetElement = this.governanceContext.getOpenMetadataStore().getMetadataElementByGUID(assetGUID);
                messageDefinition = GovernanceActionConnectorsAuditCode.NEW_ASSET_DELETED.getMessageDefinition(this.governanceServiceName, assetElement.getType().getTypeName(), this.propertyHelper.getStringProperty(this.governanceServiceName, OpenMetadataProperty.QUALIFIED_NAME.name, assetElement.getElementProperties(), "start"), assetGUID);
                this.governanceContext.deleteMetadataElement(assetGUID, false, false, null);
                NewActionTarget newActionTarget = new NewActionTarget();
                newActionTarget.setActionTargetGUID(assetGUID);
                newActionTarget.setActionTargetName(ActionTarget.DELETED_ASSET.name);
                outputActionTargets.add(newActionTarget);
                completionStatus = ManageAssetGuard.SET_UP_COMPLETE.getCompletionStatus();
                outputGuards.add(ManageAssetGuard.SET_UP_COMPLETE.getName());
            }
            this.auditLog.logMessage("start", messageDefinition);
            if (outputActionTargets.isEmpty()) {
                outputActionTargets = null;
            }
            this.governanceContext.recordCompletionStatus(completionStatus, outputGuards, null, outputActionTargets, messageDefinition);
        }
        catch (Exception error) {
            throw new ConnectorCheckedException(GovernanceActionConnectorsErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.governanceServiceName, error.getClass().getName(), error.getMessage()), error.getClass().getName(), "start", (Throwable)error);
        }
    }
}

