/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.governanceactions.stewardship;

import java.util.ArrayList;
import org.odpi.openmetadata.adapters.connectors.governanceactions.ffdc.GovernanceActionConnectorsAuditCode;
import org.odpi.openmetadata.adapters.connectors.governanceactions.ffdc.GovernanceActionConnectorsErrorCode;
import org.odpi.openmetadata.adapters.connectors.governanceactions.stewardship.EvaluateAnnotationsGuard;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.governanceaction.GeneralGovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.controls.ActionTarget;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.NewActionTarget;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElementList;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ToDoType;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworks.surveyaction.controls.SurveyActionTarget;

public class EvaluateAnnotationsGovernanceActionConnector
extends GeneralGovernanceActionService {
    public void start() throws ConnectorCheckedException {
        String methodName = "start";
        super.start();
        try {
            CompletionStatus completionStatus;
            AuditLogMessageDefinition messageDefinition;
            ArrayList<String> outputGuards = new ArrayList<String>();
            ArrayList<NewActionTarget> outputActionTargets = new ArrayList<NewActionTarget>();
            ActionTargetElement surveyReport = null;
            String stewardGUID = null;
            if (this.governanceContext.getActionTargetElements() != null) {
                for (ActionTargetElement actionTargetElement : this.governanceContext.getActionTargetElements()) {
                    if (actionTargetElement == null) continue;
                    if (SurveyActionTarget.SURVEY_REPORT.getName().equals(actionTargetElement.getActionTargetName())) {
                        surveyReport = actionTargetElement;
                        continue;
                    }
                    if (!ActionTarget.STEWARD.getName().equals(actionTargetElement.getActionTargetName())) continue;
                    stewardGUID = actionTargetElement.getTargetElement().getElementGUID();
                }
            }
            if (surveyReport == null) {
                messageDefinition = GovernanceActionConnectorsAuditCode.NO_SURVEY_REPORT.getMessageDefinition(this.governanceServiceName);
                outputGuards.add(EvaluateAnnotationsGuard.NO_SURVEY_REPORT.getName());
                completionStatus = EvaluateAnnotationsGuard.NO_SURVEY_REPORT.getCompletionStatus();
            } else if (stewardGUID == null) {
                messageDefinition = GovernanceActionConnectorsAuditCode.NO_STEWARD.getMessageDefinition(this.governanceServiceName);
                outputGuards.add(EvaluateAnnotationsGuard.MISSING_STEWARD.getName());
                completionStatus = EvaluateAnnotationsGuard.MISSING_STEWARD.getCompletionStatus();
            } else {
                int startFrom = 0;
                int rfaCount = 0;
                RelatedMetadataElementList reportedAnnotations = this.governanceContext.getOpenMetadataStore().getRelatedMetadataElements(surveyReport.getActionTargetGUID(), 1, OpenMetadataType.REPORTED_ANNOTATION_RELATIONSHIP.typeName, startFrom, this.governanceContext.getMaxPageSize());
                while (reportedAnnotations != null && reportedAnnotations.getElementList() != null) {
                    for (RelatedMetadataElement reportedAnnotation : reportedAnnotations.getElementList()) {
                        if (reportedAnnotation == null || !reportedAnnotation.getElement().getType().getTypeName().equals(OpenMetadataType.REQUEST_FOR_ACTION_ANNOTATION.typeName)) continue;
                        ++rfaCount;
                        String toDoGUID = this.governanceContext.openToDo(this.governanceServiceName + ":" + this.connectorInstanceId, ToDoType.REQUEST_FOR_ACTION.getDescription(), "Follow the link for the request for action to discover the issue and suggested remedy.", ToDoType.REQUEST_FOR_ACTION.getName(), 0, null, stewardGUID, reportedAnnotation.getElement().getElementGUID(), ToDoType.REQUEST_FOR_ACTION.getActionTargetName());
                        if (toDoGUID == null) continue;
                        NewActionTarget actionTarget = new NewActionTarget();
                        actionTarget.setActionTargetName(SurveyActionTarget.TO_DO_ELEMENT.getName());
                        actionTarget.setActionTargetGUID(toDoGUID);
                        outputActionTargets.add(actionTarget);
                    }
                    reportedAnnotations = this.governanceContext.getOpenMetadataStore().getRelatedMetadataElements(surveyReport.getActionTargetGUID(), 1, OpenMetadataType.REPORTED_ANNOTATION_RELATIONSHIP.typeName, startFrom += this.governanceContext.getMaxPageSize(), this.governanceContext.getMaxPageSize());
                }
                messageDefinition = rfaCount == 0 ? GovernanceActionConnectorsAuditCode.NO_RFAS.getMessageDefinition(surveyReport.getTargetElement().getElementGUID()) : GovernanceActionConnectorsAuditCode.RFAS_DETECTED.getMessageDefinition(Integer.toString(rfaCount), surveyReport.getTargetElement().getElementGUID());
                completionStatus = EvaluateAnnotationsGuard.ACTIONS_ACTIONED.getCompletionStatus();
                outputGuards.add(EvaluateAnnotationsGuard.ACTIONS_ACTIONED.getName());
            }
            this.auditLog.logMessage("start", messageDefinition);
            if (outputActionTargets.isEmpty()) {
                outputActionTargets = null;
            }
            this.governanceContext.recordCompletionStatus(completionStatus, outputGuards, null, outputActionTargets, messageDefinition);
        }
        catch (Exception error) {
            throw new ConnectorCheckedException(GovernanceActionConnectorsErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.governanceServiceName, error.getClass().getName(), error.getMessage()), error.getClass().getName(), "start", (Throwable)error);
        }
    }
}

