/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.governanceactions.verification;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.governanceaction.controls.GuardType;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;

public enum VerifyAssetGuard {
    NO_ZONES("no-zones", CompletionStatus.ACTIONED, "There are no governance zones assigned to this Asset"),
    NO_OWNER("no-owner", CompletionStatus.ACTIONED, "There is no owner assigned to this Asset"),
    NO_ORIGIN("no-origin", CompletionStatus.FAILED, "There are no origin properties assigned to this Asset"),
    ZONES_ASSIGNED("zones-assigned", CompletionStatus.ACTIONED, "Governance zones are assigned to this asset."),
    OWNER_ASSIGNED("owner-assigned", CompletionStatus.ACTIONED, "An owner is assigned to this asset."),
    ORIGIN_ASSIGNED("origin-assigned", CompletionStatus.ACTIONED, "Origin properties are assigned to this asset."),
    VERIFICATION_FAILED("verification-failed", CompletionStatus.FAILED, "An unexpected error occurred during the verification process."),
    NO_TARGETS_DETECTED("no-targets-detected", CompletionStatus.INVALID, "There is no supplied action target and so the governance service does not know which asset to work on."),
    TARGET_NOT_ASSET("target-not-asset", CompletionStatus.INVALID, "The action target is not an asset."),
    MULTIPLE_TARGETS_DETECTED("multiple-targets-detected", CompletionStatus.INVALID, "Multiple action targets supplied.  This governance service does not support multiple action targets because the result of the origin search could be different for each action target making it difficult to automate the response.");

    public final String name;
    public final CompletionStatus completionStatus;
    public final String description;

    private VerifyAssetGuard(String name, CompletionStatus completionStatus, String description) {
        this.name = name;
        this.completionStatus = completionStatus;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public CompletionStatus getCompletionStatus() {
        return this.completionStatus;
    }

    public String getDescription() {
        return this.description;
    }

    public static List<GuardType> getGuardTypes() {
        ArrayList<GuardType> guardTypes = new ArrayList<GuardType>();
        for (VerifyAssetGuard guard : VerifyAssetGuard.values()) {
            GuardType guardType = new GuardType();
            guardType.setGuard(guard.getName());
            guardType.setDescription(guard.getDescription());
            guardType.setCompletionStatus(guard.getCompletionStatus());
            guardTypes.add(guardType);
        }
        return guardTypes;
    }

    public GuardType getGuardType() {
        GuardType guardType = new GuardType();
        guardType.setGuard(this.name);
        guardType.setDescription(this.description);
        guardType.setCompletionStatus(this.completionStatus);
        return guardType;
    }

    public String toString() {
        return "Guard{ name='" + this.name + "}";
    }
}

