/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.governanceactions.provisioning;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.odpi.openmetadata.adapters.connectors.governanceactions.ffdc.GovernanceActionConnectorsAuditCode;
import org.odpi.openmetadata.adapters.connectors.governanceactions.ffdc.GovernanceActionConnectorsErrorCode;
import org.odpi.openmetadata.adapters.connectors.governanceactions.provisioning.MoveCopyFileGuard;
import org.odpi.openmetadata.adapters.connectors.governanceactions.provisioning.MoveCopyFileRequestParameter;
import org.odpi.openmetadata.adapters.connectors.governanceactions.provisioning.MoveCopyFileRequestType;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.OpenMetadataStore;
import org.odpi.openmetadata.frameworks.governanceaction.ProvisioningGovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.controls.ActionTarget;
import org.odpi.openmetadata.frameworks.governanceaction.fileclassifier.FileClassification;
import org.odpi.openmetadata.frameworks.governanceaction.fileclassifier.FileClassifier;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.NewActionTarget;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElementList;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderProperty;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementStatus;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public class MoveCopyFileGovernanceActionConnector
extends ProvisioningGovernanceActionService {
    private static final Map<String, Integer> fileIndexMap = new HashMap<String, Integer>();
    private String topLevelProcessName = "Egeria:MoveCopyDeleteFileGovernanceActionService";
    private String destinationFileTemplateQualifiedName = null;
    private String topLevelProcessTemplateQualifiedName = null;
    private String destinationFileNamePattern = "{0}";
    private String sourceFileName = null;
    private String sourceFileGUID = null;
    private String destinationFolderName = null;
    private boolean copyFile = true;
    private boolean deleteFile = false;
    private boolean createLineage = true;
    private boolean sourceLineageFromFile = true;
    private boolean destinationLineageToFile = true;
    private boolean childProcessLineage = true;

    private static synchronized String getDestinationFileName(String previousDestinationFileName, String destinationFolderName, File sourceFile, String fileNamePattern) {
        int fileIndex = fileIndexMap.get(destinationFolderName) != null ? fileIndexMap.get(destinationFolderName) + 1 : 0;
        String nextDestinationFileName = fileNamePattern != null ? FilenameUtils.concat((String)destinationFolderName, (String)MessageFormat.format(fileNamePattern, sourceFile.getName(), fileIndex)) : FilenameUtils.concat((String)destinationFolderName, (String)sourceFile.getName());
        if (previousDestinationFileName != null && previousDestinationFileName.equals(nextDestinationFileName)) {
            return null;
        }
        fileIndexMap.put(destinationFolderName, fileIndex);
        return nextDestinationFileName;
    }

    private static synchronized String provisionFile(String governanceServiceName, String destinationFolderName, String sourceFilePathName, String fileNamePattern, boolean copyFile, AuditLog auditLog) throws IOException {
        String methodName = "provisionFile";
        File sourceFile = new File(sourceFilePathName);
        File destinationFolder = new File(destinationFolderName);
        if (!destinationFolder.exists()) {
            FileUtils.forceMkdir((File)destinationFolder);
        }
        String destinationFileName = MoveCopyFileGovernanceActionConnector.getDestinationFileName(null, destinationFolderName, sourceFile, fileNamePattern);
        while (destinationFileName != null) {
            File destinationFile = new File(destinationFileName);
            if (!FileUtils.directoryContains((File)destinationFolder, (File)destinationFile)) {
                if (copyFile) {
                    if (auditLog != null) {
                        auditLog.logMessage("provisionFile", GovernanceActionConnectorsAuditCode.COPY_FILE.getMessageDefinition(governanceServiceName, sourceFilePathName, destinationFileName));
                    }
                    FileUtils.copyFile((File)sourceFile, (File)destinationFile, (boolean)true);
                } else {
                    if (auditLog != null) {
                        auditLog.logMessage("provisionFile", GovernanceActionConnectorsAuditCode.MOVE_FILE.getMessageDefinition(governanceServiceName, sourceFilePathName, destinationFileName));
                    }
                    FileUtils.moveFile((File)sourceFile, (File)destinationFile);
                }
                return destinationFileName;
            }
            destinationFileName = MoveCopyFileGovernanceActionConnector.getDestinationFileName(destinationFileName, destinationFolderName, sourceFile, fileNamePattern);
        }
        if (auditLog != null) {
            auditLog.logMessage("provisionFile", GovernanceActionConnectorsAuditCode.PROVISIONING_FAILURE.getMessageDefinition(governanceServiceName, sourceFilePathName, destinationFolderName, fileNamePattern));
        }
        return null;
    }

    public void start() throws ConnectorCheckedException {
        CompletionStatus completionStatus;
        String methodName = "start";
        super.start();
        ArrayList<String> outputGuards = new ArrayList<String>();
        String completionMessage = null;
        if (MoveCopyFileRequestType.MOVE_FILE.requestType.equals(this.governanceContext.getRequestType())) {
            this.copyFile = false;
        } else if (MoveCopyFileRequestType.DELETE_FILE.requestType.equals(this.governanceContext.getRequestType())) {
            this.deleteFile = true;
        }
        Map configurationProperties = this.connectionProperties.getConfigurationProperties();
        if (configurationProperties != null) {
            Object processLineageOption;
            Object destinationLineageOption;
            Object sourceLineageOption;
            Object destinationFolderOption;
            Object fileNamePatternOption;
            Object templateNameOption;
            Object processNameOption;
            Object noLineageOption = configurationProperties.get(MoveCopyFileRequestParameter.NO_LINEAGE.getName());
            if (noLineageOption != null) {
                this.createLineage = false;
            }
            if ((processNameOption = configurationProperties.get(MoveCopyFileRequestParameter.TOP_LEVEL_PROCESS_NAME.getName())) != null) {
                this.topLevelProcessName = processNameOption.toString();
            }
            if ((templateNameOption = configurationProperties.get(MoveCopyFileRequestParameter.DESTINATION_TEMPLATE_NAME.getName())) != null) {
                this.destinationFileTemplateQualifiedName = templateNameOption.toString();
            }
            if ((templateNameOption = configurationProperties.get(MoveCopyFileRequestParameter.TOP_LEVEL_PROCESS_TEMPLATE_NAME.getName())) != null) {
                this.topLevelProcessTemplateQualifiedName = templateNameOption.toString();
            }
            if ((fileNamePatternOption = configurationProperties.get(MoveCopyFileRequestParameter.TARGET_FILE_NAME_PATTERN.getName())) != null) {
                this.destinationFileNamePattern = fileNamePatternOption.toString();
            }
            if ((destinationFolderOption = configurationProperties.get(MoveCopyFileRequestParameter.DESTINATION_DIRECTORY.getName())) != null) {
                this.destinationFolderName = destinationFolderOption.toString();
            }
            if ((sourceLineageOption = configurationProperties.get(MoveCopyFileRequestParameter.LINEAGE_FROM_SOURCE_FOLDER_ONLY.getName())) != null) {
                this.sourceLineageFromFile = false;
            }
            if ((destinationLineageOption = configurationProperties.get(MoveCopyFileRequestParameter.LINEAGE_TO_DESTINATION_FOLDER_ONLY.getName())) != null) {
                this.destinationLineageToFile = false;
            }
            if ((processLineageOption = configurationProperties.get(MoveCopyFileRequestParameter.TOP_LEVEL_PROCESS_ONLY_LINEAGE.getName())) != null) {
                this.childProcessLineage = false;
            }
        }
        if (this.governanceContext.getRequestParameters() != null) {
            Map requestParameters = this.governanceContext.getRequestParameters();
            for (String requestParameterName : requestParameters.keySet()) {
                if (MoveCopyFileRequestParameter.SOURCE_FILE.name.equals(requestParameterName)) {
                    this.sourceFileName = (String)requestParameters.get(requestParameterName);
                    continue;
                }
                if (MoveCopyFileRequestParameter.DESTINATION_DIRECTORY.name.equals(requestParameterName)) {
                    this.destinationFolderName = (String)requestParameters.get(requestParameterName);
                    continue;
                }
                if (MoveCopyFileRequestParameter.DESTINATION_TEMPLATE_NAME.getName().equals(requestParameterName)) {
                    this.destinationFileTemplateQualifiedName = (String)requestParameters.get(requestParameterName);
                    continue;
                }
                if (MoveCopyFileRequestParameter.TARGET_FILE_NAME_PATTERN.getName().equals(requestParameterName)) {
                    this.destinationFileNamePattern = (String)requestParameters.get(requestParameterName);
                    continue;
                }
                if (MoveCopyFileRequestParameter.NO_LINEAGE.getName().equals(requestParameterName)) {
                    this.createLineage = false;
                    continue;
                }
                if (MoveCopyFileRequestParameter.TOP_LEVEL_PROCESS_NAME.getName().equals(requestParameterName)) {
                    this.topLevelProcessName = (String)requestParameters.get(requestParameterName);
                    continue;
                }
                if (MoveCopyFileRequestParameter.TOP_LEVEL_PROCESS_TEMPLATE_NAME.getName().equals(requestParameterName)) {
                    this.topLevelProcessTemplateQualifiedName = (String)requestParameters.get(requestParameterName);
                    continue;
                }
                if (MoveCopyFileRequestParameter.TOP_LEVEL_PROCESS_ONLY_LINEAGE.getName().equals(requestParameterName)) {
                    this.childProcessLineage = false;
                    continue;
                }
                if (MoveCopyFileRequestParameter.LINEAGE_FROM_SOURCE_FOLDER_ONLY.getName().equals(requestParameterName)) {
                    this.sourceLineageFromFile = false;
                    continue;
                }
                if (!MoveCopyFileRequestParameter.LINEAGE_TO_DESTINATION_FOLDER_ONLY.getName().equals(requestParameterName)) continue;
                this.destinationLineageToFile = false;
            }
        }
        if (this.governanceContext.getActionTargetElements() != null) {
            for (ActionTargetElement actionTargetElement : this.governanceContext.getActionTargetElements()) {
                OpenMetadataElement destinationMetadataElement;
                if (actionTargetElement == null) continue;
                if ("sourceFile".equals(actionTargetElement.getActionTargetName())) {
                    OpenMetadataElement sourceMetadataElement = actionTargetElement.getTargetElement();
                    if (sourceMetadataElement == null) continue;
                    this.sourceFileName = this.getPathName(sourceMetadataElement);
                    this.sourceFileGUID = sourceMetadataElement.getElementGUID();
                    continue;
                }
                if (!"destinationFolder".equals(actionTargetElement.getActionTargetName()) || (destinationMetadataElement = actionTargetElement.getTargetElement()) == null) continue;
                this.destinationFolderName = this.getPathName(destinationMetadataElement);
            }
        }
        if (this.sourceFileName == null) {
            if (this.auditLog != null) {
                this.auditLog.logMessage("start", GovernanceActionConnectorsAuditCode.NO_SOURCE_FILE_NAME.getMessageDefinition(this.governanceServiceName));
            }
            throw new ConnectorCheckedException(GovernanceActionConnectorsErrorCode.NO_SOURCE_FILE_NAME.getMessageDefinition(this.governanceServiceName), ((Object)((Object)this)).getClass().getName(), "start");
        }
        ArrayList<NewActionTarget> newActionTargets = null;
        try {
            if (this.deleteFile) {
                File fileToDelete = new File(this.sourceFileName);
                FileUtils.forceDelete((File)fileToDelete);
                outputGuards.add(MoveCopyFileGuard.PROVISIONING_COMPLETE.getName());
                completionStatus = MoveCopyFileGuard.PROVISIONING_COMPLETE.getCompletionStatus();
            } else {
                String destinationFileName = MoveCopyFileGovernanceActionConnector.provisionFile(this.governanceServiceName, this.destinationFolderName, this.sourceFileName, this.destinationFileNamePattern, this.copyFile, this.auditLog);
                if (destinationFileName != null) {
                    String newActionTargetGUID = null;
                    if (this.createLineage) {
                        newActionTargetGUID = this.createLineage(destinationFileName);
                    }
                    if (newActionTargetGUID != null) {
                        newActionTargets = new ArrayList<NewActionTarget>();
                        NewActionTarget actionTarget = new NewActionTarget();
                        actionTarget.setActionTargetGUID(newActionTargetGUID);
                        actionTarget.setActionTargetName(ActionTarget.NEW_ASSET.name);
                        newActionTargets.add(actionTarget);
                    }
                    outputGuards.add(MoveCopyFileGuard.PROVISIONING_COMPLETE.getName());
                    completionStatus = MoveCopyFileGuard.PROVISIONING_COMPLETE.getCompletionStatus();
                } else {
                    outputGuards.add(MoveCopyFileGuard.PROVISIONING_FAILED_NO_FILE_NAMES.getName());
                    completionStatus = MoveCopyFileGuard.PROVISIONING_FAILED_NO_FILE_NAMES.getCompletionStatus();
                }
            }
        }
        catch (Exception error) {
            if (this.auditLog != null) {
                this.auditLog.logException("start", GovernanceActionConnectorsAuditCode.PROVISIONING_EXCEPTION.getMessageDefinition(this.governanceServiceName, error.getClass().getName(), this.sourceFileName, this.destinationFolderName, this.destinationFileNamePattern, error.getMessage()), (Throwable)error);
            }
            outputGuards.add(MoveCopyFileGuard.PROVISIONING_FAILED_EXCEPTION.getName());
            completionStatus = MoveCopyFileGuard.PROVISIONING_FAILED_EXCEPTION.getCompletionStatus();
            completionMessage = error.getMessage();
        }
        try {
            this.governanceContext.recordCompletionStatus(completionStatus, outputGuards, null, newActionTargets, completionMessage);
        }
        catch (OCFCheckedExceptionBase error) {
            throw new ConnectorCheckedException(error.getReportedErrorMessage(), error);
        }
    }

    private String getPathName(OpenMetadataElement asset) {
        String pathName;
        ElementProperties properties;
        block14: {
            String methodName = "getPathName";
            String connectionRelationshipName = "ConnectionToAsset";
            String qualifiedNameParameterName = "qualifiedName";
            String pathNameParameterName = "pathName";
            properties = asset.getElementProperties();
            pathName = this.propertyHelper.getStringProperty(this.governanceServiceName, "pathName", properties, "getPathName");
            if (pathName != null) {
                return pathName;
            }
            OpenMetadataStore store = this.governanceContext.getOpenMetadataStore();
            try {
                RelatedMetadataElementList connectionLinks = store.getRelatedMetadataElements(asset.getElementGUID(), 2, "ConnectionToAsset", 0, 0);
                if (connectionLinks == null || connectionLinks.getElementList() == null || connectionLinks.getElementList().isEmpty()) {
                    if (this.auditLog != null) {
                        this.auditLog.logMessage("getPathName", GovernanceActionConnectorsAuditCode.NO_LINKED_CONNECTION.getMessageDefinition(this.governanceServiceName, asset.getElementGUID()));
                    }
                } else if (connectionLinks.getElementList().size() > 1) {
                    for (RelatedMetadataElement connectionLink : connectionLinks.getElementList()) {
                        String networkAddress;
                        if (connectionLink == null || (networkAddress = this.getPathNameFromConnection(asset.getElementGUID(), connectionLink)) == null) continue;
                        if (pathName == null) {
                            pathName = networkAddress;
                            continue;
                        }
                        if (networkAddress.equals(pathName)) continue;
                        if (this.auditLog != null) {
                            this.auditLog.logMessage("getPathName", GovernanceActionConnectorsAuditCode.TOO_MANY_CONNECTIONS.getMessageDefinition(this.governanceServiceName, Integer.toString(connectionLinks.getElementList().size()), asset.getElementGUID(), connectionLinks.toString()));
                        }
                        pathName = null;
                        break;
                    }
                    if (pathName != null) {
                        return pathName;
                    }
                } else {
                    pathName = this.getPathNameFromConnection(asset.getElementGUID(), (RelatedMetadataElement)connectionLinks.getElementList().get(0));
                    if (pathName != null) {
                        return pathName;
                    }
                }
            }
            catch (Exception error) {
                if (this.auditLog == null) break block14;
                this.auditLog.logException("getPathName", GovernanceActionConnectorsAuditCode.ENDPOINT_EXCEPTION.getMessageDefinition(this.governanceServiceName, error.getClass().getName(), error.getMessage()), (Throwable)error);
            }
        }
        pathName = this.propertyHelper.getStringProperty(this.governanceServiceName, "qualifiedName", properties, "getPathName");
        if (this.auditLog != null) {
            this.auditLog.logMessage("getPathName", GovernanceActionConnectorsAuditCode.QUALIFIED_NAME_PATH_NAME.getMessageDefinition(this.governanceServiceName, pathName));
        }
        return pathName;
    }

    private String getPathNameFromConnection(String assetGUID, RelatedMetadataElement connectionLink) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String endpointRelationshipName = "ConnectionEndpoint";
        String endpointNetworkAddressName = "networkAddress";
        String methodName = "getPathNameFromConnection";
        OpenMetadataStore store = this.governanceContext.getOpenMetadataStore();
        OpenMetadataElement connection = connectionLink.getElement();
        if (connection == null) {
            if (this.auditLog != null) {
                this.auditLog.logMessage("getPathNameFromConnection", GovernanceActionConnectorsAuditCode.NO_RELATED_ASSET.getMessageDefinition(this.governanceServiceName, connectionLink.toString()));
            }
        } else {
            RelatedMetadataElementList endpointLinks = store.getRelatedMetadataElements(connection.getElementGUID(), 2, "ConnectionEndpoint", 0, 0);
            if (endpointLinks == null || endpointLinks.getElementList() == null || endpointLinks.getElementList().isEmpty()) {
                if (this.auditLog != null) {
                    this.auditLog.logMessage("getPathNameFromConnection", GovernanceActionConnectorsAuditCode.NO_LINKED_ENDPOINT.getMessageDefinition(this.governanceServiceName, assetGUID, connection.getElementGUID()));
                }
            } else if (endpointLinks.getElementList().size() > 1) {
                if (this.auditLog != null) {
                    this.auditLog.logMessage("getPathNameFromConnection", GovernanceActionConnectorsAuditCode.TOO_MANY_ENDPOINTS.getMessageDefinition(this.governanceServiceName, assetGUID, connection.getElementGUID(), Integer.toString(endpointLinks.getElementList().size()), endpointLinks.toString()));
                }
            } else {
                OpenMetadataElement endpoint = ((RelatedMetadataElement)endpointLinks.getElementList().get(0)).getElement();
                if (endpoint == null) {
                    if (this.auditLog != null) {
                        this.auditLog.logMessage("getPathNameFromConnection", GovernanceActionConnectorsAuditCode.NO_RELATED_ASSET.getMessageDefinition(this.governanceServiceName, ((RelatedMetadataElement)endpointLinks.getElementList().get(0)).toString()));
                    }
                } else {
                    ElementProperties properties = endpoint.getElementProperties();
                    String address = this.propertyHelper.getStringProperty(this.governanceServiceName, "networkAddress", properties, "getPathNameFromConnection");
                    if (address == null && this.auditLog != null) {
                        this.auditLog.logMessage("getPathNameFromConnection", GovernanceActionConnectorsAuditCode.NO_NETWORK_ADDRESS.getMessageDefinition(this.governanceServiceName, endpoint.getElementGUID(), connection.getElementGUID(), assetGUID));
                    }
                    return address;
                }
            }
        }
        return null;
    }

    private String createLineage(String destinationFilePathName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, IOException {
        String newFileGUID;
        String methodName = "createLineage";
        String childProcessTypeName = OpenMetadataType.TRANSIENT_EMBEDDED_PROCESS.typeName;
        String topLevelProcessTypeName = OpenMetadataType.DEPLOYED_CONNECTOR.typeName;
        OpenMetadataStore metadataStore = this.governanceContext.getOpenMetadataStore();
        FileClassifier fileClassifier = new FileClassifier(metadataStore);
        FileClassification destinationFileClassification = fileClassifier.classifyFile(destinationFilePathName);
        metadataStore.setForLineage(true);
        String topLevelProcessGUID = this.governanceContext.getOpenMetadataStore().getMetadataElementGUIDByUniqueName(this.topLevelProcessName, null);
        if (topLevelProcessGUID == null) {
            topLevelProcessGUID = this.topLevelProcessTemplateQualifiedName == null ? this.governanceContext.createProcess(topLevelProcessTypeName, ElementStatus.ACTIVE, this.topLevelProcessName, this.topLevelProcessName, null) : this.governanceContext.createProcessFromTemplate(this.topLevelProcessTemplateQualifiedName, ElementStatus.ACTIVE, this.topLevelProcessName, this.topLevelProcessName, null);
        }
        String processGUID = this.childProcessLineage ? this.governanceContext.createChildProcess(childProcessTypeName, ElementStatus.ACTIVE, this.topLevelProcessName + this.connectorInstanceId, this.topLevelProcessName, null, topLevelProcessGUID) : topLevelProcessGUID;
        if (this.sourceFileGUID == null) {
            this.sourceFileGUID = metadataStore.getMetadataElementGUIDByUniqueName(this.sourceFileName, OpenMetadataProperty.PATH_NAME.name);
            if (this.sourceFileGUID == null) {
                this.sourceFileGUID = metadataStore.getMetadataElementGUIDByUniqueName(this.sourceFileName, null);
            }
        }
        String assetTypeName = destinationFileClassification.getAssetTypeName();
        String qualifiedName = assetTypeName + ":" + destinationFilePathName;
        String parentGUID = this.governanceContext.getOpenMetadataStore().getMetadataElementGUIDByUniqueName(this.destinationFolderName, OpenMetadataProperty.PATH_NAME.name);
        if (parentGUID == null) {
            parentGUID = this.governanceContext.getOpenMetadataStore().getMetadataElementGUIDByUniqueName(this.destinationFolderName, OpenMetadataProperty.RESOURCE_NAME.name);
        }
        if (parentGUID == null) {
            parentGUID = this.governanceContext.getOpenMetadataStore().getMetadataElementGUIDByUniqueName(this.destinationFolderName, OpenMetadataProperty.NAME.name);
        }
        ElementProperties destinationFileProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName);
        destinationFileProperties = this.propertyHelper.addStringProperty(destinationFileProperties, OpenMetadataProperty.NAME.name, destinationFileClassification.getFileName());
        destinationFileProperties = this.propertyHelper.addStringProperty(destinationFileProperties, OpenMetadataProperty.RESOURCE_NAME.name, destinationFileClassification.getPathName());
        destinationFileProperties = this.propertyHelper.addStringProperty(destinationFileProperties, OpenMetadataProperty.PATH_NAME.name, destinationFileClassification.getPathName());
        destinationFileProperties = this.propertyHelper.addStringProperty(destinationFileProperties, OpenMetadataProperty.FILE_NAME.name, destinationFileClassification.getFileName());
        destinationFileProperties = this.propertyHelper.addStringProperty(destinationFileProperties, OpenMetadataProperty.FILE_TYPE.name, destinationFileClassification.getFileType());
        destinationFileProperties = this.propertyHelper.addStringProperty(destinationFileProperties, OpenMetadataProperty.FILE_EXTENSION.name, destinationFileClassification.getFileExtension());
        destinationFileProperties = this.propertyHelper.addStringProperty(destinationFileProperties, OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, destinationFileClassification.getDeployedImplementationType());
        if (this.destinationFileTemplateQualifiedName != null) {
            String assetTemplateGUID = this.governanceContext.getOpenMetadataStore().getMetadataElementGUIDByUniqueName(this.destinationFileTemplateQualifiedName, OpenMetadataProperty.QUALIFIED_NAME.name);
            if (assetTemplateGUID == null && this.auditLog != null) {
                this.auditLog.logMessage("createLineage", GovernanceActionConnectorsAuditCode.MISSING_TEMPLATE.getMessageDefinition(this.governanceServiceName, this.destinationFileTemplateQualifiedName, MoveCopyFileRequestParameter.DESTINATION_TEMPLATE_NAME.getName()));
            }
            HashMap<String, String> placeholderProperties = new HashMap<String, String>();
            placeholderProperties.put(PlaceholderProperty.FILE_PATH_NAME.getName(), destinationFileClassification.getPathName());
            placeholderProperties.put(PlaceholderProperty.FILE_TYPE.getName(), destinationFileClassification.getFileType());
            placeholderProperties.put(PlaceholderProperty.FILE_EXTENSION.getName(), destinationFileClassification.getFileExtension());
            placeholderProperties.put(PlaceholderProperty.FILE_NAME.getName(), destinationFileClassification.getFileName());
            if (destinationFileClassification.getCreationTime() != null) {
                placeholderProperties.put(PlaceholderProperty.CREATION_DATE.getName(), destinationFileClassification.getCreationTime().toString());
                placeholderProperties.put(PlaceholderProperty.RECEIVED_DATE.getName(), destinationFileClassification.getCreationTime().toString());
            } else {
                placeholderProperties.put(PlaceholderProperty.CREATION_DATE.getName(), "");
                placeholderProperties.put(PlaceholderProperty.RECEIVED_DATE.getName(), "");
            }
            if (destinationFileClassification.getLastModifiedTime() != null) {
                placeholderProperties.put(PlaceholderProperty.LAST_UPDATE_DATE.getName(), destinationFileClassification.getLastModifiedTime().toString());
            } else {
                placeholderProperties.put(PlaceholderProperty.LAST_UPDATE_DATE.getName(), "");
            }
            if (destinationFileClassification.getLastAccessedTime() != null) {
                placeholderProperties.put(PlaceholderProperty.LAST_ACCESSED_DATE.getName(), destinationFileClassification.getLastAccessedTime().toString());
            } else {
                placeholderProperties.put(PlaceholderProperty.LAST_ACCESSED_DATE.getName(), "");
            }
            newFileGUID = metadataStore.createMetadataElementFromTemplate(assetTypeName, null, true, null, null, assetTemplateGUID, null, placeholderProperties, parentGUID, OpenMetadataType.NESTED_FILE_RELATIONSHIP.typeName, null, true);
        } else {
            newFileGUID = metadataStore.createMetadataElementInStore(assetTypeName, ElementStatus.ACTIVE, null, null, true, null, null, destinationFileProperties, parentGUID, OpenMetadataType.NESTED_FILE_RELATIONSHIP.typeName, null, true);
        }
        if (!this.destinationLineageToFile) {
            newFileGUID = this.getFolderGUID(newFileGUID);
        }
        if (!this.sourceLineageFromFile) {
            this.sourceFileGUID = this.getFolderGUID(this.sourceFileGUID);
        }
        if (this.sourceFileGUID != null) {
            this.governanceContext.createLineageRelationship(OpenMetadataType.DATA_FLOW.typeName, this.sourceFileGUID, null, null, null, null, processGUID);
        }
        this.governanceContext.createLineageRelationship(OpenMetadataType.DATA_FLOW.typeName, processGUID, null, null, null, null, newFileGUID);
        metadataStore.setForLineage(false);
        if (this.auditLog != null) {
            this.auditLog.logMessage("createLineage", GovernanceActionConnectorsAuditCode.CREATED_LINEAGE.getMessageDefinition(this.governanceServiceName, this.sourceFileGUID, processGUID, newFileGUID));
        }
        return newFileGUID;
    }

    private String getFolderGUID(String fileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String folderGUID = null;
        RelatedMetadataElementList relatedMetadataElementList = this.governanceContext.getOpenMetadataStore().getRelatedMetadataElements(fileGUID, 2, OpenMetadataType.NESTED_FILE_RELATIONSHIP.typeName, 0, 0);
        if (relatedMetadataElementList != null && relatedMetadataElementList.getElementList() != null) {
            for (RelatedMetadataElement relatedMetadataElement : relatedMetadataElementList.getElementList()) {
                if (relatedMetadataElement == null) continue;
                folderGUID = relatedMetadataElement.getElement().getElementGUID();
            }
        }
        return folderGUID;
    }
}

