/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.governanceactions.remediation;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.governanceactions.ffdc.GovernanceActionConnectorsAuditCode;
import org.odpi.openmetadata.adapters.connectors.governanceactions.ffdc.GovernanceActionConnectorsErrorCode;
import org.odpi.openmetadata.adapters.connectors.governanceactions.remediation.RetentionClassifierGuard;
import org.odpi.openmetadata.adapters.connectors.governanceactions.remediation.RetentionClassifierRequestParameter;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.governanceaction.RemediationGovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.controls.ActionTarget;
import org.odpi.openmetadata.frameworks.governanceaction.controls.Guard;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GovernanceClassificationStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.RetentionBasis;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementControlHeader;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public class RetentionClassifierGovernanceActionConnector
extends RemediationGovernanceActionService {
    private final int confidence = 100;
    private int statusIdentifier = GovernanceClassificationStatus.VALIDATED.getOrdinal();
    private int basisIdentifier = RetentionBasis.REGULATED_LIFETIME.getOrdinal();
    private long timeToArchive = 157784760000L;
    private long timeToDelete = 473354280000L;
    private String stewardGUID = null;
    private String stewardTypeName = null;

    public void start() throws ConnectorCheckedException {
        String methodName = "start";
        super.start();
        if (this.governanceContext.getRequestParameters() != null) {
            Map requestParameters = this.governanceContext.getRequestParameters();
            for (String requestParameterName : requestParameters.keySet()) {
                if (requestParameterName == null) continue;
                if (RetentionClassifierRequestParameter.STATUS_IDENTIFIER.getName().equals(requestParameterName)) {
                    this.statusIdentifier = this.getIntRequestParameter(RetentionClassifierRequestParameter.STATUS_IDENTIFIER.getName(), requestParameters);
                    continue;
                }
                if (RetentionClassifierRequestParameter.BASIS_IDENTIFIER.getName().equals(requestParameterName)) {
                    this.basisIdentifier = this.getIntRequestParameter(RetentionClassifierRequestParameter.BASIS_IDENTIFIER.getName(), requestParameters);
                    continue;
                }
                if (RetentionClassifierRequestParameter.RETENTION_TIME_TO_ARCHIVE.getName().equals(requestParameterName)) {
                    this.timeToArchive = this.getLongRequestParameter(RetentionClassifierRequestParameter.RETENTION_TIME_TO_ARCHIVE.getName(), requestParameters);
                    continue;
                }
                if (!RetentionClassifierRequestParameter.RETENTION_TIME_TO_DELETE.getName().equals(requestParameterName)) continue;
                this.timeToDelete = this.getLongRequestParameter(RetentionClassifierRequestParameter.RETENTION_TIME_TO_DELETE.getName(), requestParameters);
            }
        }
        ArrayList<String> outputGuards = new ArrayList<String>();
        AuditLogMessageDefinition messageDefinition = null;
        try {
            CompletionStatus completionStatus;
            if (this.governanceContext.getActionTargetElements() == null) {
                messageDefinition = GovernanceActionConnectorsAuditCode.NO_TARGETS.getMessageDefinition(this.governanceServiceName);
                completionStatus = Guard.NO_TARGETS_DETECTED.getCompletionStatus();
                outputGuards.add(Guard.NO_TARGETS_DETECTED.getName());
            } else {
                for (ActionTargetElement actionTarget : this.governanceContext.getActionTargetElements()) {
                    if (actionTarget == null || !ActionTarget.STEWARD.getName().equals(actionTarget.getActionTargetName())) continue;
                    this.stewardGUID = actionTarget.getTargetElement().getElementGUID();
                    this.stewardTypeName = actionTarget.getTargetElement().getType().getTypeName();
                }
                if (this.stewardGUID == null) {
                    messageDefinition = GovernanceActionConnectorsAuditCode.NO_STEWARD.getMessageDefinition(this.governanceServiceName);
                    outputGuards.add(RetentionClassifierGuard.MISSING_STEWARD.getName());
                    completionStatus = RetentionClassifierGuard.MISSING_STEWARD.getCompletionStatus();
                } else {
                    Date now = new Date();
                    Date dateToArchive = new Date(now.getTime() + this.timeToArchive);
                    Date dateToDelete = new Date(now.getTime() + this.timeToDelete);
                    ElementProperties properties = this.getRetentionProperties(dateToArchive, dateToDelete);
                    for (ActionTargetElement actionTarget : this.governanceContext.getActionTargetElements()) {
                        if (actionTarget == null || actionTarget.getTargetElement() == null || !ActionTarget.NEW_ASSET.getName().equals(actionTarget.getActionTargetName()) || !this.propertyHelper.isTypeOf((ElementControlHeader)actionTarget.getTargetElement(), OpenMetadataType.ASSET.typeName)) continue;
                        OpenMetadataElement element = actionTarget.getTargetElement();
                        this.auditLog.logMessage("start", GovernanceActionConnectorsAuditCode.SETTING_RETENTION.getMessageDefinition(this.governanceServiceName, element.getElementGUID(), dateToArchive.toString(), dateToDelete.toString()));
                        this.governanceContext.classifyMetadataElement(element.getElementGUID(), OpenMetadataType.RETENTION_CLASSIFICATION.typeName, false, false, properties, new Date());
                    }
                    completionStatus = RetentionClassifierGuard.CLASSIFICATION_ASSIGNED.getCompletionStatus();
                    outputGuards.add(RetentionClassifierGuard.CLASSIFICATION_ASSIGNED.getName());
                }
            }
            if (messageDefinition != null) {
                this.auditLog.logMessage("start", messageDefinition);
            }
            this.governanceContext.recordCompletionStatus(completionStatus, outputGuards, null, null, messageDefinition);
        }
        catch (OCFCheckedExceptionBase error) {
            throw new ConnectorCheckedException(error.getReportedErrorMessage(), error);
        }
        catch (Exception error) {
            throw new ConnectorCheckedException(GovernanceActionConnectorsErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.governanceServiceName, error.getClass().getName(), error.getMessage()), error.getClass().getName(), "start", (Throwable)error);
        }
    }

    private ElementProperties getRetentionProperties(Date dateToArchive, Date dateToDelete) {
        ElementProperties elementProperties = this.propertyHelper.addIntProperty(null, OpenMetadataProperty.STATUS_IDENTIFIER.name, this.statusIdentifier);
        elementProperties = this.propertyHelper.addIntProperty(elementProperties, OpenMetadataProperty.CONFIDENCE.name, 100);
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.STEWARD.name, this.stewardGUID);
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.STEWARD_TYPE_NAME.name, this.stewardTypeName);
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.STEWARD_PROPERTY_NAME.name, OpenMetadataProperty.GUID.name);
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.SOURCE.name, this.governanceServiceName);
        elementProperties = this.propertyHelper.addIntProperty(elementProperties, OpenMetadataProperty.RETENTION_BASIS_IDENTIFIER.name, this.basisIdentifier);
        elementProperties = this.propertyHelper.addDateProperty(elementProperties, "archiveAfter", dateToArchive);
        elementProperties = this.propertyHelper.addDateProperty(elementProperties, "deleteAfter", dateToDelete);
        return elementProperties;
    }
}

