/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.governanceactions.watchdog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.governanceactions.ffdc.GovernanceActionConnectorsAuditCode;
import org.odpi.openmetadata.adapters.connectors.governanceactions.ffdc.GovernanceActionConnectorsErrorCode;
import org.odpi.openmetadata.adapters.connectors.governanceactions.watchdog.GenericFolderRequestParameter;
import org.odpi.openmetadata.adapters.connectors.governanceactions.watchdog.GenericFolderRequestType;
import org.odpi.openmetadata.adapters.connectors.governanceactions.watchdog.GenericWatchdogGovernanceActionConnector;
import org.odpi.openmetadata.adapters.connectors.governanceactions.watchdog.GenericWatchdogGuard;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.GovernanceContext;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogClassificationEvent;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogEventType;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogGovernanceEvent;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogMetadataElementEvent;
import org.odpi.openmetadata.frameworks.governanceaction.ffdc.GovernanceServiceException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.NewActionTarget;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElementList;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public class GenericFolderWatchdogGovernanceActionConnector
extends GenericWatchdogGovernanceActionConnector {
    private String folderName = null;
    private String folderGUID = null;

    public void start() throws ConnectorCheckedException {
        List actionTargetElements;
        Object folderNameOption;
        String methodName = "start";
        super.validateContext((GovernanceContext)this.governanceContext);
        Map configurationProperties = this.connectionProperties.getConfigurationProperties();
        if (configurationProperties != null && (folderNameOption = configurationProperties.get(GenericFolderRequestParameter.FOLDER_NAME.getName())) != null) {
            this.folderName = folderNameOption.toString();
        }
        if (this.governanceContext.getRequestParameters() != null) {
            Map requestParameters = this.governanceContext.getRequestParameters();
            for (String requestParameterName : requestParameters.keySet()) {
                if (requestParameterName == null || !GenericFolderRequestParameter.FOLDER_NAME.getName().equals(requestParameterName)) continue;
                this.folderName = (String)requestParameters.get(requestParameterName);
            }
        }
        if ((actionTargetElements = this.governanceContext.getActionTargetElements()) != null) {
            for (ActionTargetElement actionTargetElement : actionTargetElements) {
                if (actionTargetElement == null || !"watchedFolder".equals(actionTargetElement.getActionTargetName())) continue;
                this.folderGUID = actionTargetElement.getActionTargetGUID();
            }
        }
        if (this.folderGUID == null && this.folderName != null) {
            try {
                this.folderGUID = this.governanceContext.getOpenMetadataStore().getMetadataElementGUIDByUniqueName(this.folderName, OpenMetadataProperty.PATH_NAME.name);
                if (this.folderGUID == null) {
                    throw new InvalidParameterException(GovernanceActionConnectorsErrorCode.FOLDER_ELEMENT_NOT_FOUND.getMessageDefinition(this.folderName), ((Object)((Object)this)).getClass().getName(), "start", OpenMetadataProperty.PATH_NAME.name);
                }
            }
            catch (OCFCheckedExceptionBase error) {
                throw new ConnectorCheckedException(error.getMessage(), error);
            }
        }
        super.start("DataFile");
    }

    @Override
    void processEvent(WatchdogGovernanceEvent event) throws GovernanceServiceException {
        block25: {
            String methodName = "processEvent";
            if (!this.completed) {
                block24: {
                    try {
                        if (event instanceof WatchdogMetadataElementEvent) {
                            WatchdogMetadataElementEvent metadataElementEvent = (WatchdogMetadataElementEvent)event;
                            String fileGUID = metadataElementEvent.getMetadataElement().getElementGUID();
                            if (this.matchFolderToFileName(metadataElementEvent.getMetadataElement().getElementProperties()) || this.fileInFolder(fileGUID)) {
                                HashMap<String, String> requestParameters = this.governanceContext.getRequestParameters();
                                if (requestParameters == null) {
                                    requestParameters = new HashMap<String, String>();
                                }
                                ArrayList<NewActionTarget> actionTargets = new ArrayList<NewActionTarget>();
                                NewActionTarget actionTarget = new NewActionTarget();
                                actionTarget.setActionTargetGUID(fileGUID);
                                actionTarget.setActionTargetName(this.actionTargetName);
                                actionTargets.add(actionTarget);
                                if (metadataElementEvent.getEventType() == WatchdogEventType.NEW_ELEMENT) {
                                    this.initiateProcess(this.newElementProcessName, requestParameters, actionTargets);
                                } else if (metadataElementEvent.getEventType() == WatchdogEventType.UPDATED_ELEMENT_PROPERTIES) {
                                    ElementProperties previousElementProperties = null;
                                    if (metadataElementEvent.getPreviousMetadataElement() != null) {
                                        previousElementProperties = metadataElementEvent.getPreviousMetadataElement().getElementProperties();
                                    }
                                    requestParameters.put("ChangedProperties", this.diffProperties(previousElementProperties, metadataElementEvent.getMetadataElement().getElementProperties()));
                                    this.initiateProcess(this.updatedElementProcessName, requestParameters, actionTargets);
                                } else if (metadataElementEvent.getEventType() == WatchdogEventType.DELETED_ELEMENT) {
                                    this.initiateProcess(this.deletedElementProcessName, requestParameters, actionTargets);
                                } else {
                                    WatchdogClassificationEvent classificationEvent = (WatchdogClassificationEvent)event;
                                    requestParameters.put("ClassificationName", classificationEvent.getChangedClassification().getClassificationName());
                                    if (metadataElementEvent.getEventType() == WatchdogEventType.NEW_CLASSIFICATION) {
                                        this.initiateProcess(this.classifiedElementProcessName, requestParameters, actionTargets);
                                    } else if (metadataElementEvent.getEventType() == WatchdogEventType.UPDATED_CLASSIFICATION_PROPERTIES) {
                                        ElementProperties previousElementProperties = null;
                                        if (classificationEvent.getPreviousClassification() != null) {
                                            previousElementProperties = classificationEvent.getPreviousClassification().getClassificationProperties();
                                        }
                                        requestParameters.put("ChangedProperties", this.diffProperties(previousElementProperties, classificationEvent.getChangedClassification().getClassificationProperties()));
                                        this.initiateProcess(this.reclassifiedElementProcessName, requestParameters, actionTargets);
                                    } else if (metadataElementEvent.getEventType() == WatchdogEventType.DELETED_CLASSIFICATION) {
                                        this.initiateProcess(this.declassifiedElementProcessName, requestParameters, actionTargets);
                                    }
                                }
                            }
                        }
                    }
                    catch (Exception error) {
                        try {
                            ArrayList<String> outputGuards = new ArrayList<String>();
                            outputGuards.add(GenericWatchdogGuard.MONITORING_FAILED.getName());
                            this.governanceContext.recordCompletionStatus(GenericWatchdogGuard.MONITORING_FAILED.getCompletionStatus(), outputGuards, null, null, error.getMessage());
                        }
                        catch (Exception completionError) {
                            if (this.auditLog == null) break block24;
                            this.auditLog.logException("processEvent", GovernanceActionConnectorsAuditCode.UNABLE_TO_SET_COMPLETION_STATUS.getMessageDefinition(this.governanceServiceName, completionError.getClass().getName(), completionError.getMessage()), (Throwable)error);
                        }
                    }
                }
                if (this.completed) {
                    try {
                        ArrayList<String> outputGuards = new ArrayList<String>();
                        outputGuards.add(GenericWatchdogGuard.MONITORING_STOPPED.getName());
                        this.governanceContext.recordCompletionStatus(GenericWatchdogGuard.MONITORING_STOPPED.getCompletionStatus(), outputGuards);
                    }
                    catch (Exception error) {
                        if (this.auditLog == null) break block25;
                        this.auditLog.logException("processEvent", GovernanceActionConnectorsAuditCode.UNABLE_TO_SET_COMPLETION_STATUS.getMessageDefinition(this.governanceServiceName, error.getClass().getName(), error.getMessage()), (Throwable)error);
                    }
                }
            }
        }
    }

    private boolean matchFolderToFileName(ElementProperties elementProperties) {
        String methodName = "matchFolderToFileName";
        if (this.folderName == null) {
            return true;
        }
        String fullPathName = this.propertyHelper.getStringProperty(this.governanceServiceName, OpenMetadataProperty.PATH_NAME.name, elementProperties, "matchFolderToFileName");
        if (fullPathName == null) {
            return false;
        }
        if (!fullPathName.startsWith(this.folderName)) {
            return false;
        }
        if (GenericFolderRequestType.NESTED_REQUEST_TYPE.getRequestType().equals(this.governanceContext.getRequestType())) {
            return true;
        }
        if (GenericFolderRequestType.DIRECT_REQUEST_TYPE.getRequestType().equals(this.governanceContext.getRequestType())) {
            String[] splitFileName = fullPathName.split("/");
            String[] splitHigh = this.folderName.split("/");
            return splitHigh.length == splitFileName.length - 1;
        }
        return false;
    }

    private boolean fileInFolder(String fileGUID) throws GovernanceServiceException {
        try {
            String parentFolderGUID = this.getFolderGUID(fileGUID, OpenMetadataType.NESTED_FILE_RELATIONSHIP.typeName);
            if (GenericFolderRequestType.DIRECT_REQUEST_TYPE.getRequestType().equals(this.governanceContext.getRequestType())) {
                if (parentFolderGUID != null) {
                    return parentFolderGUID.equals(this.folderGUID);
                }
            } else {
                while (parentFolderGUID != null) {
                    if (parentFolderGUID.equals(this.folderGUID)) {
                        return true;
                    }
                    parentFolderGUID = this.getFolderGUID(parentFolderGUID, OpenMetadataType.FOLDER_HIERARCHY_RELATIONSHIP.typeName);
                }
            }
            return false;
        }
        catch (OCFCheckedExceptionBase error) {
            throw new GovernanceServiceException(error.getMessage(), error);
        }
    }

    private String getFolderGUID(String fileGUID, String relationshipName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String folderGUID = null;
        RelatedMetadataElementList relatedMetadataElementList = this.governanceContext.getOpenMetadataStore().getRelatedMetadataElements(fileGUID, 2, relationshipName, 0, 0);
        if (relatedMetadataElementList == null) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            relatedMetadataElementList = this.governanceContext.getOpenMetadataStore().getRelatedMetadataElements(fileGUID, 2, relationshipName, 0, 0);
        }
        if (relatedMetadataElementList != null && relatedMetadataElementList.getElementList() != null) {
            for (RelatedMetadataElement relatedMetadataElement : relatedMetadataElementList.getElementList()) {
                if (relatedMetadataElement == null) continue;
                folderGUID = relatedMetadataElement.getElement().getElementGUID();
            }
        }
        return folderGUID;
    }

    @Override
    public void disconnect() throws ConnectorCheckedException {
        super.disconnect();
    }
}

