/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.governanceactions.remediation;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.governanceaction.controls.GuardType;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;

public enum OriginSeekerGuard {
    ORIGIN_ASSIGNED("origin-assigned", CompletionStatus.ACTIONED, "The AssetOrigin classification has been successfully assigned to the asset."),
    ORIGIN_ALREADY_ASSIGNED("origin-already-assigned", CompletionStatus.ACTIONED, "The asset already has an AssetOrigin classification so no action was required."),
    MULTIPLE_ORIGINS_DETECTED("multiple-origins-detected", CompletionStatus.INVALID, "The lineage graph showed that the data in the asset came from multiple origins.  A steward needs to assign the AssetOrigin because it is not obvious which values to use."),
    NO_ORIGINS_DETECTED("no-origins-detected", CompletionStatus.INVALID, "None of the assets in the lineage graph have an AssetOrigin classification."),
    ORIGIN_SEEKING_FAILED("origin-seeking-failed", CompletionStatus.FAILED, "An unexpected error occurred during the origin seeking process.  Check the audit log for reported errors.");

    public final String name;
    public final CompletionStatus completionStatus;
    public final String description;

    private OriginSeekerGuard(String name, CompletionStatus completionStatus, String description) {
        this.name = name;
        this.completionStatus = completionStatus;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public CompletionStatus getCompletionStatus() {
        return this.completionStatus;
    }

    public String getDescription() {
        return this.description;
    }

    public static List<GuardType> getGuardTypes() {
        ArrayList<GuardType> guardTypes = new ArrayList<GuardType>();
        for (OriginSeekerGuard guard : OriginSeekerGuard.values()) {
            GuardType guardType = new GuardType();
            guardType.setGuard(guard.getName());
            guardType.setDescription(guard.getDescription());
            guardType.setCompletionStatus(guard.getCompletionStatus());
            guardTypes.add(guardType);
        }
        return guardTypes;
    }

    public GuardType getGuardType() {
        GuardType guardType = new GuardType();
        guardType.setGuard(this.name);
        guardType.setDescription(this.description);
        guardType.setCompletionStatus(this.completionStatus);
        return guardType;
    }

    public String toString() {
        return "Guard{ name='" + this.name + "}";
    }
}

