/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.governanceactions.remediation;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.adapters.connectors.governanceactions.ffdc.GovernanceActionConnectorsErrorCode;
import org.odpi.openmetadata.adapters.connectors.governanceactions.remediation.QualifiedNamePeerDuplicateGuard;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.governanceaction.OpenMetadataStore;
import org.odpi.openmetadata.frameworks.governanceaction.RemediationGovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.controls.Guard;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.OMFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.search.MatchCriteria;
import org.odpi.openmetadata.frameworks.openmetadata.search.PrimitiveTypeCategory;
import org.odpi.openmetadata.frameworks.openmetadata.search.PrimitiveTypePropertyValue;
import org.odpi.openmetadata.frameworks.openmetadata.search.PropertyComparisonOperator;
import org.odpi.openmetadata.frameworks.openmetadata.search.PropertyCondition;
import org.odpi.openmetadata.frameworks.openmetadata.search.PropertyValue;
import org.odpi.openmetadata.frameworks.openmetadata.search.SearchProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

public class QualifiedNamePeerDuplicateGovernanceActionConnector
extends RemediationGovernanceActionService {
    public void start() throws ConnectorCheckedException {
        String methodName = "start";
        super.start();
        ArrayList<String> outputGuards = new ArrayList<String>();
        CompletionStatus completionStatus = CompletionStatus.INVALID;
        try {
            if (this.governanceContext.getActionTargetElements() == null) {
                outputGuards.add(Guard.NO_TARGETS_DETECTED.getName());
                completionStatus = Guard.NO_TARGETS_DETECTED.getCompletionStatus();
            } else if (this.governanceContext.getActionTargetElements().size() == 1) {
                ActionTargetElement actionTarget = (ActionTargetElement)this.governanceContext.getActionTargetElements().get(0);
                OpenMetadataElement targetElement = actionTarget.getTargetElement();
                OpenMetadataStore store = this.governanceContext.getOpenMetadataStore();
                store.setForDuplicateProcessing(true);
                store.setForLineage(true);
                String qualifiedName = ((PropertyValue)targetElement.getElementProperties().getPropertyValueMap().get(OpenMetadataProperty.QUALIFIED_NAME.name)).valueAsString();
                SearchProperties searchProperties = this.getSearchProperties(qualifiedName);
                List elements = store.findMetadataElements(targetElement.getType().getTypeId(), null, searchProperties, null, null, null, null, null, 0, 0);
                if (elements != null) {
                    String targetElementGUID = targetElement.getElementGUID();
                    if (elements.size() == 1 && ((OpenMetadataElement)elements.get(0)).getElementGUID().equalsIgnoreCase(targetElementGUID)) {
                        outputGuards.add(QualifiedNamePeerDuplicateGuard.NO_DUPLICATION_DETECTED.getName());
                        completionStatus = QualifiedNamePeerDuplicateGuard.NO_DUPLICATION_DETECTED.getCompletionStatus();
                    }
                    for (OpenMetadataElement duplicateAsset : elements) {
                        String duplicateAssetGUID = duplicateAsset.getElementGUID();
                        if (duplicateAssetGUID.equalsIgnoreCase(targetElementGUID)) continue;
                        this.governanceContext.linkElementsAsPeerDuplicates(targetElementGUID, duplicateAssetGUID, 1, null, null, null, null, null, true);
                        outputGuards.add(QualifiedNamePeerDuplicateGuard.DUPLICATE_ASSIGNED.getName());
                        completionStatus = QualifiedNamePeerDuplicateGuard.DUPLICATE_ASSIGNED.getCompletionStatus();
                        break;
                    }
                }
            } else {
                outputGuards.add(Guard.MULTIPLE_TARGETS_DETECTED.getName());
                completionStatus = Guard.MULTIPLE_TARGETS_DETECTED.getCompletionStatus();
            }
            this.governanceContext.recordCompletionStatus(completionStatus, outputGuards);
        }
        catch (OMFCheckedExceptionBase error) {
            throw new ConnectorCheckedException(error.getReportedErrorMessage(), error);
        }
        catch (Exception error) {
            throw new ConnectorCheckedException(GovernanceActionConnectorsErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.governanceServiceName, error.getClass().getName(), error.getMessage()), error.getClass().getName(), "start", error);
        }
    }

    private SearchProperties getSearchProperties(String qualifiedName) {
        SearchProperties searchProperties = new SearchProperties();
        ArrayList<PropertyCondition> conditions = new ArrayList<PropertyCondition>();
        PropertyCondition condition = new PropertyCondition();
        PrimitiveTypePropertyValue primitivePropertyValue = new PrimitiveTypePropertyValue();
        primitivePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING);
        primitivePropertyValue.setPrimitiveValue((Object)qualifiedName);
        primitivePropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING.getName());
        condition.setProperty(OpenMetadataProperty.QUALIFIED_NAME.name);
        condition.setOperator(PropertyComparisonOperator.EQ);
        condition.setValue((PropertyValue)primitivePropertyValue);
        conditions.add(condition);
        searchProperties.setConditions(conditions);
        searchProperties.setMatchCriteria(MatchCriteria.ALL);
        return searchProperties;
    }
}

