/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.governanceactions.remediation;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.odpi.openmetadata.adapters.connectors.governanceactions.ffdc.GovernanceActionConnectorsAuditCode;
import org.odpi.openmetadata.adapters.connectors.governanceactions.ffdc.GovernanceActionConnectorsErrorCode;
import org.odpi.openmetadata.adapters.connectors.governanceactions.remediation.ZonePublisherGuard;
import org.odpi.openmetadata.adapters.connectors.governanceactions.remediation.ZonePublisherRequestParameter;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.governanceaction.RemediationGovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.controls.ActionTarget;
import org.odpi.openmetadata.frameworks.governanceaction.controls.Guard;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.OMFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementControlHeader;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.search.ElementProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public class ZonePublisherGovernanceActionConnector
extends RemediationGovernanceActionService {
    private List<String> publishZones = null;

    public void start() throws ConnectorCheckedException {
        Object publishZonesOption;
        String methodName = "start";
        super.start();
        Map configurationProperties = this.connectionDetails.getConfigurationProperties();
        if (configurationProperties != null && (publishZonesOption = configurationProperties.get(ZonePublisherRequestParameter.PUBLISH_ZONES.getName())) != null) {
            this.publishZones = this.getZoneArrayFromString(publishZonesOption.toString());
        }
        if (this.governanceContext.getRequestParameters() != null) {
            Map requestParameters = this.governanceContext.getRequestParameters();
            for (String requestParameterName : requestParameters.keySet()) {
                if (requestParameterName == null || !ZonePublisherRequestParameter.PUBLISH_ZONES.getName().equals(requestParameterName)) continue;
                this.publishZones = this.getZoneArrayFromString((String)requestParameters.get(requestParameterName));
            }
        }
        ArrayList<String> outputGuards = new ArrayList<String>();
        AuditLogMessageDefinition messageDefinition = null;
        try {
            CompletionStatus completionStatus;
            if (this.governanceContext.getActionTargetElements() == null) {
                messageDefinition = GovernanceActionConnectorsAuditCode.NO_TARGETS.getMessageDefinition(this.governanceServiceName);
                completionStatus = Guard.NO_TARGETS_DETECTED.getCompletionStatus();
                outputGuards.add(Guard.NO_TARGETS_DETECTED.getName());
            } else if (this.publishZones == null || this.publishZones.isEmpty()) {
                for (ActionTargetElement actionTarget : this.governanceContext.getActionTargetElements()) {
                    if (actionTarget == null || actionTarget.getTargetElement() == null || !this.propertyHelper.isTypeOf((ElementControlHeader)actionTarget.getTargetElement(), OpenMetadataType.ASSET.typeName)) continue;
                    OpenMetadataElement element = actionTarget.getTargetElement();
                    if (this.auditLog != null) {
                        this.auditLog.logMessage("start", GovernanceActionConnectorsAuditCode.SETTING_ZONES.getMessageDefinition(this.governanceServiceName, element.getElementGUID(), "<null>"));
                    }
                    this.governanceContext.declassifyMetadataElement(element.getElementGUID(), OpenMetadataType.ASSET_ZONE_MEMBERSHIP_CLASSIFICATION.typeName, true, false, new Date());
                }
                messageDefinition = GovernanceActionConnectorsAuditCode.NO_ZONES.getMessageDefinition(this.governanceServiceName);
                completionStatus = ZonePublisherGuard.NO_ZONES_DETECTED.getCompletionStatus();
                outputGuards.add(ZonePublisherGuard.NO_ZONES_DETECTED.getName());
            } else {
                ElementProperties properties = this.getZoneProperties();
                for (ActionTargetElement actionTarget : this.governanceContext.getActionTargetElements()) {
                    if (actionTarget == null || actionTarget.getTargetElement() == null || !ActionTarget.NEW_ASSET.getName().equals(actionTarget.getActionTargetName()) || !this.propertyHelper.isTypeOf((ElementControlHeader)actionTarget.getTargetElement(), OpenMetadataType.ASSET.typeName)) continue;
                    OpenMetadataElement element = actionTarget.getTargetElement();
                    this.auditLog.logMessage("start", GovernanceActionConnectorsAuditCode.SETTING_ZONES.getMessageDefinition(this.governanceServiceName, element.getElementGUID(), this.publishZones.toString()));
                    this.governanceContext.classifyMetadataElement(element.getElementGUID(), OpenMetadataType.ASSET_ZONE_MEMBERSHIP_CLASSIFICATION.typeName, true, false, properties, new Date());
                }
                completionStatus = ZonePublisherGuard.ZONE_ASSIGNED.getCompletionStatus();
                outputGuards.add(ZonePublisherGuard.ZONE_ASSIGNED.getName());
            }
            if (messageDefinition != null) {
                this.auditLog.logMessage("start", messageDefinition);
            }
            this.governanceContext.recordCompletionStatus(completionStatus, outputGuards, null, null, messageDefinition);
        }
        catch (OMFCheckedExceptionBase error) {
            throw new ConnectorCheckedException(error.getReportedErrorMessage(), error);
        }
        catch (Exception error) {
            throw new ConnectorCheckedException(GovernanceActionConnectorsErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.governanceServiceName, error.getClass().getName(), error.getMessage()), error.getClass().getName(), "start", error);
        }
    }

    private ElementProperties getZoneProperties() {
        return this.propertyHelper.addStringArrayProperty(null, OpenMetadataProperty.ZONE_MEMBERSHIP.name, this.publishZones);
    }

    private List<String> getZoneArrayFromString(String zones) {
        ArrayList<String> zoneArray = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(zones, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String zone = stringTokenizer.nextToken();
            String trimmedZone = zone.trim();
            if (trimmedZone.isEmpty()) continue;
            zoneArray.add(trimmedZone);
        }
        return zoneArray;
    }
}

