/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.governanceactions.stewardship;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.governanceactions.ffdc.GovernanceActionConnectorsAuditCode;
import org.odpi.openmetadata.adapters.connectors.governanceactions.ffdc.GovernanceActionConnectorsErrorCode;
import org.odpi.openmetadata.adapters.connectors.governanceactions.stewardship.CatalogTargetAssetGuard;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.governanceaction.GeneralGovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.controls.ActionTarget;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.search.ElementProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public class CatalogTargetAssetGovernanceActionConnector
extends GeneralGovernanceActionService {
    public void start() throws ConnectorCheckedException {
        String methodName = "start";
        super.start();
        try {
            CompletionStatus completionStatus;
            AuditLogMessageDefinition messageDefinition;
            ArrayList<String> outputGuards = new ArrayList<String>();
            ActionTargetElement integrationConnector = null;
            String newAssetGUID = null;
            if (this.governanceContext.getActionTargetElements() != null) {
                for (ActionTargetElement actionTargetElement : this.governanceContext.getActionTargetElements()) {
                    if (actionTargetElement == null) continue;
                    if (ActionTarget.INTEGRATION_CONNECTOR.getName().equals(actionTargetElement.getActionTargetName())) {
                        integrationConnector = actionTargetElement;
                        continue;
                    }
                    if (!ActionTarget.NEW_ASSET.getName().equals(actionTargetElement.getActionTargetName())) continue;
                    newAssetGUID = actionTargetElement.getActionTargetGUID();
                }
            }
            if (integrationConnector == null) {
                messageDefinition = GovernanceActionConnectorsAuditCode.NO_CONNECTOR.getMessageDefinition(this.governanceServiceName);
                outputGuards.add(CatalogTargetAssetGuard.MISSING_CONNECTOR.getName());
                completionStatus = CatalogTargetAssetGuard.MISSING_CONNECTOR.getCompletionStatus();
            } else if (newAssetGUID == null) {
                messageDefinition = GovernanceActionConnectorsAuditCode.MISSING_ACTION_TARGET.getMessageDefinition(this.governanceServiceName, ActionTarget.NEW_ASSET.getName());
                outputGuards.add(CatalogTargetAssetGuard.MISSING_ASSET.getName());
                completionStatus = CatalogTargetAssetGuard.MISSING_ASSET.getCompletionStatus();
            } else {
                OpenMetadataElement serverElement = this.governanceContext.getOpenMetadataStore().getMetadataElementByGUID(newAssetGUID);
                String serverName = this.propertyHelper.getStringProperty(this.governanceServiceName, OpenMetadataProperty.NAME.name, serverElement.getElementProperties(), "start");
                String serverType = serverElement.getType().getTypeName();
                String integrationConnectorName = this.propertyHelper.getStringProperty(this.governanceServiceName, OpenMetadataProperty.QUALIFIED_NAME.name, integrationConnector.getTargetElement().getElementProperties(), "start");
                ElementProperties catalogTargetProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.CATALOG_TARGET_NAME.name, serverName);
                catalogTargetProperties = this.propertyHelper.addMapProperty(catalogTargetProperties, OpenMetadataProperty.CONFIGURATION_PROPERTIES.name, this.combineProperties());
                this.governanceContext.getOpenMetadataStore().createRelatedElementsInStore(OpenMetadataType.CATALOG_TARGET_RELATIONSHIP.typeName, integrationConnector.getTargetElement().getElementGUID(), newAssetGUID, null, null, catalogTargetProperties);
                messageDefinition = GovernanceActionConnectorsAuditCode.CONNECTOR_CONFIGURED.getMessageDefinition(integrationConnectorName, serverType, serverName);
                completionStatus = CatalogTargetAssetGuard.SET_UP_COMPLETE.getCompletionStatus();
                outputGuards.add(CatalogTargetAssetGuard.SET_UP_COMPLETE.getName());
            }
            this.auditLog.logMessage("start", messageDefinition);
            this.governanceContext.recordCompletionStatus(completionStatus, outputGuards, null, null, messageDefinition);
        }
        catch (Exception error) {
            throw new ConnectorCheckedException(GovernanceActionConnectorsErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.governanceServiceName, error.getClass().getName(), error.getMessage()), error.getClass().getName(), "start", error);
        }
    }

    Map<String, Object> combineProperties() {
        HashMap<String, Object> configurationProperties = new HashMap<String, Object>();
        if (this.connectionDetails.getConfigurationProperties() != null) {
            configurationProperties.putAll(this.connectionDetails.getConfigurationProperties());
        }
        if (this.governanceContext.getRequestParameters() != null) {
            configurationProperties.putAll(this.governanceContext.getRequestParameters());
        }
        if (configurationProperties.isEmpty()) {
            return null;
        }
        return configurationProperties;
    }
}

